/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.EnumMap;
import java.util.Objects;
import mod.chloeprime.aaaparticles.client.internal.EffekFpvRenderer;
import mod.chloeprime.aaaparticles.client.internal.RenderContext;
import mod.chloeprime.aaaparticles.client.internal.RenderStateCapture;
import mod.chloeprime.aaaparticles.client.render.EffekRenderer;
import mod.chloeprime.aaaparticles.client.render.ItemTransformHooks;
import mod.chloeprime.aaaparticles.client.render.RenderUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class}, priority=1005)
public class MixinItemInHandRenderer
implements EffekFpvRenderer {
    @Shadow
    @Final
    private Minecraft f_109299_;
    @Shadow
    @Final
    private ItemRenderer f_109307_;
    @Unique
    private final EnumMap<InteractionHand, RenderStateCapture> aaaParticles$captures = new EnumMap(InteractionHand.class);
    @Unique
    private final boolean aaaParticles$DISABLE_FPV_RENDERING = Boolean.getBoolean("mod.chloeprime.aaaparticles.disableFpvRendering");

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")})
    private void resetCaptureState(AbstractClientPlayer player, float f, float g, InteractionHand hand, float h, ItemStack itemStack, float i, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, CallbackInfo ci) {
        RenderStateCapture capture = this.aaaParticles$captures.computeIfAbsent(hand, arg -> new RenderStateCapture());
        capture.hasCapture = false;
        capture.item = null;
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void setFpvRenderState(AbstractClientPlayer player, float partial, float g, InteractionHand hand, float h, ItemStack stack, float i, PoseStack poseStack, MultiBufferSource buffer, int j, CallbackInfo ci) {
        PoseStack.Pose stackTop = poseStack.m_85850_();
        RenderStateCapture capture = Objects.requireNonNull(this.aaaParticles$captures.get(hand));
        capture.hasCapture = true;
        capture.pose.m_85850_().m_252922_().set((Matrix4fc)stackTop.m_252922_());
        capture.pose.m_85850_().m_252943_().set((Matrix3fc)stackTop.m_252943_());
        capture.projection.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        capture.item = stack;
    }

    @Inject(method={"renderHandsWithItems"}, at={@At(value="RETURN")})
    private void captureHandDepth(float partial, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, LocalPlayer player, int i, CallbackInfo ci) {
        if (RenderContext.renderHandDeferred()) {
            if (RenderContext.captureHandDepth()) {
                RenderUtil.copyCurrentDepthTo(RenderStateCapture.CAPTURED_HAND_DEPTH_BUFFER);
            }
        } else {
            this.aaaParticles$renderFpvEffek(partial, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aaaParticles$renderFpvEffek(float partial, LocalPlayer player) {
        if (this.aaaParticles$DISABLE_FPV_RENDERING) {
            return;
        }
        Matrix4f oldProjection = RenderSystem.getProjectionMatrix();
        VertexSorting oldVertexSort = RenderSystem.getVertexSorting();
        try {
            Camera camera = this.f_109299_.f_91063_.m_109153_();
            this.aaaParticles$captures.forEach((hand, capture) -> {
                if (capture.hasCapture && capture.item != null) {
                    RenderSystem.setProjectionMatrix((Matrix4f)capture.projection, (VertexSorting)oldVertexSort);
                    HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                    ItemDisplayContext tran = switch (arm) {
                        default -> throw new IncompatibleClassChangeError();
                        case HumanoidArm.LEFT -> ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
                        case HumanoidArm.RIGHT -> ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                    };
                    PoseStack poseStack = capture.pose;
                    poseStack.m_85836_();
                    BakedModel model = this.f_109307_.m_174264_(capture.item, player.m_9236_(), (LivingEntity)player, player.m_19879_() + tran.ordinal());
                    ItemTransformHooks.applyItemTransform(poseStack, model, tran, arm == HumanoidArm.LEFT);
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                    EffekRenderer.onRenderHand(partial, hand, poseStack, capture.projection, camera);
                    poseStack.m_85849_();
                }
                capture.item = null;
            });
        }
        finally {
            RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (VertexSorting)oldVertexSort);
        }
    }
}

