/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.blocks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.teamabyssalofficial.blocks.blockentity.LandmineBlockEntity;
import net.teamabyssalofficial.blocks.scratch.TickableBlockEntity;
import net.teamabyssalofficial.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandmineBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock,
SoundUtils {
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_N = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)1.0, (double)10.0), Block.m_49796_((double)6.75, (double)1.5, (double)6.75, (double)9.25, (double)1.75, (double)9.25), Block.m_49796_((double)7.4, (double)1.75, (double)7.4, (double)8.6, (double)2.0, (double)8.6), Block.m_49796_((double)7.75, (double)0.01, (double)3.825, (double)12.0, (double)0.99, (double)8.05), Block.m_49796_((double)7.75, (double)0.01, (double)7.825, (double)12.0, (double)0.99, (double)12.05), Block.m_49796_((double)3.75, (double)0.01, (double)7.825, (double)8.025, (double)0.99, (double)12.05), Block.m_49796_((double)3.75, (double)0.01, (double)3.825, (double)8.0, (double)0.99, (double)7.925), Block.m_49796_((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)1.0, (double)6.0), Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0, (double)13.0), Block.m_49796_((double)7.0, (double)1.0, (double)3.5, (double)9.0, (double)1.5, (double)7.0), Block.m_49796_((double)7.0, (double)1.0, (double)9.0, (double)9.0, (double)1.5, (double)12.5), Block.m_49796_((double)3.5, (double)1.0, (double)7.0, (double)12.5, (double)1.5, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.m_49796_((double)5.9867417478527525, (double)0.0, (double)2.9867417478527525, (double)9.986741747852752, (double)1.0, (double)12.986741747852752), Block.m_49796_((double)6.746116747852753, (double)1.5, (double)6.740625, (double)9.246116747852751, (double)1.75, (double)9.240625), Block.m_49796_((double)7.396116747852751, (double)1.75, (double)7.390625000000002, (double)8.596116747852752, (double)2.0, (double)8.590625000000001), Block.m_49796_((double)5.879695391615442, (double)0.01, (double)3.0207765190165006, (double)10.104695391615444, (double)0.99, (double)7.270776519016501), Block.m_49796_((double)8.708122516361632, (double)0.01, (double)5.84920364376269, (double)12.933122516361633, (double)0.99, (double)10.09920364376269), Block.m_49796_((double)5.879695391615442, (double)0.01, (double)8.65263076850888, (double)10.104695391615444, (double)0.99, (double)12.927630768508882), Block.m_49796_((double)3.0512682668692523, (double)0.01, (double)5.84920364376269, (double)7.151268266869252, (double)0.99, (double)10.09920364376269), Block.m_49796_((double)2.9867417478527525, (double)0.0, (double)5.9867417478527525, (double)5.9867417478527525, (double)1.0, (double)9.986741747852752), Block.m_49796_((double)9.986741747852752, (double)0.0, (double)5.9867417478527525, (double)12.986741747852752, (double)1.0, (double)9.986741747852752), Block.m_49796_((double)3.4867417478527525, (double)1.0, (double)6.9867417478527525, (double)6.9867417478527525, (double)1.5, (double)8.986741747852752), Block.m_49796_((double)8.986741747852752, (double)1.0, (double)6.9867417478527525, (double)12.486741747852752, (double)1.5, (double)8.986741747852752), Block.m_49796_((double)6.9867417478527525, (double)1.0, (double)3.4867417478527525, (double)8.986741747852752, (double)1.5, (double)12.486741747852752)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.m_49796_((double)2.973483495705505, (double)0.0, (double)6.0, (double)12.973483495705505, (double)1.0, (double)10.0), Block.m_49796_((double)6.727366747852752, (double)1.5, (double)6.740625000000001, (double)9.227366747852752, (double)1.75, (double)9.240625), Block.m_49796_((double)7.377366747852754, (double)1.75, (double)7.390625, (double)8.577366747852754, (double)2.0, (double)8.590625000000001), Block.m_49796_((double)3.007518266869253, (double)0.01, (double)5.882046356237309, (double)7.257518266869253, (double)0.99, (double)10.10704635623731), Block.m_49796_((double)5.835945391615443, (double)0.01, (double)3.053619231491119, (double)10.085945391615443, (double)0.99, (double)7.2786192314911204), Block.m_49796_((double)8.639372516361632, (double)0.01, (double)5.882046356237309, (double)12.914372516361635, (double)0.99, (double)10.10704635623731), Block.m_49796_((double)5.835945391615443, (double)0.01, (double)8.8354734809835, (double)10.085945391615443, (double)0.99, (double)12.9354734809835), Block.m_49796_((double)5.973483495705505, (double)0.0, (double)10.0, (double)9.973483495705505, (double)1.0, (double)13.0), Block.m_49796_((double)5.973483495705505, (double)0.0, (double)3.0, (double)9.973483495705505, (double)1.0, (double)6.0), Block.m_49796_((double)6.973483495705505, (double)1.0, (double)9.0, (double)8.973483495705505, (double)1.5, (double)12.5), Block.m_49796_((double)6.973483495705505, (double)1.0, (double)3.5, (double)8.973483495705505, (double)1.5, (double)7.0), Block.m_49796_((double)3.473483495705505, (double)1.0, (double)7.0, (double)12.473483495705505, (double)1.5, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.m_49796_((double)5.9867417478527525, (double)0.0, (double)3.0132582521472475, (double)9.986741747852752, (double)1.0, (double)13.013258252147248), Block.m_49796_((double)6.727366747852754, (double)1.5, (double)6.759375, (double)9.227366747852752, (double)1.75, (double)9.259375), Block.m_49796_((double)7.3773667478527525, (double)1.75, (double)7.409374999999999, (double)8.577366747852754, (double)2.0, (double)8.609374999999998), Block.m_49796_((double)5.868788104090061, (double)0.01, (double)8.7292234809835, (double)10.093788104090063, (double)0.99, (double)12.9792234809835), Block.m_49796_((double)3.0403609793438715, (double)0.01, (double)5.90079635623731, (double)7.265360979343873, (double)0.99, (double)10.15079635623731), Block.m_49796_((double)5.868788104090061, (double)0.01, (double)3.072369231491118, (double)10.093788104090063, (double)0.99, (double)7.34736923149112), Block.m_49796_((double)8.822215228836253, (double)0.01, (double)5.90079635623731, (double)12.922215228836253, (double)0.99, (double)10.15079635623731), Block.m_49796_((double)9.986741747852752, (double)0.0, (double)6.0132582521472475, (double)12.986741747852752, (double)1.0, (double)10.013258252147248), Block.m_49796_((double)2.9867417478527525, (double)0.0, (double)6.0132582521472475, (double)5.9867417478527525, (double)1.0, (double)10.013258252147248), Block.m_49796_((double)8.986741747852752, (double)1.0, (double)7.0132582521472475, (double)12.486741747852752, (double)1.5, (double)9.013258252147248), Block.m_49796_((double)3.4867417478527525, (double)1.0, (double)7.0132582521472475, (double)6.9867417478527525, (double)1.5, (double)9.013258252147248), Block.m_49796_((double)6.9867417478527525, (double)1.0, (double)3.5132582521472475, (double)8.986741747852752, (double)1.5, (double)12.513258252147248)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public LandmineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56742_).m_155954_(0.8f).m_60978_(0.8f).m_155956_(2.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LandmineBlockEntity(pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TickableBlockEntity.getTickerHelper(level);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof PickaxeItem) {
            PickaxeItem tieredItem = (PickaxeItem)item;
            return tieredItem.m_43314_().m_6604_() >= 0;
        }
        return false;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List dropsOriginal = super.m_49635_(pState, pParams);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public BlockState m_7417_(BlockState value, Direction pDirection, BlockState blockState, LevelAccessor aVoid, BlockPos blockPos, BlockPos blockPos1) {
        if (pDirection.m_122424_() == value.m_61143_((Property)FACING) && !value.m_60710_((LevelReader)aVoid, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)value.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            aVoid.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)aVoid));
        }
        return super.m_7417_(value, pDirection, blockState, aVoid, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
        }
        return SHAPE_E;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext clickedFace) {
        return (BlockState)super.m_5573_(clickedFace).m_61124_((Property)FACING, (Comparable)clickedFace.m_8125_());
    }

    public BlockState m_6843_(BlockState pState, Rotation rotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        LandmineBlockEntity landmineBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LandmineBlockEntity && (landmineBlockEntity = (LandmineBlockEntity)blockEntity).canExplode()) {
            landmineBlockEntity.onTouch(entity, level, pos);
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.m_5776_()) {
            pLevel.m_5594_(null, pPos, (SoundEvent)SoundRegistry.LANDMINE_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }
}

