/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.teamabyssalofficial.client.ClientShaders;
import net.teamabyssalofficial.client.special.GeckoRenderTypes;
import net.teamabyssalofficial.dotf.ClientProxy;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.util.PerformanceEngine;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GeckoEnergyShieldLayer<T extends LivingEntity>
extends GeoRenderLayer<T> {
    private static final ResourceLocation ENERGY_SHIELD_TEXTURE = new ResourceLocation("dotf", "textures/mob/layer/energy_shield.png");

    public GeckoEnergyShieldLayer(GeoRenderer<T> entityRendererIn, EntityRendererProvider.Context context) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        SangheiliFormEntity sangheiliFormEntity;
        if (animatable instanceof SangheiliFormEntity && (sangheiliFormEntity = (SangheiliFormEntity)((Object)animatable)).hasEnergyShield()) {
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                ClientShaders.renderEffectForNextTick(ClientProxy.ENERGY_SHIELD_SHADER);
                RenderType energyType = GeckoRenderTypes.getEnergyShieldGlow(ENERGY_SHIELD_TEXTURE);
                this.completeRendering(animatable, poseStack, bufferSource, renderType, energyType, partialTick, packedLight);
            } else {
                RenderType type = RenderType.m_110494_((ResourceLocation)ENERGY_SHIELD_TEXTURE);
                this.completeRendering(animatable, poseStack, bufferSource, renderType, type, partialTick, packedLight);
            }
        }
    }

    public void completeRendering(T animatable, PoseStack poseStack, MultiBufferSource bufferSource, RenderType renderType, RenderType energyType, float partialTick, int packedLight) {
        float pAlpha = 0.55f;
        if (animatable instanceof SangheiliFormEntity) {
            SangheiliFormEntity sangheiliFormEntity = (SangheiliFormEntity)((Object)animatable);
            pAlpha = sangheiliFormEntity.shieldOpacity;
        }
        this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderType, bufferSource.m_6299_(energyType), partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, pAlpha);
    }
}

