/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.client.layer.GeckoEnergyShieldLayer;
import net.teamabyssalofficial.client.model.SangheiliFormModel;
import net.teamabyssalofficial.client.renderer.layer.SangheiliFormLayerRenderer;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.guns.muzzle_flash.GunMuzzleFlashResources;
import net.teamabyssalofficial.guns.muzzle_flash.GunMuzzleVisuals;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.util.PerformanceEngine;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class SangheiliFormRenderer
extends GeoEntityRenderer<SangheiliFormEntity> {
    SangheiliFormEntity golem;
    MultiBufferSource bufferIn;
    ResourceLocation text;

    public SangheiliFormRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new SangheiliFormModel());
        this.f_114477_ = 0.0f;
        this.addRenderLayer(new GeckoEnergyShieldLayer(this, renderManagerIn));
        if (((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_glow.get()).booleanValue() && !PerformanceEngine.hasPerformanceModeOn()) {
            this.addRenderLayer(new SangheiliFormLayerRenderer((GeoRenderer<SangheiliFormEntity>)this));
        }
    }

    public void preRender(PoseStack poseStack, SangheiliFormEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem = animatable;
        this.bufferIn = bufferSource;
        this.text = this.m_5478_((Entity)animatable);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(SangheiliFormEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        StackScaler stackScaler = entity.stackScaler;
        poseStack.m_85841_(stackScaler.getpX(), stackScaler.getpY(), stackScaler.getpZ());
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack stack, SangheiliFormEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(stack, (Entity)animatable, bone, renderType, this.bufferIn, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (bone.getName().equals("item")) {
            stack.m_85836_();
            if (animatable.getGunVariant() != 4) {
                stack.m_85841_(1.95f, 1.95f, 1.95f);
            } else {
                stack.m_85841_(1.75f, 1.75f, 1.75f);
            }
            switch (animatable.getGunVariant()) {
                case 1: {
                    stack.m_85837_(-0.38, 0.46, 1.13);
                    break;
                }
                case 2: {
                    stack.m_85837_(-0.37, 0.43, 1.13);
                    break;
                }
                case 3: {
                    stack.m_85837_(-0.37, 0.48, 1.05);
                    break;
                }
                case 4: {
                    stack.m_85837_(-0.33, 0.45, 1.09);
                    break;
                }
                case 5: {
                    stack.m_85837_(-0.37, 0.52, 1.19);
                }
            }
            stack.m_252781_(Axis.f_252529_.m_252977_(-85.0f));
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            ItemStack itemstack = animatable.m_21205_();
            if (!itemstack.m_41619_()) {
                Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.f_118083_, stack, this.bufferIn, animatable.m_9236_(), 0);
            }
            if (animatable.isMuzzleFlashRendered()) {
                switch (animatable.getGunVariant()) {
                    case 1: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.45f, 16, -2.6f, -3.1f, -0.8f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                        break;
                    }
                    case 2: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.45f, 16, -2.5f, -2.7f, -0.8f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                        break;
                    }
                    case 3: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.5f, 16, -2.4f, -3.0f, -0.8f, GunMuzzleFlashResources.AMETHYST_MUZZLE_FLASH_TEXTURE);
                        break;
                    }
                    case 5: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.5f, 16, -2.4f, -2.8f, -1.3f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                    }
                }
            }
            stack.m_85849_();
            buffer = this.bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
        }
    }
}

