/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.teamabyssalofficial.client.layer.GeckoArmorLayer;
import net.teamabyssalofficial.client.layer.GeckoCapeLayer;
import net.teamabyssalofficial.client.layer.GeckoElytraLayer;
import net.teamabyssalofficial.client.layer.GeckoParrotOnShoulderLayer;
import net.teamabyssalofficial.client.layer.GeckoPlayerItemInHandLayer;
import net.teamabyssalofficial.client.layer.IGeckoRenderLayer;
import net.teamabyssalofficial.client.special.GeckoRenderingUtils;
import net.teamabyssalofficial.client.special.model.AnimatedBipedModel;
import net.teamabyssalofficial.client.special.model.AnimatedPlayerModel;
import net.teamabyssalofficial.client.special.model.ModelGeckoPlayerThirdPerson;
import net.teamabyssalofficial.client.special.model.OptimizedGeoBone;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class GeckoRenderPlayer
extends PlayerRenderer
implements GeoRenderer<GeckoPlayer> {
    public MultiBufferSource rtb;
    private static HashMap<Class<? extends GeckoPlayer>, GeckoRenderPlayer> modelsToLoad = new HashMap();
    private ModelGeckoPlayerThirdPerson geoModel;
    private Matrix4f worldRenderMat;
    public Vec3 betweenHandsPos;
    public Vec3 particleEmitterRoot;
    private boolean isInvisible = false;
    private GeckoPlayer animatable;

    public GeckoRenderPlayer(EntityRendererProvider.Context context, boolean slim, ModelGeckoPlayerThirdPerson geoModel) {
        super(context, slim);
        AnimatedPlayerModel modelPlayerAnimated = new AnimatedPlayerModel(context.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim);
        AnimatedPlayerModel.setUseMatrixMode(modelPlayerAnimated, true);
        this.f_115290_ = modelPlayerAnimated;
        this.f_115291_.clear();
        this.m_115326_((RenderLayer)new GeckoArmorLayer(this, new AnimatedBipedModel(context.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new AnimatedBipedModel(context.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_(new GeckoPlayerItemInHandLayer(this));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new Deadmau5EarsLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new GeckoCapeLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_((RenderLayer)new GeckoElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new GeckoParrotOnShoulderLayer(this, context.m_174027_()));
        this.m_115326_((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.geoModel = geoModel;
        this.geoModel.setUseSmallArms(slim);
        this.worldRenderMat = new Matrix4f();
        this.worldRenderMat.identity();
    }

    public ModelGeckoPlayerThirdPerson getGeckoModel() {
        return this.geoModel;
    }

    public HashMap<Class<? extends GeckoPlayer>, GeckoRenderPlayer> getModelsToLoad() {
        return modelsToLoad;
    }

    public void render(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GeckoPlayer geckoPlayer) {
        this.rtb = bufferIn;
        this.setModelVisibilities(entityIn);
        this.renderLiving(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn, geckoPlayer);
    }

    private void setModelVisibilities(AbstractClientPlayer clientPlayer) {
        ModelGeckoPlayerThirdPerson playermodel = this.getGeckoModel();
        if (playermodel.isInitialized()) {
            if (clientPlayer.m_5833_()) {
                playermodel.setVisible(false);
                playermodel.bipedHead().setHidden(false);
                playermodel.bipedHeadwear().setHidden(false);
            } else {
                playermodel.setVisible(true);
                playermodel.bipedHeadwear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.HAT));
                playermodel.bipedBodywear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.JACKET));
                playermodel.bipedLeftLegwear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.LEFT_PANTS_LEG));
                playermodel.bipedRightLegwear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG));
                playermodel.bipedLeftArmwear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.LEFT_SLEEVE));
                playermodel.bipedRightArmwear().setHidden(!clientPlayer.m_36170_(PlayerModelPart.RIGHT_SLEEVE));
                playermodel.isSneak = clientPlayer.m_6047_();
                HumanoidModel.ArmPose bipedmodel$armpose = GeckoRenderPlayer.m_117794_((AbstractClientPlayer)clientPlayer, (InteractionHand)InteractionHand.MAIN_HAND);
                HumanoidModel.ArmPose bipedmodel$armpose1 = GeckoRenderPlayer.m_117794_((AbstractClientPlayer)clientPlayer, (InteractionHand)InteractionHand.OFF_HAND);
                if (bipedmodel$armpose.m_102897_()) {
                    HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
                }
                if (clientPlayer.m_5737_() == HumanoidArm.RIGHT) {
                    this.geoModel.rightArmPose = bipedmodel$armpose;
                    this.geoModel.leftArmPose = bipedmodel$armpose1;
                } else {
                    this.geoModel.rightArmPose = bipedmodel$armpose1;
                    this.geoModel.leftArmPose = bipedmodel$armpose;
                }
            }
        }
    }

    public void renderLiving(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GeckoPlayer geckoPlayer) {
        this.animatable = geckoPlayer;
        matrixStackIn.m_85836_();
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)entityIn);
        this.isInvisible = !flag && !flag1 && !flag2;
        RenderType rendertype = this.m_7225_((LivingEntity)entityIn, flag, flag1, flag2);
        if (this.isInvisible) {
            rendertype = ((PlayerModel)this.f_115290_).m_103119_(this.getTextureLocation(geckoPlayer));
        }
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(rendertype);
            this.defaultRender(matrixStackIn, (GeoAnimatable)this.animatable, bufferIn, rendertype, ivertexbuilder, 0.0f, partialTicks, packedLightIn);
        }
        matrixStackIn.m_85849_();
        this.renderEntity(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public int getPackedOverlay(GeckoPlayer animatable, float u, float partialTick) {
        AbstractClientPlayer player = (AbstractClientPlayer)animatable.getPlayer();
        return GeckoRenderPlayer.m_115338_((LivingEntity)player, (float)this.m_6931_((LivingEntity)player, partialTick));
    }

    public void actuallyRender(PoseStack poseStack, GeckoPlayer animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction direction;
        boolean shouldSit;
        AbstractClientPlayer entity = (AbstractClientPlayer)animatable.getPlayer();
        ((PlayerModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entity, partialTick);
        ((PlayerModel)this.f_115290_).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        ((PlayerModel)this.f_115290_).f_102610_ = entity.m_6162_();
        float f_lerpBodyRot = Mth.m_14189_((float)partialTick, (float)entity.f_20884_, (float)entity.f_20883_);
        float f1_lerpHeadRot = Mth.m_14189_((float)partialTick, (float)entity.f_20886_, (float)entity.f_20885_);
        float f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f_lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
            float f3 = Mth.m_14177_((float)f2_netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f_lerpBodyRot = f1_lerpHeadRot - f3;
            if (f3 * f3 > 2500.0f) {
                f_lerpBodyRot += f3 * 0.2f;
            }
            f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
        }
        float f6 = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        if (GeckoRenderPlayer.m_194453_((LivingEntity)entity)) {
            f6 *= -1.0f;
            f2_netHeadYaw *= -1.0f;
        }
        if (entity.m_217003_(Pose.SLEEPING) && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * f4, 0.0f, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = this.m_6930_((LivingEntity)entity, partialTick);
        this.m_7546_(entity, poseStack, partialTick);
        float f8_limbSwingAmount = 0.0f;
        float f5_limbSwing = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            f8_limbSwingAmount = entity.f_267362_.m_267711_(partialTick);
            f5_limbSwing = entity.f_267362_.m_267590_(partialTick);
            if (entity.m_6162_()) {
                f5_limbSwing *= 3.0f;
            }
            if (f8_limbSwingAmount > 1.0f) {
                f8_limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = entity.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            AnimationState animationState = new AnimationState((GeoAnimatable)animatable, f5_limbSwing, f8_limbSwingAmount, partialTick, avgVelocity >= motionThreshold && f8_limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId((GeoAnimatable)animatable);
            AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
            animationState.setData(DataTickets.TICK, (Object)(animatable.getTick(animatable) + animatableManager.getFirstTickTime() + (double)Minecraft.m_91087_().m_91296_()));
            animationState.setData(DataTickets.ENTITY, (Object)entity);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(shouldSit, entity.m_6162_(), -f2_netHeadYaw, -headPitch));
            this.getGeckoModel().addAdditionalStateData((GeoAnimatable)animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.getGeckoModel().handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        if (this.geoModel.isInitialized()) {
            this.setupRotations(entity, poseStack, f7, f_lerpBodyRot, partialTick, f1_lerpHeadRot);
            float bodyRotateAmount = this.geoModel.getControllerValueInverted("BodyRotateController");
            this.geoModel.setRotationAngles((Player)entity, f5_limbSwing, f8_limbSwingAmount, f7, Mth.m_14189_((float)bodyRotateAmount, (float)0.0f, (float)f2_netHeadYaw), f6, partialTick);
            OptimizedGeoBone leftHeldItem = this.geoModel.getOptimizedBone("LeftHeldItem");
            OptimizedGeoBone rightHeldItem = this.geoModel.getOptimizedBone("RightHeldItem");
            Matrix4f worldMatInverted = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            worldMatInverted.invert();
            Matrix3f worldNormInverted = new Matrix3f((Matrix3fc)poseStack.m_85850_().m_252943_());
            worldNormInverted.invert();
            PoseStack toWorldSpace = new PoseStack();
            toWorldSpace.m_252781_(GeckoRenderingUtils.quatFromRotationXYZ(0.0f, -f_lerpBodyRot + 180.0f, 0.0f, true));
            toWorldSpace.m_252880_(0.0f, -1.5f, 0.0f);
            toWorldSpace.m_85850_().m_252943_().mul((Matrix3fc)worldNormInverted);
            toWorldSpace.m_85850_().m_252922_().mul((Matrix4fc)worldMatInverted);
            Vector4f leftHeldItemPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            leftHeldItemPos.mul((Matrix4fc)leftHeldItem.getWorldSpaceMatrix());
            leftHeldItemPos.mul((Matrix4fc)toWorldSpace.m_85850_().m_252922_());
            Vec3 leftHeldItemPos3 = new Vec3((double)leftHeldItemPos.x(), (double)leftHeldItemPos.y(), (double)leftHeldItemPos.z());
            Vector4f rightHeldItemPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            rightHeldItemPos.mul((Matrix4fc)rightHeldItem.getWorldSpaceMatrix());
            rightHeldItemPos.mul((Matrix4fc)toWorldSpace.m_85850_().m_252922_());
            Vec3 rightHeldItemPos3 = new Vec3((double)rightHeldItemPos.x(), (double)rightHeldItemPos.y(), (double)rightHeldItemPos.z());
            this.betweenHandsPos = rightHeldItemPos3.m_82549_(leftHeldItemPos3.m_82546_(rightHeldItemPos3).m_82490_(0.5));
            OptimizedGeoBone particleEmitterRootBone = this.geoModel.getOptimizedBone("ParticleEmitterRoot");
            Vector4f emitterRootPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            emitterRootPos.mul((Matrix4fc)particleEmitterRootBone.getWorldSpaceMatrix());
            emitterRootPos.mul((Matrix4fc)toWorldSpace.m_85850_().m_252922_());
            this.particleEmitterRoot = new Vec3((double)emitterRootPos.x(), (double)emitterRootPos.y(), (double)emitterRootPos.z());
        }
        poseStack.m_252880_(0.0f, 0.01f, 0.0f);
        if (!entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        AnimatedPlayerModel.copyFromGeckoModel((PlayerModel)this.f_115290_, this.geoModel);
        if (!entity.m_5833_()) {
            for (RenderLayer layerrenderer : this.f_115291_) {
                layerrenderer.m_6494_(poseStack, bufferSource, packedLight, (Entity)entity, f5_limbSwing, f8_limbSwingAmount, partialTick, f7, f2_netHeadYaw, f6);
            }
        }
    }

    public void renderEntity(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        RenderNameTagEvent renderNameplateEvent = new RenderNameTagEvent((Entity)entityIn, entityIn.m_5446_(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.m_6512_((LivingEntity)entityIn))) {
            this.m_7649_(entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected void setupRotations(AbstractClientPlayer entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float headYaw) {
        float f = entityLiving.m_20998_(partialTicks);
        if (entityLiving.m_21255_()) {
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
            float f1 = (float)entityLiving.m_21256_() + partialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.m_21209_()) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - entityLiving.m_146909_())));
            }
            Vec3 vector3d = entityLiving.m_20252_(partialTicks);
            Vec3 vector3d1 = entityLiving.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            float swimController = this.geoModel.getControllerValueInverted("SwimController");
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
            float f3 = entityLiving.m_20069_() || entityLiving.isInFluidType((fluidType, height) -> entityLiving.canSwimInFluidType(fluidType)) ? -90.0f - entityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3) * swimController;
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(f4));
            if (entityLiving.m_6067_()) {
                matrixStackIn.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
        }
    }

    protected void applyRotationsLivingRenderer(AbstractClientPlayer entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float headYaw) {
        Pose pose;
        if (this.m_5936_((LivingEntity)entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entityLiving.m_20089_()) != Pose.SLEEPING) {
            float bodyRotateAmount = this.geoModel.getControllerValueInverted("BodyRotateController");
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f - Mth.m_14189_((float)bodyRotateAmount, (float)headYaw, (float)rotationYaw)));
        }
        if (entityLiving.f_20919_ > 0) {
            float f = ((float)entityLiving.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(f * this.m_6441_((LivingEntity)entityLiving)));
        } else if (entityLiving.m_21209_()) {
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f - entityLiving.m_146909_()));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(((float)entityLiving.f_19797_ + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? GeckoRenderPlayer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entityLiving)));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (GeckoRenderPlayer.m_194453_((LivingEntity)entityLiving)) {
            matrixStackIn.m_252880_(0.0f, entityLiving.m_20206_() + 0.1f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    public GeoModel<GeckoPlayer> getGeoModel() {
        return this.geoModel;
    }

    public GeckoPlayer getAnimatable() {
        return this.animatable;
    }

    public ModelGeckoPlayerThirdPerson getAnimatedPlayerModel() {
        return this.geoModel;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer geckoPlayer) {
        return this.m_5478_((AbstractClientPlayer)geckoPlayer.getPlayer());
    }

    public void renderRecursively(PoseStack poseStack, GeckoPlayer animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        OptimizedGeoBone optimizedGeoBone;
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
        if (bone instanceof OptimizedGeoBone && ((optimizedGeoBone = (OptimizedGeoBone)bone).getName().equals("LeftHeldItem") || optimizedGeoBone.getName().equals("RightHeldItem") || optimizedGeoBone.getName().equals("Head") || optimizedGeoBone.getName().equals("Body") || optimizedGeoBone.getName().equals("BodyLayer") || optimizedGeoBone.getName().equals("LeftArm") || optimizedGeoBone.getName().equals("RightArm") || optimizedGeoBone.getName().equals("RightLeg") || optimizedGeoBone.getName().equals("LeftLeg") || optimizedGeoBone.getName().equals("ParticleEmitterRoot"))) {
            poseStack.m_85836_();
            if (!optimizedGeoBone.getName().equals("LeftHeldItem") && !optimizedGeoBone.getName().equals("RightHeldItem")) {
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            }
            if (optimizedGeoBone.getName().equals("Body")) {
                poseStack.m_85837_(0.0, -0.75, 0.0);
            }
            if (optimizedGeoBone.getName().equals("LeftArm")) {
                poseStack.m_85837_(-0.075, 0.0, 0.0);
            }
            if (optimizedGeoBone.getName().equals("RightArm")) {
                poseStack.m_85837_(0.075, 0.0, 0.0);
            }
            PoseStack.Pose entry = poseStack.m_85850_();
            optimizedGeoBone.setWorldSpaceNormal(new Matrix3f((Matrix3fc)entry.m_252943_()));
            optimizedGeoBone.setWorldSpaceMatrix(new Matrix4f((Matrix4fc)entry.m_252922_()));
            poseStack.m_85849_();
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
        for (RenderLayer layerrenderer : this.f_115291_) {
            if (!(layerrenderer instanceof IGeckoRenderLayer)) continue;
            ((IGeckoRenderLayer)layerrenderer).renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public void updateAnimatedTextureFrame(GeckoPlayer animatable) {
        AnimatableTexture.setAndUpdate((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }
}

