/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DawnOfTheFloodConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final DataGen DATAGEN;
    public static final ForgeConfigSpec DATAGEN_SPEC;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)commonSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(DataGen::new);
        DATAGEN = (DataGen)commonPair.getLeft();
        DATAGEN_SPEC = (ForgeConfigSpec)commonPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> hasPerformanceModeOn;
        public final ForgeConfigSpec.ConfigValue<Boolean> hasPlayerCustomAnimations;
        public final ForgeConfigSpec.ConfigValue<Boolean> hasHaloCrosshairs;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowsFogChanges;
        public final ForgeConfigSpec.ConfigValue<Double> fogFactor;
        public final ForgeConfigSpec.ConfigValue<Boolean> frag_grenade_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableGlassBreaking;
        public final ForgeConfigSpec.ConfigValue<Boolean> fragileBlockDrops;
        public final ForgeConfigSpec.ConfigValue<Double> fragileBaseBreakChance;
        public final ForgeConfigSpec.ConfigValue<Double> gun_bullet_knockback;
        public final ForgeConfigSpec.ConfigValue<Boolean> gun_bullet_crit;
        public final ForgeConfigSpec.ConfigValue<Boolean> camera_animations;
        public final ForgeConfigSpec.ConfigValue<Boolean> gun_sprint_animation;
        public final ForgeConfigSpec.ConfigValue<Double> gun_bullet_crit_chance;
        public final ForgeConfigSpec.ConfigValue<Double> gun_bob_intensity;
        public final ForgeConfigSpec.ConfigValue<Boolean> gun_spawn_smoke;
        public final ForgeConfigSpec.ConfigValue<Double> gun_aiming_mouse_sensitivity;
        public final ForgeConfigSpec.ConfigValue<Double> gun_shot_sound_distance;
        public final ForgeConfigSpec.ConfigValue<Double> magnum_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> mk50_sidekick_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> m90_shotgun_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> needler_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> flood_attackers_list;
        public final ForgeConfigSpec.ConfigValue<Integer> mob_cap;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimension_parameters;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawns;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> flood_sickness;
        public final ForgeConfigSpec.ConfigValue<Integer> mobSpawnAttempts;
        public final ForgeConfigSpec.ConfigValue<Integer> additionalHordeMobs;
        public final ForgeConfigSpec.ConfigValue<Integer> ticksBeforeHordeSpawning;
        public final ForgeConfigSpec.ConfigValue<Integer> additionalRandomizedTicks;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_horde;
        public final ForgeConfigSpec.ConfigValue<Double> base_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> base_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> marine_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> marine_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> sangheili_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> sangheili_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> enderman_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> enderman_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_explosion_damage;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_age;
        public final ForgeConfigSpec.ConfigValue<Integer> base_to_carrier_form_age;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_health;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_damage;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_extra_explosion_damage;
        public final ForgeConfigSpec.ConfigValue<Integer> pod_infector_ticks_before_exploding;
        public final ForgeConfigSpec.ConfigValue<Boolean> pod_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> pod_infector_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> pod_infector_instant_latch_kill;
        public final ForgeConfigSpec.ConfigValue<Double> flood_tadpole_health;
        public final ForgeConfigSpec.ConfigValue<Integer> flood_tadpole_to_pod_infector_age;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Integer> enderman_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Integer> carrier_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_glow;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_climb;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_climb;
        public final ForgeConfigSpec.ConfigValue<Boolean> marine_form_climb;
        public final ForgeConfigSpec.ConfigValue<Boolean> marine_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> marine_form_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> marine_form_use_guns;
        public final ForgeConfigSpec.ConfigValue<Boolean> marine_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Integer> marine_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Boolean> player_form_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_tremble_walk;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_use_guns;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_use_energy_swords;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Integer> sangheili_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_form_reinforcements;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_form_teleportation;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_form_sensible_to_water;
        public final ForgeConfigSpec.ConfigValue<Double> enderman_form_reinforcement_rate;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Double> maw_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> maw_form_damage;
        public final ForgeConfigSpec.ConfigValue<Boolean> maw_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Double> maw_claw_form_damage;
        public final ForgeConfigSpec.ConfigValue<Integer> buff_potion_meter;
        public final ForgeConfigSpec.ConfigValue<Boolean> use_potions;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_canHaveChestplate;
        public final ForgeConfigSpec.ConfigValue<Boolean> human_form_armor;
        public final ForgeConfigSpec.ConfigValue<Boolean> player_form_armor;
        public final ForgeConfigSpec.ConfigValue<Boolean> pillager_form_use_crossbow;
        public final ForgeConfigSpec.ConfigValue<Boolean> vindicator_form_use_axe;
        public final ForgeConfigSpec.ConfigValue<Boolean> evoker_form_use_totem;
        public final ForgeConfigSpec.ConfigValue<Boolean> evoker_form_spellcast;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> buffing_potions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> human_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villager_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> pillager_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> vindicator_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> evoker_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> enderman_transformations;
        public final ForgeConfigSpec.ConfigValue<Boolean> human_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> villager_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> pillager_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> player_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> vindicator_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> evoker_conversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> enderman_conversion;
        public final ForgeConfigSpec.ConfigValue<Integer> player_golem_points;
        public final ForgeConfigSpec.ConfigValue<Boolean> flood_form_infectious;
        public final ForgeConfigSpec.ConfigValue<Double> flood_form_infection_chance;
        public final ForgeConfigSpec.ConfigValue<Boolean> illager_human_alliance;
        public final ForgeConfigSpec.ConfigValue<Integer> illager_human_alliance_wave;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_head_shake_animation;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_spawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_screen_shake_ground;
        public final ForgeConfigSpec.ConfigValue<Double> energy_sword_damage;
        public final ForgeConfigSpec.ConfigValue<Double> energy_sword_reach;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Gun Settings");
            this.enableGlassBreaking = builder.comment("Default true").define("If enabled, allows guns to shoot out glass and other fragile objects", true);
            this.fragileBlockDrops = builder.comment("Default true").define("If enabled, fragile blocks will drop their loot when broken", true);
            this.fragileBaseBreakChance = builder.comment("Default 1.0").defineInRange("The base chance that a fragile block is broken when impacted by a bullet, the hardness of a block will scale this value, the harder the block, the lower the final calculated chance will be", 1.0, 0.0, 1.0);
            this.gun_bullet_knockback = builder.comment("Default 0.15").defineInRange("Sets the knockback that an entity will take after being hit by a bullet", 0.15, 0.01, Double.MAX_VALUE);
            this.gun_bullet_crit = builder.comment("Default true").define("If true, bullets should cause crit hits with a chance", true);
            this.gun_spawn_smoke = builder.comment("Default false").define("If true, guns should spawn smoke particles when shooting", false);
            this.gun_sprint_animation = builder.comment("Default false").define("If true, guns should have sprinting animations and not default bobbing ones", false);
            this.gun_bullet_crit_chance = builder.comment("Default 0.05").defineInRange("Sets the chance of the bullet causing a crit hit, doubling the damage of the bullet, 0 05 means 5 percent chance", 0.05, 0.01, Double.MAX_VALUE);
            this.gun_bob_intensity = builder.comment("Default 1.0").defineInRange("Sets the bobbing intensity of the gun, basically how much should the gun move left and right just like in vanilla minecraft", 1.0, 0.2, Double.MAX_VALUE);
            this.gun_shot_sound_distance = builder.comment("Default 70").defineInRange("Sets the distance from where a gun shot can still be heard, works best with sound physics remastered mod", 70.0, 15.0, Double.MAX_VALUE);
            this.gun_aiming_mouse_sensitivity = builder.comment("Default 0.5").defineInRange("Sets the modified sensitivity of a gun when aiming", 0.5, 0.1, Double.MAX_VALUE);
            this.magnum_bullet_damage = builder.comment("Default 16.5").defineInRange("Sets the damage of the magnum's bullet", 16.5, 4.5, Double.MAX_VALUE);
            this.mk50_sidekick_bullet_damage = builder.comment("Default 15.3").defineInRange("Sets the damage of the sidekick's bullet", 15.3, 5.8, Double.MAX_VALUE);
            this.m90_shotgun_bullet_damage = builder.comment("Default 24.0").defineInRange("Sets the damage of the m90 shotgun's bullet", 24.0, 9.3, Double.MAX_VALUE);
            this.needler_bullet_damage = builder.comment("Default 20.5").defineInRange("Sets the damage of the needler's bullet", 20.5, 7.5, Double.MAX_VALUE);
            builder.pop();
            builder.push("Mob Stuff");
            builder.push("Illager / Raider stuff");
            this.illager_human_alliance = builder.comment("Default true").define("Should Illager Forms STOP attacking iron golems or players or villagers when they reach a certain stage due to the potential danger that the flood represents?", true);
            this.illager_human_alliance_wave = builder.comment("Default 3").define("The wave when the raider alliance will start their common enemy project, stopping all attacks pointed at the human side ", (Object)3);
            builder.pop();
            builder.push("Base Forms ( Human / Villager / Player )");
            this.base_form_health = builder.comment("Default 25").defineInRange("Sets Base Form's Max health", 25.0, 12.0, Double.MAX_VALUE);
            this.base_form_damage = builder.comment("Default 7").defineInRange("Sets Base Form's Damage", 7.0, 4.0, Double.MAX_VALUE);
            this.base_form_regeneration = builder.comment("Default true").define("Should Base Forms regenerate?", true);
            this.base_form_climb = builder.comment("Default true").define("Should Base Forms climb?", true);
            this.base_form_screen_shake = builder.comment("Default true").define("Should Base Forms cause a screen shake when roaring?", true);
            this.base_form_canHaveChestplate = builder.comment("Default false").define("Should ( certain ) Base Forms have the ability to wear chestplates as well?", false);
            this.human_form_armor = builder.comment("Default true").define("Should Human Forms be able to wear armor and take armor on death ( wave needs to be atleast 4 )?", true);
            this.player_form_armor = builder.comment("Default true").define("Should Player Forms be able to wear armor and take your armor on death ( no restrictions )?", true);
            this.player_form_breaks_blocks = builder.comment("Default true").define("Should PLAYER Forms break blocks?", true);
            this.pillager_form_use_crossbow = builder.comment("Default true").define("Should Pillager Forms use Crossbows?", true);
            this.vindicator_form_use_axe = builder.comment("Default true").define("Should Vindicator Forms use iron axes?", true);
            this.evoker_form_use_totem = builder.comment("Default true").define("Should Evoker Forms use Totems of Undying?", true);
            this.evoker_form_spellcast = builder.comment("Default true").define("Should Evoker Forms be able to cast spells and spawn pod infectors?", true);
            this.flood_form_infectious = builder.comment("Default false").define("Should All Flood Forms be infectious and have a chance to turn players, villagers and zombies and more into their counterparts? For this to work, you also have to specify the conversions and transformations of each creature, just like with a pod infector infection", false);
            this.flood_form_infection_chance = builder.comment("Default 0.15").defineInRange("Sets the chance of a creature being infected and turned into it's counterpart by any flood form", 0.15, 0.01, Double.MAX_VALUE);
            this.buffing_potions = builder.defineList("Potions that are used by the player form to buff the flood forms , NOT effects", (List)Lists.newArrayList((Object[])new String[]{"minecraft:fire_resistance", "minecraft:regeneration", "minecraft:strength", "minecraft:resistance"}), o -> o instanceof String);
            this.use_potions = builder.comment("Default true").define("Should Player Forms use Potions?", true);
            this.buff_potion_meter = builder.comment("Default 100").defineInRange("Sets the time before throwing a potion when buffing", 100, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Marine Forms");
            this.marine_form_health = builder.comment("Default 35").defineInRange("Sets Marine Form's Max health", 35.0, 15.0, Double.MAX_VALUE);
            this.marine_form_damage = builder.comment("Default 12").defineInRange("Sets Marine Form's Damage", 12.0, 4.0, Double.MAX_VALUE);
            this.marine_form_regeneration = builder.comment("Default true").define("Should Marine Forms regenerate?", true);
            this.marine_form_climb = builder.comment("Default true").define("Should Marine Forms climb?", true);
            this.marine_form_breaks_blocks = builder.comment("Default true").define("Should Marine Forms break blocks?", true);
            this.marine_form_use_guns = builder.comment("Default true").define("Should Marine Forms use guns?", true);
            this.marine_form_aggro_despawn = builder.comment("Default true").define("Should Marine Forms NOT despawn after they have seen a target for too long?", true);
            this.marine_form_aggro_ticks = builder.comment("Default 8000").define("Sets Marine's time before it should STOP despawning when it has seen a target for too long", (Object)8000);
            builder.pop();
            builder.push("Sangheili Forms");
            this.sangheili_form_health = builder.comment("Default 65").defineInRange("Sets Sangheili Form's Max health", 65.0, 20.0, Double.MAX_VALUE);
            this.sangheili_form_damage = builder.comment("Default 15").defineInRange("Sets Sangheili Form's Damage", 15.0, 5.0, Double.MAX_VALUE);
            this.sangheili_form_regeneration = builder.comment("Default true").define("Should Sangheili Forms regenerate?", true);
            this.sangheili_form_climb = builder.comment("Default true").define("Should Sangheili Forms climb?", true);
            this.sangheili_form_breaks_blocks = builder.comment("Default true").define("Should Sangheili Forms break blocks?", true);
            this.sangheili_form_tremble_walk = builder.comment("Default true").define("Should Sangheili Forms make your screen tremble when they walk?", true);
            this.sangheili_form_use_guns = builder.comment("Default true").define("Should Sangheili Forms use guns?", true);
            this.sangheili_form_use_energy_swords = builder.comment("Default true").define("Should Sangheili Forms use Energy Swords?", true);
            this.sangheili_form_aggro_despawn = builder.comment("Default true").define("Should Sangheili Forms NOT despawn after they have seen a target for too long?", true);
            this.sangheili_form_glow = builder.comment("Default true").define("Should Sangheili Forms glow in the dark? MAY BE OVERWRITTEN WHEN USING SHADERS", true);
            this.sangheili_form_aggro_ticks = builder.comment("Default 7500").define("Sets Sangheili's time before it should STOP despawning when it has seen a target for too long", (Object)7500);
            builder.pop();
            builder.push("Carrier Forms");
            this.carrier_form_health = builder.comment("Default 35").defineInRange("Sets Carrier Form's Max health", 35.0, 10.0, Double.MAX_VALUE);
            this.carrier_form_damage = builder.comment("Default 0").defineInRange("Sets Carrier Form's Damage", 0.0, 0.0, Double.MAX_VALUE);
            this.carrier_form_explosion_damage = builder.comment("Default 2.75").defineInRange("Sets the damage of the explosion of the carrier form", 2.75, 0.0, Double.MAX_VALUE);
            this.carrier_form_regeneration = builder.comment("Default true").define("Should Carrier Forms regenerate?", true);
            this.base_form_age = builder.comment("Default true").define("Should Base Forms age and turn into carrier forms?", true);
            this.base_to_carrier_form_age = builder.comment("Default 10000").define("Time in ticks until any base form ages and turns into a carrier form", (Object)10000);
            this.carrier_form_aggro_despawn = builder.comment("Default true").define("Should Carrier Forms NOT despawn after they have seen a target for too long?", true);
            this.carrier_form_aggro_ticks = builder.comment("Default 7000").define("Sets Carrier's time before it should STOP despawning when it has seen a target for too long", (Object)7000);
            this.carrier_form_screen_shake = builder.comment("Default true").define("Should Carrier Forms cause a screen shake when exploding?", true);
            builder.pop();
            builder.push("Pod Infector");
            this.pod_infector_health = builder.comment("Default 7").defineInRange("Sets Pod Infector's Max health", 7.0, 3.0, Double.MAX_VALUE);
            this.pod_infector_damage = builder.comment("Default 5").defineInRange("Sets Pod Infector's Damage", 5.0, 2.0, Double.MAX_VALUE);
            this.pod_infector_extra_explosion_damage = builder.comment("Default 1.45").defineInRange("Sets Pod Infector's Explosion's Damage", 1.45, 0.0, Double.MAX_VALUE);
            this.pod_infector_ticks_before_exploding = builder.comment("Default 50").define("Pod Infector cooldown time in ticks before bursting", (Object)50);
            this.pod_form_regeneration = builder.comment("Default true").define("Should Pod Infectors regenerate?", true);
            this.pod_infector_screen_shake = builder.comment("Default true").define("Should Pod Infectors cause a screen shake when exploding?", true);
            this.pod_infector_instant_latch_kill = builder.comment("Default false").define("Should Pod Infectors instakill the creature when it latches onto it? (Very OP, but canonically accurate to the real Flood)", false);
            builder.pop();
            builder.push("Flood Tadpoles");
            this.flood_tadpole_health = builder.comment("Default 4").defineInRange("Sets Flood Tadpole's Max health", 4.0, 1.0, Double.MAX_VALUE);
            this.flood_tadpole_to_pod_infector_age = builder.comment("Default 2400").define("Time in ticks until any flood tadpole ages and turns into a pod infector", (Object)2400);
            builder.pop();
            builder.push("Enderman Form");
            this.enderman_form_health = builder.comment("Default 55").defineInRange("Sets Enderman Form's Max health", 55.0, 15.0, Double.MAX_VALUE);
            this.enderman_form_damage = builder.comment("Default 11").defineInRange("Sets Enderman Form's Damage", 11.0, 3.0, Double.MAX_VALUE);
            this.enderman_form_regeneration = builder.comment("Default true").define("Should Enderman Forms regenerate?", true);
            this.enderman_form_reinforcement_rate = builder.comment("Default 0.95").defineInRange("Sets the chance of an Enderman Form to bring reinforcements, the lower the number, the smaller the chance", 0.95, 0.2, Double.MAX_VALUE);
            this.enderman_form_reinforcements = builder.comment("Default true").define("Should Enderman Forms bring reinforcements with teleportation?", true);
            this.enderman_form_teleportation = builder.comment("Default true").define("Should Enderman Forms use teleportation abilities?", true);
            this.enderman_form_sensible_to_water = builder.comment("Default true").define("Should Enderman Forms take damage when in contact with water?", true);
            this.enderman_form_aggro_despawn = builder.comment("Default true").define("Should Enderman Forms NOT despawn after they have seen a target for too long?", true);
            this.enderman_form_aggro_ticks = builder.comment("Default 7500").define("Sets Carrier's time before it should STOP despawning when it has seen a target for too long", (Object)7500);
            builder.pop();
            builder.push("Maw Form");
            this.maw_form_health = builder.comment("Default 75").defineInRange("Sets Maw Form's Max health", 75.0, 30.0, Double.MAX_VALUE);
            this.maw_form_damage = builder.comment("Default 20").defineInRange("Sets Maw Form's Damage", 20.0, 5.0, Double.MAX_VALUE);
            this.maw_form_regeneration = builder.comment("Default true").define("Should Maw Forms regenerate?", true);
            this.maw_claw_form_damage = builder.comment("Default 3").defineInRange("Sets Maw Claw Form's Damage", 3.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("Transformations");
            this.player_golem_points = builder.comment("Default 500").define("How many points does the death of a player or iron golem by a flood form add to the flood evolution? This number will be multiplied by the number of the wave", (Object)500);
            this.player_conversion = builder.comment("Default true").define("Should Pod Infectors transform players?", true);
            this.human_conversion = builder.comment("Default true").define("Should Pod Infectors transform zombies?", true);
            this.villager_conversion = builder.comment("Default true").define("Should Pod Infectors transform villagers?", true);
            this.pillager_conversion = builder.comment("Default true").define("Should Pod Infectors transform pillagers?", true);
            this.vindicator_conversion = builder.comment("Default true").define("Should Pod Infectors transform vindicators?", true);
            this.evoker_conversion = builder.comment("Default true").define("Should Pod Infectors transform evokers?", true);
            this.enderman_conversion = builder.comment("Default true").define("Should Pod Infectors transform endermans?", true);
            this.human_transformations = builder.defineList("Mobs that can turn into Human Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "spore:inf_human", "the_flesh_that_hates:flesh_human"}), o -> o instanceof String);
            this.villager_transformations = builder.defineList("Mobs that can turn into Villager Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "rotted:farmer", "guardvillagers:guard", "spore:inf_villager", "the_flesh_that_hates:flesh_villager"}), o -> o instanceof String);
            this.pillager_transformations = builder.defineList("Mobs that can turn into Pillager Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:pillager", "spore:inf_pillager", "the_flesh_that_hates:flesh_pillager"}), o -> o instanceof String);
            this.vindicator_transformations = builder.defineList("Mobs that can turn into Vindicator Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:vindicator", "spore:inf_vindicator", "the_flesh_that_hates:flesh_vindicator"}), o -> o instanceof String);
            this.evoker_transformations = builder.defineList("Mobs that can turn into Evoker Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:evoker", "spore:inf_evoker"}), o -> o instanceof String);
            this.enderman_transformations = builder.defineList("Mobs that can turn into Enderman Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:enderman"}), o -> o instanceof String);
            builder.pop();
            builder.push("Bodies / Corpses");
            this.corpse_spawn = builder.comment("Default true").define("Should corpses of the base forms have a chance to spawn after they get defeated?", true);
            this.corpse_head_shake_animation = builder.comment("Default true").define("Should corpses of the base forms have a shake animation applied to their head?", true);
            this.corpse_screen_shake_ground = builder.comment("Default true").define("Should corpses make your screen shake when falling to the ground?", true);
            builder.pop();
            builder.push("Spawns");
            this.mob_cap = builder.comment("Default 75").define("MobCap", (Object)75);
            this.dimension_parameters = builder.comment("Default minecraft:is_overworld").defineList("Dictates in what biome the flood forms spawn", (List)Lists.newArrayList((Object[])new String[]{"minecraft:is_overworld"}), o -> o instanceof String);
            this.spawns = builder.defineList("mob|weight|minimum|maximum", (List)Lists.newArrayList((Object[])new String[]{"dotf:pod_infector|6|4|6", "dotf:human_form|15|1|2", "dotf:player_form|11|1|1", "dotf:villager_form|13|1|2", "dotf:pillager_form|8|1|3", "dotf:vindicator_form|6|1|2", "dotf:vindicator_form|4|1|1", "dotf:carrier_form|11|1|2|", "dotf:sangheili_form|7|1|1|", "dotf:marine_form|13|1|3|", "dotf:enderman_form|4|1|1|", "dotf:maw_form|2|1|1|", "dotf:flood_tadpole|6|3|4|"}), o -> o instanceof String);
            builder.pop();
            builder.push("Horde");
            this.enable_horde = builder.comment("Default true").define("Should flood base forms hordes spawn?", true);
            this.mobSpawnAttempts = builder.comment("Default 10").define("Number of Mobs Spawning in a Horde", (Object)10);
            this.additionalHordeMobs = builder.comment("Default 3").define("Number of mobs that will be added to the horde each wave", (Object)3);
            this.ticksBeforeHordeSpawning = builder.comment("Default 2400").define("Ticks before the horde spawning", (Object)2400);
            this.additionalRandomizedTicks = builder.comment("Default 400").define("Additional horde ticks", (Object)400);
            builder.pop();
            builder.push("Effects");
            this.flood_sickness = builder.defineList("Mobs that are immune to the flood virus", (List)Lists.newArrayList((Object[])new String[]{"minecraft:ghast", "minecraft:magma_cube", "minecraft:phantom", "minecraft:snow_golem", "minecraft:stray", "minecraft:skeleton"}), o -> o instanceof String);
            builder.pop();
            builder.push("Targeting Tasks");
            this.blacklist = builder.defineList("Mobs Not Targeted", (List)Lists.newArrayList((Object[])new String[]{"minecraft:squid", "minecraft:bat", "minecraft:armor_stand", "minecraft:creeper", "minecraft:ghast", "minecraft:falling_block", "minecraft:abstract_arrow", "minecraft:arrow", "minecraft:spectral_arrow", "minecraft:trident"}), o -> o instanceof String);
            this.flood_attackers_list = builder.defineList("Mobs that TARGET flood forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "minecraft:skeleton", "minecraft:iron_golem", "minecraft:spider", "minecraft:cave_spider", "minecraft:witch", "minecraft:drowned", "minecraft:husk", "minecraft:zombie_villager", "minecraft:stray", "minecraft:pillager", "minecraft:enderman", "minecraft:evoker", "minecraft:vindicator", "minecraft:ravager", "minecraft:vex"}), o -> o instanceof String);
            builder.pop();
            builder.pop();
            builder.push("Items & Weapons");
            builder.push("Energy Sword");
            this.energy_sword_damage = builder.comment("Default 13").defineInRange("Damage", 13.0, 3.0, Double.MAX_VALUE);
            this.energy_sword_reach = builder.comment("Default 3.5").defineInRange("Reach Distance", 3.5, 1.0, Double.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("PERFORMANCE");
            this.hasPerformanceModeOn = builder.comment("Default false").define("THIS IS A VALUE THAT SHOULD ONLY BE PUT TO TRUE IF YOU WANT BETTER PERFORMANCE WITH DAWN OF THE FLOOD, SETTING THIS TO TRUE WILL SLIGHTLY REDUCE / ALTER GAME QUALITY, AND I DON'T SUGGEST USING THIS FEATURE AS IT DOES NOT IMPROVE YOUR FRAMERATE CONSTANTLY / TOO MUCH", false);
            builder.pop();
            builder.push("Others");
            this.camera_animations = builder.comment("Default true").define("If true, the camera of the player will move realistically like a body cam whenever items are used or in any other circumstances", true);
            this.hasPlayerCustomAnimations = builder.comment("Default true").define("If the player should have custom third person animations, VERY GREAT ADDITION BTW", true);
            this.hasHaloCrosshairs = builder.comment("Default true").define("If the player should have a custom halo style crosshair by default, enhances details", true);
            this.allowsFogChanges = builder.comment("Default true").define("Allows the fog and atmosphere of the world change with the flood progressing", true);
            this.fogFactor = builder.comment("Default 185").defineInRange("Fog Factor for the atmosphere change", 185.0, 55.0, Double.MAX_VALUE);
            this.frag_grenade_breaks_blocks = builder.comment("Default true").define("If the fragment grenade should break blocks when detonating", true);
            builder.pop();
        }
    }

    public static class DataGen {
        public final ForgeConfigSpec.ConfigValue<Integer> wave1_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave2_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave3_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave4_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave5_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave6_points;
        public final ForgeConfigSpec.ConfigValue<Integer> devices_points;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> name;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> base_form_helmet;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> base_form_chestplate;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> base_form_legs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> base_form_feet;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> player_form_main_hand;
        public final ForgeConfigSpec.ConfigValue<Integer> base_form_improved_equipment_chance;

        public DataGen(ForgeConfigSpec.Builder builder) {
            builder.push("Waves");
            this.wave1_points = builder.comment("Default 2500").define("Sets points required to enter wave 1", (Object)2500);
            this.wave2_points = builder.comment("Default 12500").define("Sets points required to enter wave 2", (Object)12500);
            this.wave3_points = builder.comment("Default 100000").define("Sets points required to enter wave 3", (Object)100000);
            this.wave4_points = builder.comment("Default 1000000").define("Sets points required to enter wave 4", (Object)1000000);
            this.wave5_points = builder.comment("Default 2500000").define("Sets points required to enter wave 5", (Object)2500000);
            this.wave6_points = builder.comment("Default 7500000").define("Sets points required to enter wave 6", (Object)7500000);
            builder.pop();
            builder.push("Device Points");
            this.devices_points = builder.comment("Default 1000").define("Sets points that will be added / subtracted by the devices", (Object)1000);
            builder.pop();
            builder.push("Player Form Names");
            this.name = builder.defineList("Player Form Possible Names", (List)Lists.newArrayList((Object[])new String[]{"ASEStefan", "Nightfox", "Kronoz", "Beta", "Reno", "purple skittle", "Thomas Lovlin Jones", "Darkmarines38", "davka", "TeamAbyssal", "Magic School Bus Dropout", "Stinker Bomber", "AzPure", "Allan Marceau", "Finton", "Shiarir", "ItsPizzaTIM", "Vee", "XPurple_DiamondX", "MR138", "entiral", "Evan Wingerter", "okshn", "ShadowSwordz", "ShadowWolf", "boodahbob", "marnavH7", "Nugaut", "Weethernator", "JazzMan"}), o -> o instanceof String);
            builder.pop();
            builder.push("Base Form Equipment");
            builder.comment("Items / chance of spawning with it");
            this.player_form_main_hand = builder.defineList("Main Hand Slot for the PLAYER FORM ONLY", (List)Lists.newArrayList((Object[])new String[]{"minecraft:crossbow|60", "minecraft:flint_and_steel|20", "minecraft:ender_pearl|15", "minecraft:spyglass|15", "minecraft:totem_of_undying|10"}), o -> o instanceof String);
            this.base_form_helmet = builder.defineList("Head Slot", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chainmail_helmet|10", "minecraft:iron_helmet|40", "minecraft:leather_helmet|30", "minecraft:golden_helmet|15", "minecraft:diamond_helmet|5", "minecraft:netherite_helmet|2"}), o -> o instanceof String);
            this.base_form_chestplate = builder.defineList("Chest Slot", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chainmail_chestplate|50", "minecraft:iron_chestplate|20", "minecraft:leather_chestplate|20", "minecraft:golden_chestplate|15", "minecraft:diamond_chestplate|5", "minecraft:netherite_chestplate|2"}), o -> o instanceof String);
            this.base_form_legs = builder.defineList("Legs Slot", (List)Lists.newArrayList((Object[])new String[]{"minecraft:leather_leggings|50", "minecraft:iron_leggings|20", "minecraft:chainmail_leggings|20", "minecraft:golden_leggings|15", "minecraft:diamond_leggings|5", "minecraft:netherite_leggings|2"}), o -> o instanceof String);
            this.base_form_feet = builder.defineList("Boots Slot", (List)Lists.newArrayList((Object[])new String[]{"minecraft:leather_boots|50", "minecraft:iron_boots|20", "minecraft:chainmail_boots|20", "minecraft:golden_boots|15", "minecraft:diamond_boots|5", "minecraft:netherite_boots|2"}), o -> o instanceof String);
            this.base_form_improved_equipment_chance = builder.comment("Default 300").define("Chance of the zombies spawning with improved equipment, the bigger the number the smaller the chance", (Object)300);
            builder.pop();
        }
    }
}

