/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.teamabyssalofficial.util.WorldDataUtils;

public class TargetCropsGoal
extends MoveToBlockGoal {
    private final Mob removerMob;
    private final int searchRange;
    private int ticksSinceReachedGoal;

    public TargetCropsGoal(PathfinderMob pRemoverMob, double pSpeedModifier, int pSearchRange) {
        super(pRemoverMob, pSpeedModifier, 24, pSearchRange);
        this.removerMob = pRemoverMob;
        this.searchRange = pSearchRange;
    }

    public boolean m_8036_() {
        ServerLevel world;
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.removerMob.m_9236_(), (Entity)this.removerMob)) {
            return false;
        }
        if (this.f_25600_ > 0) {
            --this.f_25600_;
            return false;
        }
        if (this.f_25598_.m_5448_() != null) {
            return false;
        }
        Level level = this.f_25598_.m_9236_();
        if (level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() < 4) {
            return false;
        }
        if (this.m_25626_()) {
            this.f_25600_ = TargetCropsGoal.m_186073_((int)20);
            return true;
        }
        this.f_25600_ = this.m_6099_(this.f_25598_);
        return false;
    }

    public void m_8041_() {
        super.m_8041_();
        this.removerMob.f_19789_ = 1.0f;
    }

    public void m_8056_() {
        super.m_8056_();
        this.ticksSinceReachedGoal = 0;
    }

    public void m_8037_() {
        super.m_8037_();
        Level level = this.removerMob.m_9236_();
        BlockPos blockpos = this.removerMob.m_20183_();
        BlockPos blockpos1 = this.getPosWithBlock(blockpos, (BlockGetter)level);
        RandomSource randomsource = this.removerMob.m_217043_();
        if (this.m_25625_() && blockpos1 != null) {
            Vec3 vec31;
            if (this.ticksSinceReachedGoal > 0) {
                vec31 = this.removerMob.m_20184_();
                this.removerMob.m_20334_(vec31.f_82479_, 0.3, vec31.f_82481_);
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42329_)), (double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.7, (double)blockpos1.m_123343_() + 0.5, 3, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, (double)0.15f);
                }
            }
            if (this.ticksSinceReachedGoal % 2 == 0) {
                vec31 = this.removerMob.m_20184_();
                this.removerMob.m_20334_(vec31.f_82479_, -0.3, vec31.f_82481_);
            }
            if (this.ticksSinceReachedGoal > 60) {
                level.m_7471_(blockpos1, false);
                this.destroyExtra();
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    public void destroyExtra() {
        AABB aabb = this.f_25598_.m_20191_().m_82400_((double)(Mth.m_14116_((float)this.searchRange) / 6.0f * this.f_25598_.m_20205_() / 3.0f));
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.f_25598_.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13073_)) continue;
            this.f_25598_.m_9236_().m_46961_(blockpos, false);
        }
    }

    @Nullable
    private BlockPos getPosWithBlock(BlockPos pPos, BlockGetter pLevel) {
        BlockPos[] ablockpos;
        if (pLevel.m_8055_(pPos).m_204336_(BlockTags.f_13073_)) {
            return pPos;
        }
        for (BlockPos blockpos : ablockpos = new BlockPos[]{pPos.m_7495_(), pPos.m_122024_(), pPos.m_122029_(), pPos.m_122012_(), pPos.m_122019_(), pPos.m_7495_().m_7495_()}) {
            if (!pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13073_)) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.m_6522_(SectionPos.m_123171_((int)pPos.m_123341_()), SectionPos.m_123171_((int)pPos.m_123343_()), ChunkStatus.f_62326_, false);
        if (chunkaccess == null) {
            return false;
        }
        if (!chunkaccess.m_8055_(pPos).canEntityDestroy((BlockGetter)pLevel, pPos, (Entity)this.removerMob)) {
            return false;
        }
        return chunkaccess.m_8055_(pPos).m_204336_(BlockTags.f_13073_) && chunkaccess.m_8055_(pPos.m_7494_()).m_60795_() && chunkaccess.m_8055_(pPos.m_6630_(2)).m_60795_();
    }
}

