/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.categories;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.controls.WallMovementControl;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.LeapAttackGoal;
import net.teamabyssalofficial.entity.ai.OpenFenceGateGoal;
import net.teamabyssalofficial.entity.ai.ParkourGoal;
import net.teamabyssalofficial.entity.ai.TargetCropsGoal;
import net.teamabyssalofficial.entity.custom.CarrierFormEntity;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.WorldDataUtils;

public class BaseForm
extends Monster
implements SoundUtils {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXPLOSION_TICKS = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_REANIMATED = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRANSFORMED = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DISCARD = SynchedEntityData.m_135353_(BaseForm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);
    private static int EXPLOSION_TICK = 40;
    @Nullable
    private BlockPos patrolTarget;
    private boolean patrolLeader;
    private boolean patrolling;
    public static final int NIMBLE = 0;
    public static final int SUPERIOR = 1;
    public static final int SPIKY = 2;
    public static final int TOUGH = 3;
    public static final int CORSAIR = 4;
    private boolean isAlreadyNimble = false;
    private boolean isAlreadySuperior = false;
    private boolean isAlreadySpiky = false;
    private boolean isAlreadyTough = false;
    private boolean isAlreadyCorsair = false;
    public boolean isCombat = false;
    public boolean isSangheili = false;
    private boolean isClose = false;
    public long aggroTicks;

    protected BaseForm(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_climb.get()).booleanValue()) {
            this.f_21342_ = new WallMovementControl((Mob)this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, pLevel);
        }
        this.m_274367_(1.0f);
        this.f_21364_ = 12;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_REANIMATED, (Object)false);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(TRANSFORMED, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(DISCARD, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.patrolTarget != null) {
            pCompound.m_128365_("PatrolTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.patrolTarget));
        }
        pCompound.m_128379_("PatrolLeader", this.patrolLeader);
        pCompound.m_128379_("Patrolling", this.patrolling);
        pCompound.m_128405_("Variant", this.getVariant());
        pCompound.m_128405_("Age", this.getAge());
        pCompound.m_128405_("explosionTicks", this.getExplosionTicks());
        pCompound.m_128379_("isReanimated", this.isReanimated());
        pCompound.m_128379_("isClimbing", this.isClimbing());
        pCompound.m_128379_("transformed", this.isTransformed());
        pCompound.m_128379_("discard", this.shouldDiscard());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("PatrolTarget")) {
            this.patrolTarget = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("PatrolTarget"));
        }
        this.patrolLeader = pCompound.m_128471_("PatrolLeader");
        this.patrolling = pCompound.m_128471_("Patrolling");
        this.setVariant(pCompound.m_128451_("Variant"));
        this.setAge(pCompound.m_128451_("Age"));
        this.setExplosionTicks(pCompound.m_128451_("explosionTicks"));
        this.setIsReanimated(pCompound.m_128471_("isReanimated"));
        this.setClimbing(pCompound.m_128471_("isClimbing"));
        this.setTransformed(pCompound.m_128471_("transformed"));
        this.willDiscard(pCompound.m_128471_("discard"));
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{SangheiliFormEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CarrierFormEntity.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(4, new LongDistancePatrolGoal<BaseForm>(this, 1.0, 0.9));
        this.f_21345_.m_25352_(5, (Goal)new TargetCropsGoal((PathfinderMob)this, 1.6, 32));
        this.f_21345_.m_25352_(3, (Goal)new LeapAttackGoal((Mob)this, 0.45f));
        this.f_21345_.m_25352_(6, (Goal)new OpenFenceGateGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new ParkourGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }

            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && (level = BaseForm.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2;
            }
        });
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
        if (this.getExplosionTicks() > 0) {
            this.setExplosionTicks(this.getExplosionTicks() - 1);
        }
        super.m_8024_();
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkFloodBaseFormRules(EntityType<? extends BaseForm> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && BaseForm.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && BaseForm.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 1;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (Math.random() <= (double)0.3f) {
            this.m_19998_((ItemLike)ItemRegistry.RIPPING_FLESH.get());
        }
        if (Math.random() <= 0.05) {
            this.m_19998_((ItemLike)ItemRegistry.SICKENED_HEART.get());
        } else if (Math.random() <= 0.05) {
            this.m_19998_((ItemLike)ItemRegistry.ROTTEN_BRAIN.get());
        }
    }

    public int getSubtractionPoints() {
        return 20;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.ENTITY_FORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.HUMAN_FORM_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.ENTITY_FORM_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SoundRegistry.ENTITY_FORM_STEP.get(), this.getVolume() / 2.0f, this.getPitch(this.f_19796_));
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 1) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public int getExplosionTicks() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION_TICKS);
    }

    public void setExplosionTicks(int ticks) {
        this.f_19804_.m_135381_(EXPLOSION_TICKS, (Object)ticks);
    }

    public boolean isReanimated() {
        return (Boolean)this.f_19804_.m_135370_(IS_REANIMATED);
    }

    public void setIsReanimated(boolean value) {
        this.f_19804_.m_135381_(IS_REANIMATED, (Object)value);
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean value) {
        this.f_19804_.m_135381_(CLIMBING, (Object)value);
    }

    public boolean isTransformed() {
        return (Boolean)this.f_19804_.m_135370_(TRANSFORMED);
    }

    public void setTransformed(boolean value) {
        this.f_19804_.m_135381_(TRANSFORMED, (Object)value);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean value) {
        this.f_19804_.m_135381_(LEAPING, (Object)value);
    }

    public boolean shouldDiscard() {
        return (Boolean)this.f_19804_.m_135370_(DISCARD);
    }

    public void willDiscard(boolean value) {
        this.f_19804_.m_135381_(DISCARD, (Object)value);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public DamageSource getDamage() {
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.form_melee_damage1((LivingEntity)this), DamageTypeRegistry.form_melee_damage2((LivingEntity)this), DamageTypeRegistry.form_melee_damage3((LivingEntity)this), DamageTypeRegistry.form_melee_damage4((LivingEntity)this), DamageTypeRegistry.form_melee_damage5((LivingEntity)this), DamageTypeRegistry.form_melee_damage6((LivingEntity)this), DamageTypeRegistry.form_melee_damage7((LivingEntity)this), DamageTypeRegistry.form_melee_damage8((LivingEntity)this));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    public boolean canBeLeader() {
        return true;
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    public double getMovementSpeed() {
        switch (this.getVariant()) {
            case 0: {
                return 0.3;
            }
            case 1: {
                return 0.25;
            }
            case 2: {
                return 0.25;
            }
            case 3: {
                return 0.2;
            }
        }
        return 0.25;
    }

    public int getArmorChance() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            return switch (WorldDataUtils.getWorldDataRegistry(world).getWave()) {
                case 4 -> (Integer)DawnOfTheFloodConfig.DATAGEN.base_form_improved_equipment_chance.get() - 20;
                case 5 -> (Integer)DawnOfTheFloodConfig.DATAGEN.base_form_improved_equipment_chance.get() - 50;
                case 6 -> (Integer)DawnOfTheFloodConfig.DATAGEN.base_form_improved_equipment_chance.get() - 80;
                default -> (Integer)DawnOfTheFloodConfig.DATAGEN.base_form_improved_equipment_chance.get();
            };
        }
        return (Integer)DawnOfTheFloodConfig.DATAGEN.base_form_improved_equipment_chance.get();
    }

    public boolean canSpawnWithArmor() {
        ServerLevel world;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 3;
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(6);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        cloud.m_19734_(Mth.m_14107_((double)((double)cloud.m_19748_() / 3.0 * 1.2)));
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void spawnPods(Entity entity) {
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
        podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        entity.m_9236_().m_7967_((Entity)podInfectorEntity);
        podInfectorEntity.m_20254_(entity.m_20094_());
        podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 500, 0));
    }

    private void vanishFully() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_146870_();
        }
    }

    public void burst(int podCount, float volume, float pitch) {
        AABB boundingBox = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && !EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) {
                if (!livingEntity.m_21023_(MobEffects.f_19614_)) {
                    int pDuration = 100 + this.f_19796_.m_188503_(100);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, pDuration, 0));
                }
                float dist = this.m_20270_((Entity)livingEntity);
                float arclen = (float)(MathUtils.arcfloat((double)dist) * (3.1415927410125732 + this.f_19796_.m_188583_()));
                livingEntity.m_6469_(this.getDamage(), (float)(this.m_21133_(Attributes.f_22281_) * (double)arclen));
            }
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockUtils.generateBlood(this.m_9236_(), blockpos);
            }
        }
        this.spawnLingeringCloud();
        this.vanishFully();
        for (int i = 0; i < podCount; ++i) {
            this.spawnPods((Entity)this);
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(5), (float)0.07f, (int)4, (int)9);
        }
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.BASE_FORM_EXPLODE.get(), SoundSource.HOSTILE, volume + 0.25f, pitch);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(1.45f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(10), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_) * 0.65);
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLYING_REMAIN.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(45), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsLargeSpread((RandomSource)this.f_19796_) * 0.85);
        }
    }

    public void m_8119_() {
        ServerLevel world;
        WorldDataUtils worldDataUtils;
        int currentWave;
        Level level;
        float dist;
        super.m_8119_();
        this.setAge(this.getAge() + 1);
        if (this.m_5448_() != null && this.getVariant() == 4 && !this.isSangheili && (dist = this.m_20270_((Entity)this.m_5448_())) <= 3.0f) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
            if (!this.isClose) {
                this.setExplosionTicks(EXPLOSION_TICK);
                this.m_20331_(true);
                this.isClose = true;
            }
        }
        if (this.getExplosionTicks() == 1 && !this.isSangheili) {
            this.burst(2, this.getVolume(), this.getPitch(this.f_19796_));
        }
        if (this.getAge() > (Integer)DawnOfTheFloodConfig.SERVER.base_to_carrier_form_age.get() - 2500 && !this.m_21023_(MobEffects.f_19613_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
        }
        if (this.getAge() == ((Integer)DawnOfTheFloodConfig.SERVER.base_to_carrier_form_age.get()).intValue() && ((Boolean)DawnOfTheFloodConfig.SERVER.base_form_age.get()).booleanValue()) {
            this.turnToCarrier((Entity)this);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel && (currentWave = (worldDataUtils = WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level)).getWave()) < 4 && this.m_217043_().m_188503_(500) == 0 && !this.m_21023_((MobEffect)EffectRegistry.ECOSYSTEM_SYNDROME.get())) {
            this.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ECOSYSTEM_SYNDROME.get(), 1500, 0));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
            this.setClimbing(this.f_19862_ && this.nextToClimbableBlock(this));
        }
        if (!this.isCombat && !this.isSangheili) {
            if (this.getVariant() == 0 && !this.isAlreadyNimble) {
                this.isAlreadyNimble = true;
                this.m_21051_(Attributes.f_22279_).m_22100_(this.getMovementSpeed());
                this.m_21051_(Attributes.f_22281_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_damage.get() - 2.0);
                this.m_21051_(Attributes.f_22276_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get() - 5.0);
                if (!this.isReanimated()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.getVariant() == 1 && !this.isAlreadySuperior) {
                this.isAlreadySuperior = true;
                this.m_21051_(Attributes.f_22276_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get() + 10.0);
                this.m_21051_(Attributes.f_22281_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_damage.get() + 5.0);
                if (!this.isReanimated()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.getVariant() == 2 && !this.isAlreadySpiky) {
                this.isAlreadySpiky = true;
                this.m_21051_(Attributes.f_22276_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get() - 10.0);
                this.m_21051_(Attributes.f_22281_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_damage.get() + 5.0);
                if (!this.isReanimated()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.getVariant() == 3 && !this.isAlreadyTough) {
                this.isAlreadyTough = true;
                this.m_21051_(Attributes.f_22276_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get() + 5.0);
                this.m_21051_(Attributes.f_22284_).m_22100_(10.0);
                this.m_21051_(Attributes.f_22279_).m_22100_(this.getMovementSpeed());
                if (!this.isReanimated()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.getVariant() == 4 && !this.isAlreadyCorsair) {
                this.isAlreadyCorsair = true;
                this.m_21051_(Attributes.f_22276_).m_22100_((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get() - 5.0);
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.27f);
                if (!this.isReanimated()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.base_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(200) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 0.5) {
                this.m_5634_(1.0f);
            }
        }
    }

    public boolean nextToClimbableBlock(BaseForm entityIn) {
        Level world = entityIn.m_9236_();
        BlockPos offset = entityIn.m_20183_().m_7918_((int)(Math.cos(Math.toRadians(entityIn.m_146908_() + 90.0f)) * 1.2), 0, (int)(Math.sin(Math.toRadians(entityIn.m_146908_() + 90.0f)) * 1.2));
        BlockPos blockPos = entityIn.m_20183_().m_7918_((int)(Math.cos(Math.toRadians(entityIn.m_146908_() + 90.0f)) * -1.2), 0, (int)(Math.sin(Math.toRadians(entityIn.m_146908_() + 90.0f)) * -1.2));
        BlockState state = world.m_8055_(offset);
        BlockState blockState = world.m_8055_(blockPos);
        return state.m_60838_((BlockGetter)world, offset) || blockState.m_60838_((BlockGetter)world, blockPos);
    }

    private void turnToCarrier(Entity entity) {
        CarrierFormEntity carrierFormEntity = new CarrierFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.CARRIER_FORM.get()), entity.m_9236_());
        carrierFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        carrierFormEntity.setSizeVariant(this.getVariant());
        carrierFormEntity.setAggroTicks((int)this.aggroTicks);
        carrierFormEntity.m_146926_(entity.m_146909_());
        carrierFormEntity.m_146922_(entity.m_146908_());
        carrierFormEntity.m_5618_(this.f_20883_);
        carrierFormEntity.m_5616_(this.f_20885_);
        carrierFormEntity.m_6593_(entity.m_7770_());
        carrierFormEntity.m_21563_().m_24964_(entity.m_20154_());
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.2f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), PerformanceEngine.getParticleCount(75), 0.2, 0.8, 0.4, ParticleUtils.getDownwardsMediumSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(5), 0.1, 0.2, 0.1, 0.01);
        }
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, this.getVolume() + 0.25f, this.getPitch(this.f_19796_));
        entity.m_9236_().m_7967_((Entity)carrierFormEntity);
        entity.m_146870_();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (pReason != MobSpawnType.PATROL && pReason != MobSpawnType.EVENT && pReason != MobSpawnType.STRUCTURE && this.f_19796_.m_188501_() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (pReason == MobSpawnType.PATROL) {
            this.patrolling = true;
        }
        int rand = this.f_19796_.m_188503_(18);
        switch (rand) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.setVariant(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setVariant(1);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.setVariant(2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.setVariant(3);
                break;
            }
            case 16: 
            case 17: {
                this.setVariant(4);
            }
        }
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.patrolling || pDistanceToClosestPlayer > 16384.0;
    }

    public void setPatrolTarget(BlockPos blockPos) {
        this.patrolTarget = blockPos;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean b) {
        this.patrolLeader = b;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolTarget = this.m_20183_().m_7918_(-500 + this.f_19796_.m_188503_(1000), 0, -500 + this.f_19796_.m_188503_(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean b) {
        this.patrolling = b;
    }

    static class Variants {
        public static final int NIMBLE = 0;
        public static final int SUPERIOR = 1;
        public static final int SPIKY = 2;
        public static final int TOUGH = 3;
        public static final int CORSAIR = 4;

        Variants() {
        }
    }

    public static class LongDistancePatrolGoal<T extends BaseForm>
    extends Goal {
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil;

        public LongDistancePatrolGoal(T t, double v, double v1) {
            this.mob = t;
            this.speedModifier = v;
            this.leaderSpeedModifier = v1;
            this.cooldownUntil = -1L;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            boolean flag = this.mob.m_9236_().m_46467_() < this.cooldownUntil;
            return ((BaseForm)((Object)this.mob)).isPatrolling() && this.mob.m_5448_() == null && !this.mob.m_20160_() && ((BaseForm)((Object)this.mob)).hasPatrolTarget() && !flag;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            boolean flag = ((BaseForm)((Object)this.mob)).isPatrolLeader();
            PathNavigation pathnavigation = this.mob.m_21573_();
            if (pathnavigation.m_26571_()) {
                List<BaseForm> list = this.findPatrolCompanions();
                if (((BaseForm)((Object)this.mob)).isPatrolling() && list.isEmpty()) {
                    ((BaseForm)((Object)this.mob)).setPatrolling(false);
                } else if (flag && ((BaseForm)((Object)this.mob)).getPatrolTarget().m_203195_((Position)this.mob.m_20182_(), 10.0)) {
                    ((BaseForm)((Object)this.mob)).findPatrolTarget();
                } else {
                    assert (((BaseForm)((Object)this.mob)).getPatrolTarget() != null);
                    Vec3 vec3 = Vec3.m_82539_((Vec3i)((BaseForm)((Object)this.mob)).getPatrolTarget());
                    Vec3 vec31 = this.mob.m_20182_();
                    Vec3 vec32 = vec31.m_82546_(vec3);
                    vec3 = vec32.m_82524_(90.0f).m_82490_(0.4).m_82549_(vec3);
                    Vec3 vec33 = vec3.m_82546_(vec31).m_82541_().m_82490_(10.0).m_82549_(vec31);
                    BlockPos blockpos = BlockPos.m_274446_((Position)vec33);
                    blockpos = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockpos);
                    if (!pathnavigation.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), flag ? this.leaderSpeedModifier : this.speedModifier)) {
                        this.moveRandomly();
                        this.cooldownUntil = this.mob.m_9236_().m_46467_() + 200L;
                    } else if (flag) {
                        for (BaseForm patrollingmonster : list) {
                            patrollingmonster.setPatrolTarget(blockpos);
                        }
                    }
                }
            }
        }

        private List<BaseForm> findPatrolCompanions() {
            return this.mob.m_9236_().m_6443_(BaseForm.class, this.mob.m_20191_().m_82400_(16.0), baseForm -> baseForm.canJoinPatrol() && !baseForm.m_7306_((Entity)this.mob));
        }

        private boolean moveRandomly() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_7918_(-8 + random.m_188503_(16), 0, -8 + random.m_188503_(16)));
            return this.mob.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
        }
    }
}

