/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.LeapAttackGoal;
import net.teamabyssalofficial.entity.ai.OpenFenceGateGoal;
import net.teamabyssalofficial.entity.ai.ParkourGoal;
import net.teamabyssalofficial.entity.ai.TargetCropsGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.entity.custom.DeadEvokerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EvokerFormEntity
extends BaseForm
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> SPAWN_TIMER = SynchedEntityData.m_135353_(EvokerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROAR_TIMER = SynchedEntityData.m_135353_(EvokerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TIMER = SynchedEntityData.m_135353_(EvokerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SPELLCASTING = SynchedEntityData.m_135353_(EvokerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public double nullSpeed = 0.0;
    public BodyEntity wantedEntity;
    public double wantedSpeed = 1.2;
    public static final byte ATTACK = 1;
    public static final byte FIST_ATTACK = 2;
    public static final int ROAR_TIME = 50;
    public static final int SPELL_TICK = 12;

    public EvokerFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.isCombat = false;
        this.isSangheili = false;
        this.aggroTicks = 0L;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)30);
        this.f_19804_.m_135372_(ROAR_TIMER, (Object)0);
        this.f_19804_.m_135372_(SPELL_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_SPELLCASTING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.base_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.15).m_22268_(Attributes.f_22283_, 1.1).m_22268_(Attributes.f_22278_, 0.35).m_22268_(Attributes.f_22284_, 5.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.6f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new EvokerFormMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new EvokerFormFistAttackGoal(this));
        this.f_21345_.m_25352_(4, new BaseForm.LongDistancePatrolGoal<EvokerFormEntity>(this, 1.0, 0.9));
        this.f_21345_.m_25352_(5, (Goal)new TargetCropsGoal((PathfinderMob)this, 1.3, 32));
        this.f_21345_.m_25352_(3, (Goal)new LeapAttackGoal((Mob)this, 0.5f){

            @Override
            public void m_8037_() {
                EvokerFormEntity.this.setLeaping(true);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !EvokerFormEntity.this.isImmobile && EvokerFormEntity.this.getRoarTimer() == 0 && EvokerFormEntity.this.getSpawnTimer() == 0;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OpenFenceGateGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new ParkourGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !EvokerFormEntity.this.isImmobile && EvokerFormEntity.this.getRoarTimer() == 0 && EvokerFormEntity.this.getSpawnTimer() == 0;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }

            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && (level = EvokerFormEntity.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2;
            }
        });
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getExplosionTicks() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.explode"));
            }
            if (this.getRoarTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.roar"));
            }
            if (this.getSpawnTimer() > 0 && this.isTransformed()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.transform"));
            }
            if (this.isLeaping() && !this.m_20096_() && this.attackID == 0 && !this.isClimbing()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.leap"));
            }
            if (this.m_20069_() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.leap"));
            }
            if (this.isClimbing() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("evoker.form.climb"));
            }
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("evoker.form.death"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("evoker.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("evoker.form.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("evoker.form.target"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("evoker.form.attack"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("evoker.form.fist.attack"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public int getRoarTimer() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TIMER);
    }

    public void setRoarTimer(int ticks) {
        this.f_19804_.m_135381_(ROAR_TIMER, (Object)ticks);
    }

    public int getSpellTimer() {
        return (Integer)this.f_19804_.m_135370_(SPELL_TIMER);
    }

    public void setSpellTimer(int ticks) {
        this.f_19804_.m_135381_(SPELL_TIMER, (Object)ticks);
    }

    public boolean isSpellcasting() {
        return (Boolean)this.f_19804_.m_135370_(IS_SPELLCASTING);
    }

    public void setSpellcasting(boolean value) {
        this.f_19804_.m_135381_(IS_SPELLCASTING, (Object)value);
    }

    @Override
    protected void m_8024_() {
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getRoarTimer() > 0) {
            this.setRoarTimer(this.getRoarTimer() - 1);
        }
        if (this.getSpellTimer() > 0) {
            this.setSpellTimer(this.getSpellTimer() - 1);
        }
        super.m_8024_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor groupData, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = groupData.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        return super.m_6518_(groupData, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        if (Math.random() < 0.85 && ((Boolean)DawnOfTheFloodConfig.SERVER.evoker_form_use_totem.get()).booleanValue()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42747_));
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 2;
        }
        return true;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("spawnTimer", this.getSpawnTimer());
        nbt.m_128405_("roarTimer", this.getRoarTimer());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSpawnTimer(nbt.m_128451_("spawnTimer"));
        this.setRoarTimer(nbt.m_128451_("roarTimer"));
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_(1.85);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_((Player)null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.35f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)0.95f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    public float getVolume() {
        return 1.25f;
    }

    public float getPitch(RandomSource random) {
        return 0.95f;
    }

    public boolean canPerformSpell() {
        float area = 12.0f;
        int maximumPods = 4;
        AABB areaBox = this.m_20191_().m_82400_((double)area);
        List entities = this.m_9236_().m_45933_((Entity)this, areaBox);
        ArrayList<PodInfectorEntity> nearbyPods = new ArrayList<PodInfectorEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof PodInfectorEntity)) continue;
            PodInfectorEntity podInfectorEntity = (PodInfectorEntity)entity;
            nearbyPods.add(podInfectorEntity);
        }
        return nearbyPods.size() < maximumPods;
    }

    public boolean hasBodyNearby() {
        AABB bodyArea = this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_) / 2.0);
        List entities = this.m_9236_().m_45933_((Entity)this, bodyArea);
        ArrayList<BodyEntity> bodyEntityList = new ArrayList<BodyEntity>();
        for (Entity entity : entities) {
            BodyEntity bodyEntity;
            if (!(entity instanceof BodyEntity)) continue;
            this.wantedEntity = bodyEntity = (BodyEntity)entity;
            bodyEntityList.add(bodyEntity);
        }
        return !bodyEntityList.isEmpty();
    }

    public void performSpell() {
        this.setSpellTimer(12);
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), this.m_9236_());
        for (int i = 0; i < 2; ++i) {
            int dist = i % 2 == 0 ? 2 : -2;
            double x = this.m_20185_() + (double)dist;
            double y = this.m_20186_();
            double z = this.m_20189_();
            podInfectorEntity.m_6027_(x, y, z);
            podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 300, 0));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                if (!PerformanceEngine.hasPerformanceModeOn()) {
                    AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.1f).position(x, y, z));
                }
                world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), x, y, z, PerformanceEngine.getParticleCount(8), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            }
            this.m_9236_().m_7967_((Entity)podInfectorEntity);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 1.25f, 0.65f);
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public boolean canSpellcast() {
        ServerLevel world;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2;
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.getExplosionTicks() > 0) {
            this.isImmobile = true;
        }
        if (this.getSpawnTimer() > 0 || this.getRoarTimer() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.nullSpeed);
        }
        if (this.getSpawnTimer() == 0 && this.getRoarTimer() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.getSpawnTimer() == 28 && this.isTransformed()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_));
        }
        if (this.getSpawnTimer() == 7 && this.getRoarTimer() == 0 && this.isTransformed()) {
            this.setRoarTimer(50);
        }
        if (this.getRoarTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getRoarTimer() == 46) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_ROAR.get(), this.m_5720_(), this.getVolume() + 0.65f, this.getPitch(this.f_19796_));
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 16.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.13f, (int)35, (int)7);
            }
        }
        if ((target = this.m_5448_()) != null && this.m_20270_((Entity)target) >= 5.0f && this.m_20270_((Entity)target) <= 16.0f && this.attackID == 0 && !this.isImmobile && this.canSpellcast()) {
            if (Math.random() <= (double)0.15f && this.canPerformSpell()) {
                this.performSpell();
            }
        } else if (this.attacktick == 0 && !this.isImmobile && this.canSpellcast() && Math.random() <= (double)0.15f && this.hasBodyNearby() && this.canPerformSpell() && this.wantedEntity != null) {
            this.performSpell();
            this.m_21573_().m_5624_((Entity)this.wantedEntity, this.wantedSpeed);
        }
        this.setSpellcasting(this.getSpellTimer() > 0);
        if (this.m_9236_().f_46443_ && this.isSpellcasting()) {
            float ranf = this.f_19796_.m_188501_() * 0.6314781f;
            double $$1 = ranf * (float)this.f_19796_.m_216332_(1, 4) / 11.0f;
            double $$2 = ranf * (float)this.f_19796_.m_216332_(1, 4) / 12.0f;
            double $$3 = ranf * (float)this.f_19796_.m_216332_(1, 4) / 13.0f;
            float $$4 = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float $$5 = Mth.m_14089_((float)$$4);
            float $$6 = Mth.m_14031_((float)$$4);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)$$5 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)$$6 * 0.6, $$1, $$2, $$3);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)$$5 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)$$6 * 0.6, $$1, $$2, $$3);
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
    }

    @Override
    public void m_6667_(DamageSource source) {
        if (Math.random() <= (double)0.15f && !this.isReanimated() && ((Boolean)DawnOfTheFloodConfig.SERVER.corpse_spawn.get()).booleanValue()) {
            this.dropBody((Entity)this);
            this.vanish();
            this.setIsReanimated(true);
            this.willDiscard(true);
        } else {
            this.willDiscard(false);
        }
        super.m_6667_(source);
    }

    protected void m_6153_() {
        super.m_6153_();
        ++this.f_20919_;
        if (this.f_20919_ == 1 && this.shouldDiscard()) {
            this.m_146870_();
        } else if (this.f_20919_ == 30 && !this.shouldDiscard()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void dropBody(Entity entity) {
        DeadEvokerFormEntity deadEvokerFormEntity = new DeadEvokerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.DEAD_EVOKER_FORM.get()), entity.m_9236_());
        deadEvokerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        deadEvokerFormEntity.setVariant(this.getVariant());
        deadEvokerFormEntity.m_8061_(EquipmentSlot.MAINHAND, this.m_21205_());
        deadEvokerFormEntity.m_146926_(entity.m_146909_());
        deadEvokerFormEntity.m_146922_(entity.m_146908_());
        deadEvokerFormEntity.m_5618_(this.f_20883_);
        deadEvokerFormEntity.m_5616_(this.f_20885_);
        deadEvokerFormEntity.m_21563_().m_24964_(entity.m_20154_());
        deadEvokerFormEntity.m_6593_(entity.m_7770_());
        deadEvokerFormEntity.stackScaler.setpX(this.stackScaler.getpX());
        deadEvokerFormEntity.stackScaler.setpY(this.stackScaler.getpY());
        deadEvokerFormEntity.stackScaler.setpZ(this.stackScaler.getpZ());
        entity.m_9236_().m_7967_((Entity)deadEvokerFormEntity);
    }

    private void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(5), 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_REMOVED.get(), SoundSource.HOSTILE, 1.05f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
    }

    class EvokerFormMeleeAttackGoal
    extends Goal {
        private final EvokerFormEntity evokerFormEntity;
        private LivingEntity attackTarget;

        public EvokerFormMeleeAttackGoal(EvokerFormEntity evokerFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.evokerFormEntity = evokerFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.evokerFormEntity.m_5448_();
            return this.attackTarget != null && this.evokerFormEntity.attackID == 1 && !EvokerFormEntity.this.isImmobile && this.evokerFormEntity.getExplosionTicks() == 0;
        }

        public void m_8056_() {
            this.evokerFormEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.evokerFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.evokerFormEntity.attacktick < 27;
        }

        public void m_8037_() {
            if (EvokerFormEntity.this.attacktick == 8) {
                float f1 = (float)Math.cos(Math.toRadians(EvokerFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(EvokerFormEntity.this.m_146908_() + 90.0f));
                EvokerFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (EvokerFormEntity.this.attacktick == 13) {
                float volume = this.evokerFormEntity.getVolume() + 0.15f;
                float pitch = this.evokerFormEntity.getPitch(this.evokerFormEntity.m_217043_()) - 0.5f;
                this.evokerFormEntity.m_9236_().m_5594_((Player)null, this.evokerFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (EvokerFormEntity.this.attacktick == 21) {
                EvokerFormEntity.this.destroySwingable();
                EvokerFormEntity.this.sweep((Entity)this.attackTarget);
                if (EvokerFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f) {
                    this.attackTarget.m_6469_(EvokerFormEntity.this.getDamage(), (float)EvokerFormEntity.this.m_21133_(Attributes.f_22281_));
                }
            }
            EvokerFormEntity.this.m_21573_().m_26569_();
        }
    }

    class EvokerFormFistAttackGoal
    extends Goal {
        private final EvokerFormEntity evokerFormEntity;
        private LivingEntity attackTarget;

        public EvokerFormFistAttackGoal(EvokerFormEntity evokerFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.evokerFormEntity = evokerFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.evokerFormEntity.m_5448_();
            return this.attackTarget != null && this.evokerFormEntity.attackID == 2 && !EvokerFormEntity.this.isImmobile && this.evokerFormEntity.getExplosionTicks() == 0;
        }

        public void m_8056_() {
            this.evokerFormEntity.setAttackID(2);
        }

        public void m_8041_() {
            this.evokerFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.evokerFormEntity.attacktick < 30;
        }

        public void m_8037_() {
            if (EvokerFormEntity.this.attacktick == 8) {
                EvokerFormEntity.this.f_20883_ = EvokerFormEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(EvokerFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(EvokerFormEntity.this.m_146908_() + 90.0f));
                EvokerFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (EvokerFormEntity.this.attacktick == 13) {
                float volume = this.evokerFormEntity.getVolume() + 0.15f;
                float pitch = this.evokerFormEntity.getPitch(this.evokerFormEntity.m_217043_()) - 0.5f;
                this.evokerFormEntity.m_9236_().m_5594_((Player)null, this.evokerFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (EvokerFormEntity.this.attacktick == 22) {
                EvokerFormEntity.this.destroySwingable();
                if (EvokerFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f) {
                    this.attackTarget.m_6469_(EvokerFormEntity.this.getDamage(), (float)EvokerFormEntity.this.m_21133_(Attributes.f_22281_) * 1.3f);
                    if (this.attackTarget.m_6084_()) {
                        Player player;
                        double dx = MathUtils.sin((float)MathUtils.APPROX_PI) * 2.25f;
                        double dz = this.attackTarget.m_20189_();
                        double strength = 1.85f;
                        this.attackTarget.m_147240_(strength, dx, dz);
                        LivingEntity livingEntity = this.attackTarget;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    }
                }
            }
            EvokerFormEntity.this.m_21573_().m_26569_();
        }
    }
}

