/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom.special;

import java.util.List;
import javax.annotation.Nullable;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MawClawEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> BURROW_PROGRESS = SynchedEntityData.m_135353_(MawClawEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int BURROW_TIME = 50;
    public static final int UNDERGROUND_TIME = 60;
    public static final int EMERGE_TIME = 50;
    private static final int BURROW_COOLDOWN = 250;
    private int burrowCooldown = 0;
    private int burrowX = 0;
    private int burrowY = 0;
    private int burrowZ = 0;
    public int prevClientBurrowProgress = 0;
    public int clientBurrowProgress = 0;
    public int aliveTicks = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);

    public MawClawEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        this.f_21364_ = 0;
        this.m_274367_(0.0f);
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerV", 7, event -> {
            if (this.isBurrowing() || this.isEmerging()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("maw_claw.dig"));
            }
            if (!(event.isMoving() || this.isBurrowing() || this.isEmerging() || this.isUnderground())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("maw_claw.idle"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROW_PROGRESS, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("burrowProgress", this.getBurrowProgress());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setBurrowProgress(nbt.m_128451_("burrowProgress"));
    }

    public int getBurrowProgress() {
        return (Integer)this.f_19804_.m_135370_(BURROW_PROGRESS);
    }

    public void setBurrowProgress(int burrowProgress) {
        this.f_19804_.m_135381_(BURROW_PROGRESS, (Object)burrowProgress);
    }

    public boolean isBurrowing() {
        return this.getBurrowProgress() != 0 && this.getBurrowProgress() < 50;
    }

    public boolean isUnderground() {
        return this.getBurrowProgress() >= 50 && this.getBurrowProgress() <= 110;
    }

    public boolean isEmerging() {
        return this.getBurrowProgress() > 110;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.maw_claw_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 20.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22283_, 1.8);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.3 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.m_19956_(pPassenger, pCallback);
        pPassenger.m_6034_(this.m_20185_(), this.m_20186_() - 0.6, this.m_20189_());
    }

    public float getVolume() {
        return 2.15f;
    }

    public float getPitch(RandomSource random) {
        return 0.95f;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.aliveTicks;
        if (this.aliveTicks >= 4000 && this.isUnderground()) {
            this.m_146870_();
        }
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
            if (target != null && !this.isUnderground() && Math.random() <= (double)0.55f && this.m_20270_((Entity)target) <= 2.0f) {
                target.m_20329_((Entity)this);
            }
            if (this.burrowCooldown > 0) {
                --this.burrowCooldown;
            } else if (this.burrowCooldown == 0 && target != null && !this.m_20363_((Entity)target) && this.m_20270_((Entity)target) <= 32.0f) {
                int x = (int)target.m_20185_();
                int y = (int)target.m_20186_();
                int z = (int)target.m_20189_();
                this.burrowTo(x, y, z);
            }
            if (this.getBurrowProgress() > 0) {
                this.setBurrowProgress(this.getBurrowProgress() + 1);
                if (this.getBurrowProgress() == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MAW_CLAW_DIG.get(), SoundSource.PLAYERS, 2.2f, 1.0f);
                }
                if (this.getBurrowProgress() == 50) {
                    this.m_20984_((double)this.burrowX + 0.5, this.burrowY, (double)this.burrowZ + 0.5, false);
                }
                if (this.getBurrowProgress() == 160) {
                    this.setBurrowProgress(0);
                }
            }
        } else if (this.isBurrowing() || this.isEmerging()) {
            this.digParticles();
            this.prevClientBurrowProgress = this.clientBurrowProgress;
            this.clientBurrowProgress = this.getBurrowProgress();
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.isUnderground()) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            LivingEntity pLiving = (LivingEntity)pEntity;
            pLiving.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
        }
        return super.m_7327_(pEntity);
    }

    public void digParticles() {
        RandomSource random = this.m_217043_();
        BlockState blockState = this.m_20075_();
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 30; ++i) {
                double d = this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                double e = this.m_20186_();
                double f = this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean couldEntityFit(Entity entity, double x, double y, double z) {
        float w = entity.m_20205_() / 2.0f;
        float h = entity.m_20206_();
        for (VoxelShape voxelShape : entity.m_9236_().m_186434_(entity, new AABB(x - (double)w, y, z - (double)w, x + (double)w, y + (double)h, z + (double)w))) {
            if (voxelShape.m_83281_()) continue;
            return false;
        }
        return true;
    }

    public void burrowTo(int x, int y, int z) {
        if (this.canBurrow() && this.m_20096_() && this.couldEntityFit((Entity)this, (double)x + 0.5, y, (double)z + 0.5)) {
            this.burrowX = x;
            this.burrowY = y;
            this.burrowZ = z;
            this.setBurrowProgress(1);
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.burrowCooldown = 250;
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MAW_CLAW_DIG.get(), SoundSource.HOSTILE, 2.2f, 1.0f);
        }
    }

    public float getBurrowDepth() {
        return this.m_20206_() + 0.5f;
    }

    public boolean canBurrow() {
        return this.burrowCooldown == 0;
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.isUnderground();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }
}

