/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.event.extra;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.registry.HordeSpawnerRegistry;

@Mod.EventBusSubscriber(modid="dotf")
public class HordeSpawningEvent {
    private static Map<ResourceLocation, HordeSpawnerRegistry> spawners = new HashMap<ResourceLocation, HordeSpawnerRegistry>();

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        spawners.put(Level.f_46428_.m_135782_(), new HordeSpawnerRegistry(server));
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        HordeSpawnerRegistry spawner = spawners.get(event.level.m_46472_().m_135782_());
        if (spawner != null) {
            spawner.tick(event.level);
        }
    }
}

