/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.event.extra;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.entity.custom.special.PortalEntity;
import net.teamabyssalofficial.registry.GameruleRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;

@Mod.EventBusSubscriber(modid="dotf")
public class PlayerPhaseEvent {
    @SubscribeEvent
    public static void PhaseEvent(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.player.m_9236_();
            if (player instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)player;
                WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
                worldDataUtils.waveHandlerEvent(world, player2);
                if (worldDataUtils.getWave() > 4) {
                    double x = player2.m_20185_();
                    double y = player2.m_20186_();
                    double z = player2.m_20189_();
                    double radius = 500.0;
                    int minX = Mth.m_14107_((double)(x - radius - 1.0));
                    int maxX = Mth.m_14107_((double)(x + radius + 1.0));
                    int minY = Mth.m_14107_((double)(y - radius - 1.0));
                    int maxY = Mth.m_14107_((double)(y + radius + 1.0));
                    int minZ = Mth.m_14107_((double)(z - radius - 1.0));
                    int maxZ = Mth.m_14107_((double)(z + radius + 1.0));
                    AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                    List portalEntities = player2.m_9236_().m_45976_(PortalEntity.class, aabb);
                    if (portalEntities.isEmpty() && !player2.m_7500_() && !player2.m_5833_() && world.m_45527_(player2.m_20183_()) && player2.m_217043_().m_188503_(750) == 0) {
                        double randX = player2.m_20182_().f_82479_ + (double)player2.m_217043_().m_188503_(6);
                        double randY = player2.m_20182_().f_82480_;
                        double randZ = player2.m_20182_().f_82481_ + (double)player2.m_217043_().m_188503_(6);
                        Vec3 newPos = new Vec3(randX, randY, randZ);
                        PortalEntity.addPortal((Level)world, newPos);
                        player2.m_213846_((Component)Component.m_237113_((String)"The Flood has found a portal to Earth!").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_RED));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void PointIncrementEvent(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry(world);
            worldDataRegistry.tick(world);
            if (event.phase == TickEvent.Phase.END) {
                int currentWave = worldDataRegistry.getWave();
                int currentScore = worldDataRegistry.getScore();
                int main_score = 5;
                if (event.level.m_46791_() == Difficulty.EASY) {
                    if (Math.random() < (double)0.8f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 1;
                                break;
                            }
                            case 1: {
                                main_score = 2;
                                break;
                            }
                            case 2: {
                                main_score = 6;
                                break;
                            }
                            case 3: {
                                main_score = 27;
                                break;
                            }
                            case 4: {
                                main_score = 49;
                                break;
                            }
                            case 5: {
                                main_score = 93;
                                break;
                            }
                            case 6: {
                                main_score = 167;
                            }
                        }
                    } else if (Math.random() < (double)0.2f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 2;
                                break;
                            }
                            case 1: {
                                main_score = 3;
                                break;
                            }
                            case 2: {
                                main_score = 9;
                                break;
                            }
                            case 3: {
                                main_score = 34;
                                break;
                            }
                            case 4: {
                                main_score = 61;
                                break;
                            }
                            case 5: {
                                main_score = 98;
                                break;
                            }
                            case 6: {
                                main_score = 181;
                            }
                        }
                    }
                } else if (event.level.m_46791_() == Difficulty.NORMAL) {
                    if (Math.random() < (double)0.8f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 2;
                                break;
                            }
                            case 1: {
                                main_score = 3;
                                break;
                            }
                            case 2: {
                                main_score = 12;
                                break;
                            }
                            case 3: {
                                main_score = 39;
                                break;
                            }
                            case 4: {
                                main_score = 72;
                                break;
                            }
                            case 5: {
                                main_score = 145;
                                break;
                            }
                            case 6: {
                                main_score = 289;
                            }
                        }
                    } else if (Math.random() < (double)0.2f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 2;
                                break;
                            }
                            case 1: {
                                main_score = 4;
                                break;
                            }
                            case 2: {
                                main_score = 15;
                                break;
                            }
                            case 3: {
                                main_score = 56;
                                break;
                            }
                            case 4: {
                                main_score = 123;
                                break;
                            }
                            case 5: {
                                main_score = 270;
                                break;
                            }
                            case 6: {
                                main_score = 498;
                            }
                        }
                    }
                } else if (event.level.m_46791_() == Difficulty.HARD) {
                    if (Math.random() < (double)0.8f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 3;
                                break;
                            }
                            case 1: {
                                main_score = 7;
                                break;
                            }
                            case 2: {
                                main_score = 18;
                                break;
                            }
                            case 3: {
                                main_score = 67;
                                break;
                            }
                            case 4: {
                                main_score = 138;
                                break;
                            }
                            case 5: {
                                main_score = 227;
                                break;
                            }
                            case 6: {
                                main_score = 490;
                            }
                        }
                    } else if (Math.random() < (double)0.2f) {
                        switch (currentWave) {
                            case 0: {
                                main_score = 3;
                                break;
                            }
                            case 1: {
                                main_score = 8;
                                break;
                            }
                            case 2: {
                                main_score = 22;
                                break;
                            }
                            case 3: {
                                main_score = 88;
                                break;
                            }
                            case 4: {
                                main_score = 197;
                                break;
                            }
                            case 5: {
                                main_score = 381;
                                break;
                            }
                            case 6: {
                                main_score = 702;
                            }
                        }
                    }
                }
                if (Math.random() <= (double)0.01994f) {
                    worldDataRegistry.setScore(currentScore + main_score);
                }
                if (world.m_6106_().m_5470_().m_46207_(GameruleRegistry.CONSTANT_ZERO_WAVE_POINTS) && currentScore != 0) {
                    worldDataRegistry.setScore(0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void SleepEvent(PlayerSleepInBedEvent event) {
        Player player;
        if (event.getEntity() != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry((ServerLevel)player2.m_9236_());
            int currentWave = worldDataRegistry.getWave();
            int currentScore = worldDataRegistry.getScore();
            int addScore = 360 * (currentWave + 1);
            worldDataRegistry.setScore(currentScore + addScore);
        }
    }
}

