/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.bullet;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.guns.helper.GunBlockTags;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;

public class BulletProjectileEntity
extends Projectile {
    protected static final int EXPIRE_TIME = 300;
    private double bulletDamage;
    private float bulletSpeed;
    private boolean damageDecreasesWithDistance;

    public BulletProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public BulletProjectileEntity(LivingEntity owner, Level world, double bulletDamage, float bulletSpeed, boolean damageDecreasesWithDistance) {
        super((EntityType)EntityRegistry.BULLET_PROJECTILE.get(), world);
        this.m_5602_((Entity)owner);
        this.bulletDamage = bulletDamage;
        this.bulletSpeed = bulletSpeed;
        this.damageDecreasesWithDistance = damageDecreasesWithDistance;
    }

    public double getBulletDamage() {
        return this.bulletDamage;
    }

    public float getBulletSpeed() {
        return this.bulletSpeed;
    }

    public boolean doesDamageDecreaseWithDistance() {
        return this.damageDecreasesWithDistance;
    }

    public void shoot(Vec3 rotation) {
        this.m_20256_(rotation.m_82490_((double)this.getBulletSpeed()));
    }

    protected boolean m_5603_(Entity pTarget) {
        return super.m_5603_(pTarget) && pTarget != this.m_19749_();
    }

    public void m_6043_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!serverLevel.m_7726_().f_8325_.m_143145_().m_183913_(this.m_146902_().m_45588_())) {
                this.m_146870_();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 300) {
            this.m_146870_();
            return;
        }
        this.handleHitDetection();
        this.travel();
        if (this.m_20096_() || this.isInFluidType()) {
            this.m_146870_();
        }
    }

    public void handleHitDetection() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    public void travel() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
        if (!this.m_20068_()) {
            Vec3 vec34 = this.m_20184_();
            this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
        }
    }

    public DamageSource getDamage() {
        BulletProjectileEntity entity = this.m_19749_() == null ? this : this.m_19749_();
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.player_bullet_damage1((Entity)this, (Entity)entity), DamageTypeRegistry.player_bullet_damage2((Entity)this, (Entity)entity), DamageTypeRegistry.player_bullet_damage3((Entity)this, (Entity)entity), DamageTypeRegistry.player_bullet_damage4((Entity)this, (Entity)entity), DamageTypeRegistry.player_bullet_damage5((Entity)this, (Entity)entity));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
    }

    public boolean m_142391_() {
        return super.m_142391_() && !Objects.equals(this.m_146911_(), Entity.RemovalReason.UNLOADED_TO_CHUNK);
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("BulletDamage", this.getBulletDamage());
        tag.m_128350_("BulletSpeed", this.getBulletSpeed());
        tag.m_128405_("Age", this.f_19797_);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.bulletDamage = tag.m_128459_("BulletDamage");
        this.bulletSpeed = tag.m_128457_("BulletSpeed");
        this.f_19797_ = tag.m_128451_("Age");
    }

    protected void m_8060_(BlockHitResult pResult) {
        Level level;
        float destroySpeed;
        super.m_8060_(pResult);
        BlockPos pos = pResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Vec3 hitVec = pResult.m_82450_();
        Block block = state.m_60734_();
        if (((Boolean)DawnOfTheFloodConfig.SERVER.enableGlassBreaking.get()).booleanValue() && state.m_204336_(GunBlockTags.Blocks.FRAGILE) && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
            float chance = ((Double)DawnOfTheFloodConfig.SERVER.fragileBaseBreakChance.get()).floatValue() / (destroySpeed + 1.0f);
            if (this.f_19796_.m_188501_() < chance) {
                this.m_9236_().m_46961_(pos, ((Boolean)DawnOfTheFloodConfig.SERVER.fragileBlockDrops.get()).booleanValue());
            }
        }
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), pos, pResult.m_82434_());
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123762_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Player player;
        Entity farDamage2;
        LivingEntity livingEntity;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            double farDamage2 = this.getBulletDamage();
            if (this.doesDamageDecreaseWithDistance()) {
                farDamage2 -= (double)this.m_20270_((Entity)livingEntity);
            }
            DamageSource damagesource = this.getDamage();
            livingEntity.m_6469_(damagesource, (float)farDamage2);
            double dx = -Math.cos(Math.toRadians(livingEntity.m_146908_() + 90.0f));
            double dz = livingEntity.m_20189_();
            livingEntity.m_147240_(0.05, dx, dz);
            livingEntity.m_6703_((LivingEntity)this.m_19749_());
        }
        if ((farDamage2 = pResult.m_82443_()) instanceof Player && (player = (Player)farDamage2).m_21254_()) {
            player.m_36384_(true);
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.gun_bullet_crit.get()).booleanValue() && Math.random() <= (Double)DawnOfTheFloodConfig.SERVER.gun_bullet_crit_chance.get() && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            DamageSource damagesource = this.getDamage();
            livingEntity.m_6469_(damagesource, (float)this.getBulletDamage());
        }
        this.m_146870_();
    }

    public boolean m_6060_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

