/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.guns.event.RotationScaler;
import net.teamabyssalofficial.guns.gun.GunItem;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.ClientUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dotf")
public class RenderCameraEvent {
    private static final ReentrantLock mainLoopLock = new ReentrantLock();
    private static final RotationScaler rotationScaler = new RotationScaler(0.01, 0.1, 1.2217304706573486);

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        GeoBone cameraBone;
        GunItem gunItem;
        BakedGeoModel model;
        Item var4;
        ItemStack itemStack = ClientUtils.getClientPlayer().m_21205_();
        if (itemStack != null && ((Boolean)DawnOfTheFloodConfig.SERVER.camera_animations.get()).booleanValue() && (var4 = itemStack.m_41720_()) instanceof GunItem && (model = RenderCameraEvent.getModel((gunItem = (GunItem)var4).getID())) != null && (cameraBone = model.getBone("vfxcamera").orElse(null)) != null) {
            PoseStack poseStack = event.getPoseStack();
            if (cameraBone.getRotY() != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252961_(-cameraBone.getRotY()));
            }
            if (cameraBone.getRotX() != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252961_(-cameraBone.getRotX()));
            }
            if (cameraBone.getRotZ() != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252961_(-cameraBone.getRotZ()));
            }
        }
    }

    @SubscribeEvent
    public static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        ItemStack itemStack;
        Item var13;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_92176_().m_90612_() && ((Boolean)DawnOfTheFloodConfig.SERVER.camera_animations.get()).booleanValue() && (var13 = (itemStack = ClientUtils.getClientPlayer().m_21205_()).m_41720_()) instanceof GunItem) {
            GeoBone cameraBone;
            BakedGeoModel model;
            GunItem gunItem = (GunItem)var13;
            if (rotationScaler != null) {
                double roll = rotationScaler.getYaw();
                double yaw = rotationScaler.getYaw();
                event.setRoll(event.getRoll() + (float)roll * 15.0f);
                event.setYaw(event.getYaw() + (float)yaw * 15.0f);
            }
            if ((model = RenderCameraEvent.getModel(gunItem.getID())) != null && (cameraBone = model.getBone("vfxcamera").orElse(null)) != null) {
                float newPitch = (float)Math.toDegrees(cameraBone.getRotX());
                float newYaw = (float)Math.toDegrees(cameraBone.getRotY());
                float newRoll = (float)Math.toDegrees(cameraBone.getRotZ());
                event.setPitch(event.getPitch() - newPitch);
                event.setYaw(event.getYaw() - newYaw);
                event.setRoll(event.getRoll() - newRoll);
            }
        }
    }

    public static BakedGeoModel getModel(String itemName) {
        ResourceLocation resourceLocation = new ResourceLocation("dotf", "geo/gun/" + itemName + ".geo.json");
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(resourceLocation);
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Player player = ClientUtils.getClientPlayer();
        if (event.phase == TickEvent.Phase.START) {
            mainLoopLock.lock();
            if (player != null) {
                ItemStack gunStack = player.m_21205_();
                Minecraft mc = Minecraft.m_91087_();
                if (!mc.f_91066_.m_92176_().m_90612_()) {
                    return;
                }
                ItemDisplayContext itemDisplayContext = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                rotationScaler.onRenderTick((LivingEntity)player, gunStack, itemDisplayContext, event.renderTickTime);
            }
        } else if (event.phase == TickEvent.Phase.END && mainLoopLock.isLocked()) {
            mainLoopLock.unlock();
        }
    }
}

