/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.gun;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.ServerPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoPlayerAnimated;
import net.teamabyssalofficial.client.special.player.GeckoPlayerAnimations;
import net.teamabyssalofficial.client.special.player.GeckoPlayerController;
import net.teamabyssalofficial.dotf.DawnOfTheFlood;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.guns.animations.GunAnimations;
import net.teamabyssalofficial.guns.bullet.BlamiteCrystalEntity;
import net.teamabyssalofficial.guns.bullet.BulletProjectileEntity;
import net.teamabyssalofficial.guns.client.renderer.GunRenderer;
import net.teamabyssalofficial.guns.helper.GunInventoryHelper;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.util.PerformanceEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public abstract class GunItem
extends ProjectileWeaponItem
implements IForgeItem,
GeoAnimatable,
GeoItem {
    public final Random random;
    private final String gunID;
    private final String animationID;
    private final float bulletDamage;
    private final float bulletVelocity;
    private final int rateOfFire;
    private final int magSize;
    public final RegistryObject<Item> ammoType;
    private final int reloadCooldown;
    private final float[] bulletSpread;
    private final int pelletCount;
    private final LoadingType loadingType;
    private final SoundEvent reloadSoundStart;
    private final SoundEvent reloadSoundMagOut;
    private final SoundEvent reloadSoundMagIn;
    private final SoundEvent reloadSoundEnd;
    private final SoundEvent shootSound;
    private final SoundEvent postShootSound;
    private final int reloadCycles;
    private final boolean unscopeAfterShot;
    private final int reloadStage1;
    private final int reloadStage2;
    private final int reloadStage3;
    public final FiringType firingType;
    public final ArmType armType;
    public final MuzzleType muzzleType;
    public final GunProperties gunProperties;
    private final String muzzleColor;
    private final float muzzleFlashSizeNormal;
    private final float muzzleFlashSizeAim;
    private final int muzzleVariant;
    private final float fovModifier;
    private final int drawTicks;
    private final SoundEvent drawStartSound;
    private final SoundEvent drawEndSound;
    private final String crosshairType;
    private final SoundEvent noAmmoSound;
    private final SoundEvent inspectStartSound;
    private final SoundEvent inspectEndSound;
    private final int meleeTicks;
    private final int meleeHitTick;
    private final SoundEvent meleeSound;
    private final SoundEvent melee2Sound;
    private final int smokeParticles;
    private final boolean doesDamageDecreaseWithDistance;
    public int drawTick = 0;
    protected final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int prevClientTick = 2;

    public GunItem(Item.Properties settings, String gunID, String animationID, float bulletDamage, float bulletVelocity, int rateOfFire, int magSize, RegistryObject<Item> ammoType, int reloadCooldown, float[] bulletSpread, int pelletCount, LoadingType loadingType, SoundEvent reloadSoundStart, SoundEvent reloadSoundMagOut, SoundEvent reloadSoundMagIn, SoundEvent reloadSoundEnd, SoundEvent shootSound, SoundEvent postShootSound, int reloadCycles, boolean unscopeAfterShot, int reloadStage1, int reloadStage2, int reloadStage3, FiringType firingType, ArmType armType, MuzzleType muzzleType, GunProperties gunProperties, String muzzleColor, float muzzleFlashSizeNormal, float muzzleFlashSizeAim, int muzzleVariant, float fovModifier, int drawTicks, SoundEvent drawStartSound, SoundEvent drawEndSound, String crosshairType, SoundEvent noAmmoSound, SoundEvent inspectStartSound, SoundEvent inspectEndSound, int meleeTicks, int meleeHitTick, SoundEvent meleeSound, SoundEvent melee2Sound, int smokeParticles, boolean doesDamageDecreaseWithDistance) {
        super(settings.m_41503_(magSize * 10 + 1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.random = new Random();
        this.gunID = gunID;
        this.animationID = animationID;
        this.bulletDamage = bulletDamage;
        this.bulletVelocity = bulletVelocity;
        this.rateOfFire = rateOfFire;
        this.magSize = magSize;
        this.ammoType = ammoType;
        this.reloadCooldown = reloadCooldown;
        this.bulletSpread = bulletSpread;
        this.pelletCount = pelletCount;
        this.loadingType = loadingType;
        this.reloadSoundStart = reloadSoundStart;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.shootSound = shootSound;
        this.postShootSound = postShootSound;
        this.reloadCycles = reloadCycles;
        this.unscopeAfterShot = unscopeAfterShot;
        this.reloadStage1 = reloadStage1;
        this.reloadStage2 = reloadStage2;
        this.reloadStage3 = reloadStage3;
        this.firingType = firingType;
        this.armType = armType;
        this.muzzleType = muzzleType;
        this.gunProperties = gunProperties;
        this.muzzleColor = muzzleColor;
        this.muzzleFlashSizeNormal = muzzleFlashSizeNormal;
        this.muzzleFlashSizeAim = muzzleFlashSizeAim;
        this.muzzleVariant = muzzleVariant;
        this.fovModifier = fovModifier;
        this.drawTicks = drawTicks;
        this.drawStartSound = drawStartSound;
        this.drawEndSound = drawEndSound;
        this.crosshairType = crosshairType;
        this.noAmmoSound = noAmmoSound;
        this.inspectStartSound = inspectStartSound;
        this.inspectEndSound = inspectEndSound;
        this.meleeTicks = meleeTicks;
        this.meleeHitTick = meleeHitTick;
        this.meleeSound = meleeSound;
        this.melee2Sound = melee2Sound;
        this.smokeParticles = smokeParticles;
        this.doesDamageDecreaseWithDistance = doesDamageDecreaseWithDistance;
    }

    public void shoot(Level world, Player user, ItemStack itemStack) {
        itemStack.m_41784_().m_128405_("reloadTick", 0);
        itemStack.m_41784_().m_128405_("meleeTick", 0);
        itemStack.m_41784_().m_128379_("isReloading", false);
        itemStack.m_41784_().m_128379_("isInspecting", false);
        itemStack.m_41784_().m_128379_("isFiring", true);
        if (this.shouldUnscopeAfterShot() && itemStack.m_41784_().m_128471_("isAiming")) {
            itemStack.m_41784_().m_128379_("isAiming", false);
        }
        if (!world.f_46443_) {
            for (int i = 0; i < this.getPelletCount(); ++i) {
                double point = (double)(this.random.nextBoolean() ? 1 : -1) * 2.0;
                double pX = (double)this.getBulletSpread()[1] * (double)this.random.nextFloat() + (double)this.random.nextFloat() * (double)(this.getBulletSpread()[0] - this.getBulletSpread()[1]) * point;
                if (this.getGunProperties() == GunProperties.NORMAL) {
                    BulletProjectileEntity bulletProjectile = new BulletProjectileEntity((LivingEntity)user, world, this.getBulletDamage(), this.getBulletVelocity(), this.doesDamageDecreaseWithDistance());
                    bulletProjectile.m_146884_(user.m_20182_().m_82520_(pX, (double)user.m_20192_(), 0.0));
                    bulletProjectile.shoot(user.m_20154_());
                    bulletProjectile.m_5602_((Entity)user);
                    world.m_7967_((Entity)bulletProjectile);
                    continue;
                }
                BlamiteCrystalEntity blamiteCrystalEntity = new BlamiteCrystalEntity((LivingEntity)user, world, this.getBulletDamage(), this.getBulletVelocity(), this.doesDamageDecreaseWithDistance());
                blamiteCrystalEntity.m_146884_(user.m_20182_().m_82520_(pX, (double)user.m_20192_(), 0.0));
                blamiteCrystalEntity.shoot(user.m_20154_());
                blamiteCrystalEntity.m_5602_((Entity)user);
                world.m_7967_((Entity)blamiteCrystalEntity);
            }
            if (((Boolean)DawnOfTheFloodConfig.SERVER.gun_spawn_smoke.get()).booleanValue()) {
                double y = itemStack.m_41784_().m_128471_("isAiming") ? user.m_20188_() - 0.3 : user.m_20188_() - 0.5;
                for (int i = 0; i < this.getSmokeParticles(); ++i) {
                    if (PerformanceEngine.hasPerformanceModeOn()) continue;
                    AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getWeaponSmoke().clone().scale(0.15f).position(user.m_20208_(0.25), y, user.m_20262_(0.25)));
                }
            }
            long id = GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)world));
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.m_130070_(itemStack.m_41784_().m_128471_("isAiming") ? "aim_firing" : "firing");
            buf.writeLong(id);
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)user), (ResourceLocation)DawnOfTheFlood.PLAY_ANIMATION_PACKET_ID, (FriendlyByteBuf)buf);
            FriendlyByteBuf buf3 = PacketByteBufs.create();
            buf3.writeFloat(1.0f);
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)user), (ResourceLocation)DawnOfTheFlood.S2C_SOUND, (FriendlyByteBuf)buf3);
        }
        if (!user.m_7500_()) {
            itemStack.m_41784_().m_128405_("Clip", itemStack.m_41784_().m_128451_("Clip") - 1);
            itemStack.m_41622_(10, (LivingEntity)user, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (this.reloadCycles > 1) {
            itemStack.m_41784_().m_128405_("currentCycle", itemStack.m_41784_().m_128451_("Clip"));
        }
    }

    private void setDefaultNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("reloadTick", 0);
        nbtCompound.m_128405_("meleeTick", 0);
        nbtCompound.m_128405_("currentCycle", 1);
        nbtCompound.m_128405_("Clip", this.getMagSize());
        nbtCompound.m_128379_("isReloading", false);
        nbtCompound.m_128379_("isAiming", false);
        nbtCompound.m_128379_("isFiring", false);
        nbtCompound.m_128379_("isInspecting", false);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        this.setDefaultNBT(pStack);
        if (pLevel instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel));
            this.triggerAnim((Entity)pPlayer, id, "controller", "idle");
        }
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Ammo: " + pStack.m_41784_().m_128451_("Clip") + "/" + this.magSize)).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Damage: " + this.getBulletDamage())).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)("RPM: " + (int)(20.0f / (float)this.rateOfFire * 60.0f))).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Reload Time: " + (float)this.reloadCooldown / 20.0f + "s")).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Uses:").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)((Item)this.getAmmoType().get()).m_5524_()).m_130940_(ChatFormatting.YELLOW));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Ammo: " + pStack.m_41784_().m_128451_("Clip") + "/" + this.magSize)).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Uses:").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)((Item)this.getAmmoType().get()).m_5524_()).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Press Shift to see stats").m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        boolean isSprinting = entity.m_20142_();
        ItemStack mainHandGun = ((Player)entity).m_21205_();
        boolean isSpectator = ((Player)entity).m_5833_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        if (nbtCompound.m_128451_("meleeTick") > 0) {
            nbtCompound.m_128405_("meleeTick", nbtCompound.m_128451_("meleeTick") - 1);
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (world.f_46443_) {
            FriendlyByteBuf bufA;
            if (mainHandGun != stack) {
                GeckoPlayerAnimated.stopAnimation((Player)entity, GeckoPlayer.Perspective.THIRD_PERSON);
                GeckoPlayerAnimated.resetAnimation((Player)entity, GeckoPlayer.Perspective.THIRD_PERSON);
            }
            Minecraft client = Minecraft.m_91087_();
            Options options = client.f_91066_;
            boolean canAnimate = options.m_92176_().m_90612_();
            boolean canDoPlayerMelee = this.canDoPlayerMelee((Player)entity);
            this.updateBooleanTag(nbtCompound, "isDrawing", nbtCompound.m_128471_("isDrawn"));
            if (nbtCompound.m_128471_("isDrawing") && nbtCompound.m_128451_("drawnTick") < this.getDrawTicks()) {
                ++this.drawTick;
                nbtCompound.m_128405_("drawnTick", this.drawTick);
            }
            if (id == GeoItem.getId((ItemStack)((Player)entity).m_21205_())) {
                if (!nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128379_("isDrawn", true);
                }
                if (nbtCompound.m_128471_("isDrawing") && canAnimate && !isSpectator) {
                    this.handleDrawingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController);
                }
            } else if (GeoItem.getId((ItemStack)((Player)entity).m_21205_()) != id) {
                if (nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128473_("isDrawn");
                    nbtCompound.m_128473_("drawnTick");
                    this.drawTick = 0;
                }
                nbtCompound.m_128379_("isAiming", false);
                animationController.tryTriggerAnimation("idle");
            }
            if (animationController.getCurrentRawAnimation() != GunAnimations.IDLE && !canAnimate) {
                animationController.tryTriggerAnimation("idle");
            }
            if (animationController.getCurrentAnimation() != null && !animationController.getAnimationState().equals((Object)AnimationController.State.STOPPED) && nbtCompound.m_128451_("drawnTick") >= this.getDrawTicks() && nbtCompound.m_128451_("meleeTick") <= 0) {
                if (!(!isSprinting || mainHandGun.m_41784_().m_128471_("isAiming") || mainHandGun != stack || mainHandGun.m_41784_().m_128471_("isReloading") || animationController.isPlayingTriggeredAnimation() && animationController.getCurrentAnimation().animation().name().equals("sprinting") || animationController.getCurrentAnimation().animation().name().equals("melee") && !animationController.getAnimationState().equals((Object)AnimationController.State.PAUSED) || !canAnimate || !((Boolean)DawnOfTheFloodConfig.SERVER.gun_sprint_animation.get()).booleanValue())) {
                    animationController.tryTriggerAnimation("sprinting");
                } else if (animationController.getCurrentRawAnimation() == GunAnimations.AIM && !KeybindHelper.getAimMapping().m_90857_()) {
                    animationController.tryTriggerAnimation("idle");
                } else if (animationController.getCurrentRawAnimation() == GunAnimations.AIM && !KeybindHelper.getAimMapping().m_90857_() && !KeybindHelper.getShootMapping().m_90857_()) {
                    animationController.tryTriggerAnimation("idle");
                } else if (animationController.getCurrentRawAnimation() == GunAnimations.AIM && !nbtCompound.m_128471_("isAiming")) {
                    animationController.tryTriggerAnimation("idle");
                } else if (animationController.getCurrentRawAnimation() == GunAnimations.AIM || animationController.getCurrentRawAnimation() == GunAnimations.AIM_FIRING && isSprinting) {
                    animationController.tryTriggerAnimation("idle");
                }
            }
            if (mainHandGun != stack || animationController.getAnimationState() != AnimationController.State.PAUSED) {
                GeckoPlayerAnimated.resetAnimation((Player)entity, GeckoPlayer.Perspective.THIRD_PERSON);
                GeckoPlayerAnimated.stopAnimation((Player)entity, GeckoPlayer.Perspective.THIRD_PERSON);
            }
            if (mainHandGun == stack && KeybindHelper.getReloadMapping().m_90857_() && GunItem.remainingAmmo(stack) < this.getMagSize() && GunItem.reserveAmmoCount((Player)entity, (Item)this.getAmmoType().get()) > 0 && !nbtCompound.m_128471_("isReloading") && !isSprinting && nbtCompound.m_128451_("drawnTick") >= this.getDrawTicks() && nbtCompound.m_128451_("meleeTick") <= 0 && !isSpectator) {
                FriendlyByteBuf buf = PacketByteBufs.create();
                buf.writeBoolean(canAnimate);
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.RELOAD_PACKET_ID, (FriendlyByteBuf)buf);
                GeckoPlayerAnimated.playAnimation((Player)entity, "gun_reload", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 1.0f);
            }
            if (!(mainHandGun != stack || !KeybindHelper.getInspectMapping().m_90857_() || isSprinting || isSpectator || nbtCompound.m_128471_("isReloading") || nbtCompound.m_128471_("isAiming") || animationController.getCurrentRawAnimation() == GunAnimations.INSPECT || nbtCompound.m_128451_("drawnTick") < this.getDrawTicks() || nbtCompound.m_128451_("meleeTick") > 0)) {
                FriendlyByteBuf bufX = PacketByteBufs.create();
                bufX.writeBoolean(canAnimate);
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.INSPECT_PACKET_ID, (FriendlyByteBuf)bufX);
            }
            if (mainHandGun == stack && !nbtCompound.m_128471_("isAiming") && KeybindHelper.getMeleeMapping().m_90857_() && !isSpectator && !isSprinting && nbtCompound.m_128451_("drawnTick") >= this.getDrawTicks() && animationController.getCurrentRawAnimation() != GunAnimations.MELEE) {
                FriendlyByteBuf bufY = PacketByteBufs.create();
                bufY.writeInt(this.getMeleeTicks());
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.MELEE_PACKET_ID, (FriendlyByteBuf)bufY);
                int rand = this.random.nextInt(3);
                int ind = switch (rand) {
                    case 1 -> 1;
                    case 2 -> 2;
                    default -> 3;
                };
                if (canDoPlayerMelee) {
                    GeckoPlayerAnimated.playAnimation((Player)entity, "gun_melee" + ind, GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 1.0f);
                }
                if (canAnimate) {
                    animationController.tryTriggerAnimation("melee");
                }
            }
            if (mainHandGun == stack && nbtCompound.m_128451_("meleeTick") == this.getMeleeHitTick()) {
                bufA = PacketByteBufs.create();
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.MELEE_DAMAGE_PACKET_ID, (FriendlyByteBuf)bufA);
            }
            if (mainHandGun == stack && nbtCompound.m_128451_("drawnTick") >= this.getDrawTicks() && nbtCompound.m_128451_("meleeTick") <= 0 && !isSpectator) {
                bufA = PacketByteBufs.create();
                FriendlyByteBuf bufF = PacketByteBufs.create();
                bufA.writeBoolean(KeybindHelper.getAimMapping().m_90857_());
                bufF.writeBoolean(KeybindHelper.getShootMapping().m_90857_());
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_AIMING, (FriendlyByteBuf)bufA);
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_FIRING, (FriendlyByteBuf)bufF);
                if (!(!KeybindHelper.getShootMapping().m_90857_() || nbtCompound.m_128471_("isReloading") || ((Player)entity).m_36335_().m_41519_((Item)this) || entity.m_20142_() || GunItem.isLoaded(stack))) {
                    entity.m_5496_(this.getNoAmmoSound(), 1.0f, 1.0f);
                    ((Player)entity).m_5661_((Component)Component.m_237113_((String)"Out of ammo!"), true);
                }
                if (KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading")) {
                    if (!((Player)entity).m_36335_().m_41519_((Item)this) && !entity.m_20142_() && GunItem.isLoaded(stack)) {
                        FriendlyByteBuf bufR = PacketByteBufs.create();
                        bufR.writeBoolean(true);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_SHOOTING, (FriendlyByteBuf)bufR);
                        boolean isAiming = nbtCompound.m_128471_("isAiming");
                        GeckoPlayerAnimated.playAnimation((Player)entity, isAiming ? "gun_aim_fire" : "gun_fire", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 1.0f);
                    }
                } else if (KeybindHelper.getAimMapping().m_90857_() && KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading")) {
                    if (!((Player)entity).m_36335_().m_41519_((Item)this) && !entity.m_20142_() && GunItem.isLoaded(stack)) {
                        FriendlyByteBuf bufAA = PacketByteBufs.create();
                        FriendlyByteBuf bufFF = PacketByteBufs.create();
                        bufAA.writeBoolean(true);
                        bufFF.writeBoolean(true);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_AIMING, (FriendlyByteBuf)bufAA);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_FIRING, (FriendlyByteBuf)bufFF);
                        GeckoPlayerAnimated.playAnimation((Player)entity, "gun_aim_fire", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 1.0f);
                        if (canAnimate & !((Player)entity).m_36335_().m_41519_((Item)this)) {
                            animationController.tryTriggerAnimation("aim_firing");
                        }
                    }
                } else if (KeybindHelper.getAimMapping().m_90857_() && !KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading") && !entity.m_20142_()) {
                    FriendlyByteBuf bufAAA = PacketByteBufs.create();
                    bufAAA.writeBoolean(true);
                    ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_AIMING, (FriendlyByteBuf)bufAAA);
                    if (canAnimate & !((Player)entity).m_36335_().m_41519_((Item)this)) {
                        animationController.tryTriggerAnimation("aim");
                    }
                } else {
                    FriendlyByteBuf bufAAAA = PacketByteBufs.create();
                    bufAAAA.writeBoolean(false);
                    ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_AIMING, (FriendlyByteBuf)bufAAAA);
                }
                if (animationController.getCurrentRawAnimation() == GunAnimations.AIM && !KeybindHelper.getAimMapping().m_90857_() || animationController.getCurrentRawAnimation() == GunAnimations.AIM_FIRING && !KeybindHelper.getShootMapping().m_90857_() && !KeybindHelper.getAimMapping().m_90857_()) {
                    animationController.tryTriggerAnimation("idle");
                }
            }
        }
        if (mainHandGun != stack && nbtCompound.m_128471_("isAiming") && nbtCompound.m_128451_("drawnTick") >= this.getDrawTicks() && nbtCompound.m_128451_("meleeTick") >= this.getMeleeTicks()) {
            nbtCompound.m_128379_("isAiming", false);
        }
        if (nbtCompound.m_128471_("isReloading") && !isSprinting && !isSpectator) {
            if (mainHandGun != stack || GunItem.reserveAmmoCount((Player)entity, (Item)this.getAmmoType().get()) <= 0 && this.reloadCycles <= 1 || nbtCompound.m_128451_("reloadTick") >= this.getReloadCooldown() || GunItem.remainingAmmo(stack) >= this.getMagSize() && this.reloadCycles <= 1) {
                nbtCompound.m_128379_("isReloading", false);
            }
            this.doReloadTick(world, nbtCompound, (Player)entity, stack);
        } else {
            if (nbtCompound.m_128451_("reloadTick") > this.reloadStage3 && nbtCompound.m_128451_("reloadTick") <= this.getReloadCooldown() && !isSpectator) {
                this.finishReload((Player)entity, stack);
            }
            nbtCompound.m_128379_("isReloading", false);
            nbtCompound.m_128405_("reloadTick", 0);
        }
    }

    private GeckoPlayerController<GeckoPlayer> getController(Player player) {
        GeckoPlayerController<GeckoPlayer> controller = GeckoPlayer.getAnimationController(player, GeckoPlayer.Perspective.THIRD_PERSON);
        return controller;
    }

    private boolean canDoPlayerMelee(Player entity) {
        GeckoPlayerController<GeckoPlayer> controller = this.getController(entity);
        boolean canDoPlayerMelee = false;
        if (controller != null) {
            canDoPlayerMelee = controller.getCurrentRawAnimation() != GeckoPlayerAnimations.GUN_MELEE1 && controller.getCurrentRawAnimation() != GeckoPlayerAnimations.GUN_MELEE2 && controller.getCurrentRawAnimation() != GeckoPlayerAnimations.GUN_MELEE3;
        }
        return canDoPlayerMelee;
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    private void handleDrawingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController) {
        if (nbt.m_128451_("drawnTick") < this.getDrawTicks()) {
            animationController.tryTriggerAnimation("draw");
        }
        nbt.m_128379_("isFiring", false);
        nbt.m_128379_("isInspecting", false);
    }

    private void doReloadTick(Level world, CompoundTag nbtCompound, Player player, ItemStack stack) {
        int rTick = nbtCompound.m_128451_("reloadTick");
        if (world instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)world));
            if (nbtCompound.m_128451_("reloadTick") == this.reloadStage1) {
                this.triggerAnim((Entity)player, id, "controller", "reload_magout");
            } else if (nbtCompound.m_128451_("reloadTick") == this.reloadStage2) {
                this.triggerAnim((Entity)player, id, "controller", "reload_magin");
            } else if (nbtCompound.m_128451_("reloadTick") == this.reloadStage3) {
                this.triggerAnim((Entity)player, id, "controller", "reload_end");
            }
        }
        nbtCompound.m_128405_("reloadTick", nbtCompound.m_128451_("reloadTick") + 1);
        switch (this.getLoadingType()) {
            case MAGAZINE: {
                if (rTick < this.getReloadCooldown() || GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) <= 0) break;
                nbtCompound.m_128405_("currentCycle", 1);
                this.finishReload(player, stack);
                nbtCompound.m_128405_("reloadTick", 0);
                break;
            }
            case PER_CARTRIDGE: {
                if (rTick < this.reloadStage3 || nbtCompound.m_128451_("currentCycle") >= this.reloadCycles || GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) <= 0) break;
                nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + 1);
                GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), 1);
                if (GunItem.remainingAmmo(stack) < this.getMagSize() && GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) > 0) {
                    nbtCompound.m_128405_("reloadTick", this.reloadStage2);
                }
                nbtCompound.m_128405_("currentCycle", nbtCompound.m_128451_("Clip"));
                stack.m_41721_(this.m_41462_() - (nbtCompound.m_128451_("Clip") * 10 + 1));
            }
        }
    }

    public void hit(Player player) {
        AABB boundingBox = player.m_20191_().m_82400_((double)1.2f);
        List entities = player.m_9236_().m_45933_((Entity)player, boundingBox);
        for (Entity entity : entities) {
            Player player1;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player && !player.m_7099_(player1 = (Player)livingEntity)) {
                return;
            }
            float dist = player.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(livingEntity.m_269291_().m_269075_(player), this.getBulletDamage() / 6.0f * (1.0f / dist));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return null;
    }

    public static boolean isLoaded(ItemStack stack) {
        return GunItem.remainingAmmo(stack) > 0;
    }

    public void finishReload(Player player, ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        int ammoToLoad = this.getMagSize() - nbtCompound.m_128451_("Clip");
        if (GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) >= ammoToLoad) {
            nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + ammoToLoad);
            GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), ammoToLoad);
        } else {
            nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()));
            GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()));
        }
        stack.m_41721_(this.m_41462_() - (nbtCompound.m_128451_("Clip") * 10 + 1));
    }

    public static int remainingAmmo(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        return nbtCompound.m_128451_("Clip");
    }

    public static int reserveAmmoCount(Player player, Item item) {
        return GunInventoryHelper.itemCountInInventory(player, item);
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pMiningEntity) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_142159_(ItemStack pStack) {
        return Objects.requireNonNull(ChatFormatting.YELLOW.m_126665_());
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return itemStack -> itemStack.m_41720_() instanceof GunItem;
    }

    public int m_6615_() {
        return 0;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GunRenderer(new ResourceLocation("dotf", GunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<GunItem> event) {
        if ((event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) && event.getController().getCurrentRawAnimation() != GunAnimations.AIM_FIRING || event.getController().getCurrentRawAnimation() != GunAnimations.AIM) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", this.prevClientTick, this::predicate).triggerableAnim("idle", GunAnimations.IDLE).triggerableAnim("melee", GunAnimations.MELEE).triggerableAnim("draw", GunAnimations.DRAW).triggerableAnim("firing", GunAnimations.FIRING).triggerableAnim("reload_start", GunAnimations.RELOAD_START).triggerableAnim("reload_magout", GunAnimations.RELOAD_MAGOUT).triggerableAnim("reload_magin", GunAnimations.RELOAD_MAGIN).triggerableAnim("reload_end", GunAnimations.RELOAD_END).triggerableAnim("inspect", GunAnimations.INSPECT).triggerableAnim("aim", GunAnimations.AIM).triggerableAnim("aim_firing", GunAnimations.AIM_FIRING).triggerableAnim("aim_reload_start", GunAnimations.AIM_RELOAD_START).triggerableAnim("sprinting", GunAnimations.SPRINTING);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    private void soundListener(SoundKeyframeEvent<GunItem> gunItemSoundKeyframeEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "reload_start": {
                    player.m_5496_(this.getReloadSoundStart(), 1.0f, 1.0f);
                    break;
                }
                case "reload_magout": {
                    player.m_5496_(this.getReloadSoundMagOut(), 1.0f, 1.0f);
                    break;
                }
                case "reload_magin": {
                    player.m_5496_(this.getReloadSoundMagIn(), 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    player.m_5496_(this.getReloadSoundEnd(), 1.0f, 1.0f);
                    break;
                }
                case "post_shoot": {
                    player.m_5496_(this.getPostShootSound(), 1.35f, 0.95f);
                    break;
                }
                case "inspect1": {
                    player.m_5496_(this.getInspectStartSound(), 1.0f, 1.0f);
                    break;
                }
                case "inspect2": {
                    player.m_5496_(this.getInspectEndSound(), 1.0f, 1.0f);
                    break;
                }
                case "draw1": {
                    player.m_5496_(this.getDrawStartSound(), 1.0f, 1.0f);
                    break;
                }
                case "draw2": {
                    player.m_5496_(this.getDrawEndSound(), 1.0f, 1.0f);
                    break;
                }
                case "melee": {
                    player.m_5496_(this.getMeleeSound(), 1.0f, 1.0f);
                    break;
                }
                case "melee2": {
                    player.m_5496_(this.getMelee2Sound(), 1.0f, 1.0f);
                }
            }
        }
    }

    public String getID() {
        return this.gunID;
    }

    public String getAnimationID() {
        return this.animationID;
    }

    public RegistryObject<Item> getAmmoType() {
        return this.ammoType;
    }

    public float getBulletDamage() {
        return this.bulletDamage;
    }

    public float getBulletVelocity() {
        return this.bulletVelocity;
    }

    public int getRateOfFire() {
        return this.rateOfFire;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public float[] getBulletSpread() {
        return this.bulletSpread;
    }

    public int getReloadCooldown() {
        return this.reloadCooldown;
    }

    public boolean shouldUnscopeAfterShot() {
        return this.unscopeAfterShot;
    }

    public SoundEvent getShootSound() {
        return this.shootSound;
    }

    public SoundEvent getReloadSoundStart() {
        return this.reloadSoundStart;
    }

    public SoundEvent getReloadSoundMagIn() {
        return this.reloadSoundMagIn;
    }

    public SoundEvent getReloadSoundMagOut() {
        return this.reloadSoundMagOut;
    }

    public SoundEvent getReloadSoundEnd() {
        return this.reloadSoundEnd;
    }

    public SoundEvent getPostShootSound() {
        return this.postShootSound;
    }

    public SoundEvent getDrawStartSound() {
        return this.drawStartSound;
    }

    public SoundEvent getDrawEndSound() {
        return this.drawEndSound;
    }

    public float getMuzzleFlashSizeNormal() {
        return this.muzzleFlashSizeNormal;
    }

    public float getMuzzleFlashSizeAim() {
        return this.muzzleFlashSizeAim;
    }

    public float getFovModifier() {
        return this.fovModifier;
    }

    public LoadingType getLoadingType() {
        return this.loadingType;
    }

    public FiringType getFiringType() {
        return this.firingType;
    }

    public MuzzleType getMuzzleType() {
        return this.muzzleType;
    }

    public ArmType getArmType() {
        return this.armType;
    }

    public int getMuzzleVariant() {
        return this.muzzleVariant;
    }

    public String getMuzzleColor() {
        return this.muzzleColor;
    }

    public GunProperties getGunProperties() {
        return this.gunProperties;
    }

    public int getDrawTicks() {
        return this.drawTicks;
    }

    public String getCrosshairType() {
        return this.crosshairType;
    }

    public SoundEvent getNoAmmoSound() {
        return this.noAmmoSound;
    }

    public SoundEvent getInspectStartSound() {
        return this.inspectStartSound;
    }

    public SoundEvent getInspectEndSound() {
        return this.inspectEndSound;
    }

    public int getMeleeTicks() {
        return this.meleeTicks;
    }

    public SoundEvent getMeleeSound() {
        return this.meleeSound;
    }

    public int getMeleeHitTick() {
        return this.meleeHitTick;
    }

    public SoundEvent getMelee2Sound() {
        return this.melee2Sound;
    }

    public int getSmokeParticles() {
        return this.smokeParticles;
    }

    public boolean doesDamageDecreaseWithDistance() {
        return this.doesDamageDecreaseWithDistance;
    }

    public static enum LoadingType {
        MAGAZINE,
        PER_CARTRIDGE;

    }

    public static enum FiringType {
        SEMI_AUTO,
        AUTO;

    }

    public static enum ArmType {
        HANDGUN_ONEHAND,
        HANDGUN_TWOHAND,
        LONG_GUNS;

    }

    public static enum MuzzleType {
        NORMAL,
        EMERALD,
        PLASMA,
        AMETHYST,
        RUBY,
        NONE;

    }

    public static enum GunProperties {
        NORMAL,
        NEEDLER;

    }
}

