/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.helper;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.teamabyssalofficial.crafting.WorkbenchIngredient;

public class GunInventoryHelper {
    public static int itemCountInInventory(Player player, Item item) {
        int itemCount = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)new ItemStack((ItemLike)item))) continue;
            itemCount += currentStack.m_41613_();
        }
        return Math.max(itemCount, 0);
    }

    public static int getItemStackAmount(Player player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !GunInventoryHelper.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static boolean areItemStacksEqualIgnoreCount(ItemStack source, ItemStack target) {
        if (source.m_41720_() != target.m_41720_()) {
            return false;
        }
        if (source.m_41773_() != target.m_41773_()) {
            return false;
        }
        if (source.m_41783_() == null && target.m_41783_() != null) {
            return false;
        }
        return (source.m_41783_() == null || source.m_41783_().equals((Object)target.m_41783_())) && source.areCapsCompatible((CapabilityProvider)target);
    }

    public static void removeItemFromInventory(Player player, Item item, int count) {
        if (player.m_7500_()) {
            return;
        }
        int itemsToRemove = count;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)new ItemStack((ItemLike)item))) continue;
            if (currentStack.m_41613_() > itemsToRemove) {
                currentStack.m_41774_(itemsToRemove);
                itemsToRemove = 0;
                break;
            }
            currentStack.m_41764_(0);
            if ((itemsToRemove -= currentStack.m_41613_()) == 0) break;
        }
    }

    public static boolean hasWorkstationIngredient(Player player, WorkbenchIngredient find) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !find.test(stack)) continue;
            count += stack.m_41613_();
        }
        return find.getCount() <= count;
    }

    public static boolean removeWorkstationIngredient(Player player, WorkbenchIngredient find) {
        int amount = find.getCount();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !find.test(stack)) continue;
            if (amount - stack.m_41613_() < 0) {
                stack.m_41774_(amount);
                return true;
            }
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            if ((amount -= stack.m_41613_()) != 0) continue;
            return true;
        }
        return false;
    }
}

