/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.datagen.tags.MixinTags;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IronGolem.class})
public abstract class IronGolemMixin
extends AbstractGolem {
    protected IronGolemMixin(EntityType<? extends AbstractGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="RETURN")}, method={"canAttackType"}, cancellable=true)
    public void canAttack(EntityType<?> type, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.dawnOfTheFlood$isBodyType(type) || this.dawnOfTheFlood$commonHelp(type) && this.dawnOfTheFlood$hasArmistice(this.m_9236_()) && ((Boolean)DawnOfTheFloodConfig.SERVER.illager_human_alliance.get()).booleanValue()) {
            this.m_6710_(null);
            cir.setReturnValue((Object)false);
        } else {
            cir.setReturnValue((Object)super.m_6549_(type));
        }
    }

    @Unique
    public boolean dawnOfTheFlood$isBodyType(EntityType<?> type) {
        return type.m_204039_(MixinTags.EntityTypes.CORPSE);
    }

    @Unique
    public boolean dawnOfTheFlood$commonHelp(EntityType<?> type) {
        return type.m_204039_(EntityTypeTags.f_13121_) || this.dawnOfTheFlood$isVex(type);
    }

    @Unique
    public boolean dawnOfTheFlood$isVex(EntityType<?> type) {
        return type == EntityType.f_20491_;
    }

    @Unique
    public boolean dawnOfTheFlood$hasArmistice(Level level) {
        ServerLevel world;
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > (Integer)DawnOfTheFloodConfig.SERVER.illager_human_alliance_wave.get();
    }
}

