/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.registry;

import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.blocks.BloodSplash1;
import net.teamabyssalofficial.blocks.BloodSplash2;
import net.teamabyssalofficial.blocks.BloodSplash3;
import net.teamabyssalofficial.blocks.BloodSplash4;
import net.teamabyssalofficial.blocks.FloodBigEggBlock;
import net.teamabyssalofficial.blocks.FloodBloodSplash1;
import net.teamabyssalofficial.blocks.FloodBloodSplash2;
import net.teamabyssalofficial.blocks.FloodBloodSplash3;
import net.teamabyssalofficial.blocks.FloodBloodSplash4;
import net.teamabyssalofficial.blocks.FloodBloom;
import net.teamabyssalofficial.blocks.GunWorkbench;
import net.teamabyssalofficial.blocks.HealthPackBlock;
import net.teamabyssalofficial.blocks.HiveBlock;
import net.teamabyssalofficial.blocks.HiveBloom;
import net.teamabyssalofficial.blocks.InfectedPureBiomassFloodRock;
import net.teamabyssalofficial.blocks.LandmineBlock;
import net.teamabyssalofficial.blocks.PureBiomassFloodRock;
import net.teamabyssalofficial.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dotf");
    public static final RegistryObject<Block> TUNGSTEN_BLOCK = BlockRegistry.registerBlock("tungsten_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> TUNGSTEN_ORE = BlockRegistry.registerBlock("tungsten_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)6)));
    public static final RegistryObject<Block> DEEPSLATE_TUNGSTEN_ORE = BlockRegistry.registerBlock("deepslate_tungsten_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_60978_(5.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> HIVE_BLOCK = BlockRegistry.registerBlock("hive_block", () -> new HiveBlock(BlockBehaviour.Properties.m_284310_().m_60913_(1.6f, 1.6f)));
    public static final RegistryObject<Block> HIVE_BLOOM = BlockRegistry.registerBlock("hive_bloom", () -> new HiveBloom(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> FLOOD_BLOOM = BlockRegistry.registerBlock("flood_bloom", () -> new FloodBloom(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> BLOOD_SPLASH1 = BlockRegistry.registerBlock("blood_splash1", () -> new BloodSplash1(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> BLOOD_SPLASH2 = BlockRegistry.registerBlock("blood_splash2", () -> new BloodSplash2(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> BLOOD_SPLASH3 = BlockRegistry.registerBlock("blood_splash3", () -> new BloodSplash3(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> BLOOD_SPLASH4 = BlockRegistry.registerBlock("blood_splash4", () -> new BloodSplash4(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> FLOOD_BLOOD_SPLASH1 = BlockRegistry.registerBlock("flood_blood_splash1", () -> new FloodBloodSplash1(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> FLOOD_BLOOD_SPLASH2 = BlockRegistry.registerBlock("flood_blood_splash2", () -> new FloodBloodSplash2(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> FLOOD_BLOOD_SPLASH3 = BlockRegistry.registerBlock("flood_blood_splash3", () -> new FloodBloodSplash3(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> FLOOD_BLOOD_SPLASH4 = BlockRegistry.registerBlock("flood_blood_splash4", () -> new FloodBloodSplash4(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 0.0f)));
    public static final RegistryObject<Block> HEALTH_PACK_BLOCK = BlockRegistry.registerBlock("health_pack", () -> new HealthPackBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.8f, 2.0f)));
    public static final RegistryObject<Block> GUN_WORKBENCH = BlockRegistry.registerBlock("gun_workbench", GunWorkbench::new);
    public static final RegistryObject<Block> LANDMINE = BlockRegistry.registerBlock("landmine", () -> new LandmineBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.8f, 2.0f)));
    public static final RegistryObject<Block> FLOOD_BIG_EGG = BlockRegistry.registerBlock("flood_big_egg", () -> new FloodBigEggBlock(BlockBehaviour.Properties.m_284310_().m_60913_(1.6f, 2.2f)));
    public static final RegistryObject<Block> PURE_BIOMASS_FLOOD_ROCK = BlockRegistry.registerBlock("pure_biomass_flood_rock", PureBiomassFloodRock::new);
    public static final RegistryObject<Block> INFECTED_PURE_BIOMASS_FLOOD_ROCK = BlockRegistry.registerBlock("infected_pure_biomass_flood_rock", InfectedPureBiomassFloodRock::new);

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

