/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.entity.custom.CarrierFormEntity;
import net.teamabyssalofficial.entity.custom.DeadEvokerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadHumanFormEntity;
import net.teamabyssalofficial.entity.custom.DeadMarineFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPillagerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPlayerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadSangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVillagerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVindicatorFormEntity;
import net.teamabyssalofficial.entity.custom.EndermanFormEntity;
import net.teamabyssalofficial.entity.custom.EvokerFormEntity;
import net.teamabyssalofficial.entity.custom.FloodTadpoleEntity;
import net.teamabyssalofficial.entity.custom.HumanFormEntity;
import net.teamabyssalofficial.entity.custom.MarineFormEntity;
import net.teamabyssalofficial.entity.custom.MawFormEntity;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.VillagerFormEntity;
import net.teamabyssalofficial.entity.custom.VindicatorFormEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.FragmentGrenadeEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.entity.custom.special.MawClawEntity;
import net.teamabyssalofficial.entity.custom.special.PlasmaGrenadeEntity;
import net.teamabyssalofficial.entity.custom.special.PortalEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBlamiteCrystalEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.guns.bullet.BlamiteCrystalEntity;
import net.teamabyssalofficial.guns.bullet.BulletProjectileEntity;
import net.teamabyssalofficial.util.ConstantUtils;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"dotf");
    public static final MobCategory FLOOD = MobCategory.create((String)"flood", (String)"flood", (int)ConstantUtils.getMobCap(), (boolean)false, (boolean)false, (int)128);
    public static final List<Entity> FLOOD_FORMS = new ArrayList<Entity>();
    public static final RegistryObject<EntityType<PodInfectorEntity>> POD_INFECTOR = ENTITY_TYPES.register("pod_infector", () -> EntityType.Builder.m_20704_(PodInfectorEntity::new, (MobCategory)FLOOD).m_20699_(0.85f, 0.95f).m_20712_(new ResourceLocation("dotf", "pod_infector").toString()));
    public static final RegistryObject<EntityType<FloodTadpoleEntity>> FLOOD_TADPOLE = ENTITY_TYPES.register("flood_tadpole", () -> EntityType.Builder.m_20704_(FloodTadpoleEntity::new, (MobCategory)FLOOD).m_20699_(0.65f, 0.75f).m_20712_(new ResourceLocation("dotf", "flood_tadpole").toString()));
    public static final RegistryObject<EntityType<HumanFormEntity>> HUMAN_FORM = ENTITY_TYPES.register("human_form", () -> EntityType.Builder.m_20704_(HumanFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "human_form").toString()));
    public static final RegistryObject<EntityType<VillagerFormEntity>> VILLAGER_FORM = ENTITY_TYPES.register("villager_form", () -> EntityType.Builder.m_20704_(VillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "villager_form").toString()));
    public static final RegistryObject<EntityType<PillagerFormEntity>> PILLAGER_FORM = ENTITY_TYPES.register("pillager_form", () -> EntityType.Builder.m_20704_(PillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "pillager_form").toString()));
    public static final RegistryObject<EntityType<VindicatorFormEntity>> VINDICATOR_FORM = ENTITY_TYPES.register("vindicator_form", () -> EntityType.Builder.m_20704_(VindicatorFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "vindicator_form").toString()));
    public static final RegistryObject<EntityType<EvokerFormEntity>> EVOKER_FORM = ENTITY_TYPES.register("evoker_form", () -> EntityType.Builder.m_20704_(EvokerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "evoker_form").toString()));
    public static final RegistryObject<EntityType<PlayerFormEntity>> PLAYER_FORM = ENTITY_TYPES.register("player_form", () -> EntityType.Builder.m_20704_(PlayerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.2f, 2.1f).m_20712_(new ResourceLocation("dotf", "player_form").toString()));
    public static final RegistryObject<EntityType<SangheiliFormEntity>> SANGHEILI_FORM = ENTITY_TYPES.register("sangheili_form", () -> EntityType.Builder.m_20704_(SangheiliFormEntity::new, (MobCategory)FLOOD).m_20699_(1.65f, 3.3f).m_20712_(new ResourceLocation("dotf", "sangheili_form").toString()));
    public static final RegistryObject<EntityType<MarineFormEntity>> MARINE_FORM = ENTITY_TYPES.register("marine_form", () -> EntityType.Builder.m_20704_(MarineFormEntity::new, (MobCategory)FLOOD).m_20699_(1.25f, 2.4f).m_20712_(new ResourceLocation("dotf", "marine_form").toString()));
    public static final RegistryObject<EntityType<CarrierFormEntity>> CARRIER_FORM = ENTITY_TYPES.register("carrier_form", () -> EntityType.Builder.m_20704_(CarrierFormEntity::new, (MobCategory)FLOOD).m_20699_(1.35f, 2.25f).m_20712_(new ResourceLocation("dotf", "carrier_form").toString()));
    public static final RegistryObject<EntityType<EndermanFormEntity>> ENDERMAN_FORM = ENTITY_TYPES.register("enderman_form", () -> EntityType.Builder.m_20704_(EndermanFormEntity::new, (MobCategory)FLOOD).m_20699_(1.25f, 3.15f).m_20712_(new ResourceLocation("dotf", "enderman_form").toString()));
    public static final RegistryObject<EntityType<MawFormEntity>> MAW_FORM = ENTITY_TYPES.register("maw_form", () -> EntityType.Builder.m_20704_(MawFormEntity::new, (MobCategory)FLOOD).m_20699_(2.1f, 6.75f).m_20712_(new ResourceLocation("dotf", "maw_form").toString()));
    public static final RegistryObject<EntityType<MawClawEntity>> MAW_CLAW = ENTITY_TYPES.register("maw_claw", () -> EntityType.Builder.m_20704_(MawClawEntity::new, (MobCategory)FLOOD).m_20699_(0.95f, 1.8f).m_20698_().m_20712_(new ResourceLocation("dotf", "maw_claw").toString()));
    public static final RegistryObject<EntityType<DeadHumanFormEntity>> DEAD_HUMAN_FORM = ENTITY_TYPES.register("dead_human_form", () -> EntityType.Builder.m_20704_(DeadHumanFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_human_form").toString()));
    public static final RegistryObject<EntityType<DeadPlayerFormEntity>> DEAD_PLAYER_FORM = ENTITY_TYPES.register("dead_player_form", () -> EntityType.Builder.m_20704_(DeadPlayerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_player_form").toString()));
    public static final RegistryObject<EntityType<DeadVillagerFormEntity>> DEAD_VILLAGER_FORM = ENTITY_TYPES.register("dead_villager_form", () -> EntityType.Builder.m_20704_(DeadVillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_villager_form").toString()));
    public static final RegistryObject<EntityType<DeadPillagerFormEntity>> DEAD_PILLAGER_FORM = ENTITY_TYPES.register("dead_pillager_form", () -> EntityType.Builder.m_20704_(DeadPillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_pillager_form").toString()));
    public static final RegistryObject<EntityType<DeadVindicatorFormEntity>> DEAD_VINDICATOR_FORM = ENTITY_TYPES.register("dead_vindicator_form", () -> EntityType.Builder.m_20704_(DeadVindicatorFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_vindicator_form").toString()));
    public static final RegistryObject<EntityType<DeadEvokerFormEntity>> DEAD_EVOKER_FORM = ENTITY_TYPES.register("dead_evoker_form", () -> EntityType.Builder.m_20704_(DeadEvokerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_evoker_form").toString()));
    public static final RegistryObject<EntityType<DeadSangheiliFormEntity>> DEAD_SANGHEILI_FORM = ENTITY_TYPES.register("dead_sangheili_form", () -> EntityType.Builder.m_20704_(DeadSangheiliFormEntity::new, (MobCategory)FLOOD).m_20699_(2.25f, 1.05f).m_20712_(new ResourceLocation("dotf", "dead_sangheili_form").toString()));
    public static final RegistryObject<EntityType<DeadMarineFormEntity>> DEAD_MARINE_FORM = ENTITY_TYPES.register("dead_marine_form", () -> EntityType.Builder.m_20704_(DeadMarineFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 1.05f).m_20712_(new ResourceLocation("dotf", "dead_marine_form").toString()));
    public static final RegistryObject<EntityType<IronAxeEntity>> IRON_AXE_ENTITY = ENTITY_TYPES.register("iron_axe_entity", () -> EntityType.Builder.m_20704_(IronAxeEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(10).m_20712_(new ResourceLocation("dotf", "iron_axe_entity").toString()));
    public static final RegistryObject<EntityType<CovenantOrsShipEntity>> COVENANT_FLOODED_SHIP = ENTITY_TYPES.register("covenant_ors_flooded_cruiser", () -> EntityType.Builder.m_20704_(CovenantOrsShipEntity::new, (MobCategory)MobCategory.MISC).m_20699_(10.0f, 3.2f).m_20702_(16).m_20719_().m_20698_().m_20712_(new ResourceLocation("dotf", "covenant_ors_flooded_cruiser").toString()));
    public static final RegistryObject<EntityType<PortalEntity>> PORTAL = ENTITY_TYPES.register("portal", () -> EntityType.Builder.m_20704_(PortalEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_(new ResourceLocation("dotf", "portal").toString()));
    public static final RegistryObject<EntityType<BulletProjectileEntity>> BULLET_PROJECTILE = ENTITY_TYPES.register("bullet_projectile", () -> EntityType.Builder.m_20704_(BulletProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).setCustomClientFactory((spawnEntity, level) -> null).m_20712_(new ResourceLocation("dotf", "bullet_projectile").toString()));
    public static final RegistryObject<EntityType<BlamiteCrystalEntity>> BLAMITE_CRYSTAL_ENTITY = ENTITY_TYPES.register("blamite_crystal_entity", () -> EntityType.Builder.m_20704_(BlamiteCrystalEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(100).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).setCustomClientFactory((spawnEntity, level) -> null).m_20712_(new ResourceLocation("dotf", "blamite_crystal_entity").toString()));
    public static final RegistryObject<EntityType<AbstractBullet>> BULLET = ENTITY_TYPES.register("bullet", () -> EntityType.Builder.m_20704_(AbstractBullet::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).m_20712_(new ResourceLocation("dotf", "bullet").toString()));
    public static final RegistryObject<EntityType<AbstractBlamiteCrystalEntity>> ABSTRACT_BLAMITE_CRYSTAL_ENTITY = ENTITY_TYPES.register("abstract_blamite_crystal_entity", () -> EntityType.Builder.m_20704_(AbstractBlamiteCrystalEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).m_20712_(new ResourceLocation("dotf", "abstract_blamite_crystal_entity").toString()));
    public static final RegistryObject<EntityType<FragmentGrenadeEntity>> FRAGMENT_GRENADE = ENTITY_TYPES.register("fragment_grenade", () -> EntityType.Builder.m_20704_(FragmentGrenadeEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.25f, 0.25f).setTrackingRange(100).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20712_("fragment_grenade"));
    public static final RegistryObject<EntityType<PlasmaGrenadeEntity>> PLASMA_GRENADE = ENTITY_TYPES.register("plasma_grenade", () -> EntityType.Builder.m_20704_(PlasmaGrenadeEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.25f, 0.25f).setTrackingRange(100).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20712_("plasma_grenade"));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITY_TYPES.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }
}

