/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.registry;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;

public class HordeSpawnerRegistry {
    private int nextTick;

    public HordeSpawnerRegistry(MinecraftServer server) {
    }

    public int tick(Level level) {
        ServerLevel world;
        if (!((Boolean)DawnOfTheFloodConfig.SERVER.enable_horde.get()).booleanValue()) {
            return 0;
        }
        RandomSource random = level.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += (Integer)DawnOfTheFloodConfig.SERVER.ticksBeforeHordeSpawning.get() + (Integer)DawnOfTheFloodConfig.SERVER.additionalRandomizedTicks.get();
        if (level.m_46462_() && level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2) {
            if (random.m_188503_(5) != 0) {
                return 0;
            }
            int j = level.m_6907_().size();
            if (j < 1) {
                return 0;
            }
            Player player = (Player)level.m_6907_().get(random.m_188503_(j));
            if (player.m_5833_()) {
                return 0;
            }
            int k = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            int l = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            int i1 = 10;
            if (!level.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10)) {
                return 0;
            }
            Holder holder = level.m_204166_((BlockPos)blockpos$mutableblockpos);
            if (holder.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            int j1 = 0;
            int currentWave = WorldDataUtils.getWorldDataRegistry(world).getWave();
            int k1 = (Integer)DawnOfTheFloodConfig.SERVER.mobSpawnAttempts.get() + (Integer)DawnOfTheFloodConfig.SERVER.additionalHordeMobs.get() * ((currentWave - 1) / 2);
            for (int l1 = 0; l1 < k1; ++l1) {
                ++j1;
                blockpos$mutableblockpos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_());
                if (l1 == 0) {
                    if (!this.spawnHordeEntity(level, (BlockPos)blockpos$mutableblockpos, random, true)) {
                        break;
                    }
                } else {
                    this.spawnHordeEntity(level, (BlockPos)blockpos$mutableblockpos, random, false);
                    player.m_5661_((Component)Component.m_237113_((String)"They're coming.").m_130940_(ChatFormatting.DARK_RED), true);
                    player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)SoundRegistry.HORDE_SPAWNED.get(), SoundSource.MASTER, 1.2f, 1.0f);
                }
                blockpos$mutableblockpos.m_142451_(blockpos$mutableblockpos.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                blockpos$mutableblockpos.m_142443_(blockpos$mutableblockpos.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
            }
            return j1;
        }
        return 0;
    }

    private boolean spawnHordeEntity(Level level, BlockPos blockPos, RandomSource randomSource, boolean spawn) {
        BlockState blockstate = level.m_8055_(blockPos);
        BlockState downState = level.m_8055_(blockPos.m_7495_());
        if (level.m_7146_(blockPos) > 1) {
            return false;
        }
        if (blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || downState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry((ServerLevel)level);
        BaseForm hordeEntity = switch (worldDataUtils.getWave()) {
            case 4, 5, 6 -> {
                int rand = randomSource.m_188503_(18);
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        yield (BaseForm)((EntityType)EntityRegistry.HUMAN_FORM.get()).m_20615_(level);
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        yield (BaseForm)((EntityType)EntityRegistry.PLAYER_FORM.get()).m_20615_(level);
                    }
                    case 8: {
                        yield (BaseForm)((EntityType)EntityRegistry.SANGHEILI_FORM.get()).m_20615_(level);
                    }
                    case 9: 
                    case 10: {
                        yield (BaseForm)((EntityType)EntityRegistry.PILLAGER_FORM.get()).m_20615_(level);
                    }
                    case 11: 
                    case 12: {
                        yield (BaseForm)((EntityType)EntityRegistry.VINDICATOR_FORM.get()).m_20615_(level);
                    }
                    case 13: {
                        yield (BaseForm)((EntityType)EntityRegistry.EVOKER_FORM.get()).m_20615_(level);
                    }
                    case 14: 
                    case 15: {
                        yield (BaseForm)((EntityType)EntityRegistry.MARINE_FORM.get()).m_20615_(level);
                    }
                }
                yield (BaseForm)((EntityType)EntityRegistry.VILLAGER_FORM.get()).m_20615_(level);
            }
            default -> {
                int rand = randomSource.m_188503_(15);
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        yield (BaseForm)((EntityType)EntityRegistry.HUMAN_FORM.get()).m_20615_(level);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        yield (BaseForm)((EntityType)EntityRegistry.PLAYER_FORM.get()).m_20615_(level);
                    }
                    case 7: 
                    case 8: {
                        yield (BaseForm)((EntityType)EntityRegistry.PILLAGER_FORM.get()).m_20615_(level);
                    }
                    case 9: 
                    case 10: {
                        yield (BaseForm)((EntityType)EntityRegistry.VINDICATOR_FORM.get()).m_20615_(level);
                    }
                    case 11: {
                        yield (BaseForm)((EntityType)EntityRegistry.EVOKER_FORM.get()).m_20615_(level);
                    }
                    case 12: {
                        yield (BaseForm)((EntityType)EntityRegistry.MARINE_FORM.get()).m_20615_(level);
                    }
                }
                yield (BaseForm)((EntityType)EntityRegistry.VILLAGER_FORM.get()).m_20615_(level);
            }
        };
        if (hordeEntity != null) {
            if (spawn) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.findPatrolTarget();
            }
            hordeEntity.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            hordeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(blockPos), MobSpawnType.PATROL, null, null);
            ((ServerLevel)level).m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

