/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport.event;

import java.util.List;
import net.genzyuro.artillerysupport.item.ArtillerySupportItems;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

public class CustomWanderingTraderTrades {
    @SubscribeEvent
    public static void addCustomTrades(WandererTradesEvent event) {
        ArtillerySupportItems.ITEMS.getEntries().stream().filter(item -> item.getId().m_135815_().endsWith("_smoke_bomb")).forEach(item -> {
            String itemName = item.getId().m_135815_();
            int cost = CustomWanderingTraderTrades.calculateCost(itemName);
            CustomWanderingTraderTrades.addTrade(event.getGenericTrades(), item, cost);
        });
    }

    private static int calculateCost(String itemName) {
        int baseCost = itemName.contains("large") || itemName.contains("b1") ? 30 : (itemName.contains("light") ? 10 : 20);
        if (itemName.contains("continuous_fire") || itemName.contains("concentrated_fire") || itemName.contains("volley_fire")) {
            baseCost = (int)Math.ceil((double)baseCost * 1.2);
        }
        if (itemName.contains("single_fire")) {
            baseCost = (int)Math.ceil((double)baseCost * 0.5);
        }
        return baseCost;
    }

    private static void addTrade(List<VillagerTrades.ItemListing> trades, RegistryObject<?> item, int emeraldPrice) {
        trades.add((entity, random) -> {
            String itemName = item.getId().m_135815_();
            int sellCount = itemName.contains("single_fire") ? 4 : 1;
            ItemStack sellingItem = new ItemStack((ItemLike)((Item)item.get()), sellCount);
            ItemStack price = new ItemStack((ItemLike)Items.f_42616_, emeraldPrice);
            return new MerchantOffer(price, sellingItem, 2, 10, 0.05f);
        });
    }
}

