/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.render;

import dev.worldgen.remapped.map.RemappedState;
import dev.worldgen.remapped.render.RemappedMapTextureManager;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10090;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_20;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9209;
import net.minecraft.class_9443;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class RemappedMapRenderer {
    private final RemappedMapTextureManager textureManager;
    private final class_9443 decorationsAtlasManager;

    public RemappedMapRenderer(class_9443 decorationsAtlasManager, RemappedMapTextureManager textureManager) {
        this.decorationsAtlasManager = decorationsAtlasManager;
        this.textureManager = textureManager;
    }

    public void draw(class_10090 state, class_4587 matrices, class_4597 vertexConsumers, boolean hidePlayerIcons, int light) {
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23028((class_2960)state.field_53638));
        vertexConsumer.method_22918(matrix4f, 0.0f, 128.0f, -0.01f).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(light);
        vertexConsumer.method_22918(matrix4f, 128.0f, 128.0f, -0.01f).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(light);
        vertexConsumer.method_22918(matrix4f, 128.0f, 0.0f, -0.01f).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(light);
        vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, -0.01f).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(light);
        int i = 0;
        for (class_10090.class_10091 decoration : state.field_53639) {
            if (hidePlayerIcons && !decoration.field_53644) continue;
            matrices.method_22903();
            matrices.method_46416((float)decoration.field_53641 / 2.0f + 64.0f, (float)decoration.field_53642 / 2.0f + 64.0f, -0.02f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(decoration.field_53643 * 360) / 16.0f));
            matrices.method_22905(4.0f, 4.0f, 3.0f);
            matrices.method_46416(-0.125f, 0.125f, 0.0f);
            Matrix4f matrix4f2 = matrices.method_23760().method_23761();
            class_1058 sprite = decoration.field_53640;
            if (sprite != null) {
                class_4588 vertexConsumer2 = vertexConsumers.getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
                vertexConsumer2.method_22918(matrix4f2, -1.0f, 1.0f, (float)i * -0.001f).method_39415(-1).method_22913(sprite.method_4594(), sprite.method_4593()).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, 1.0f, (float)i * -0.001f).method_39415(-1).method_22913(sprite.method_4577(), sprite.method_4593()).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, -1.0f, (float)i * -0.001f).method_39415(-1).method_22913(sprite.method_4577(), sprite.method_4575()).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, -1.0f, -1.0f, (float)i * -0.001f).method_39415(-1).method_22913(sprite.method_4594(), sprite.method_4575()).method_60803(light);
                matrices.method_22909();
            }
            if (decoration.field_53645 != null) {
                class_327 textRenderer = class_310.method_1551().field_1772;
                float f = textRenderer.method_27525((class_5348)decoration.field_53645);
                float var10000 = 25.0f / f;
                Objects.requireNonNull(textRenderer);
                float g = class_3532.method_15363((float)var10000, (float)0.0f, (float)0.6666667f);
                matrices.method_22903();
                matrices.method_46416((float)decoration.field_53641 / 2.0f + 64.0f - f * g / 2.0f, (float)decoration.field_53642 / 2.0f + 64.0f + 4.0f, -0.025f);
                matrices.method_22905(g, g, 1.0f);
                matrices.method_46416(0.0f, 0.0f, -0.1f);
                textRenderer.method_30882(decoration.field_53645, 0.0f, 0.0f, -1, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, Integer.MIN_VALUE, light, false);
                matrices.method_22909();
            }
            ++i;
        }
    }

    public void update(class_9209 mapId, RemappedState mapState, class_10090 renderState) {
        renderState.field_53638 = this.textureManager.getTextureId(mapId, mapState);
        renderState.field_53639.clear();
        for (class_20 mapDecoration : mapState.getDecorations()) {
            renderState.field_53639.add(this.createDecoration(mapDecoration));
        }
    }

    private class_10090.class_10091 createDecoration(class_20 decoration) {
        class_10090.class_10091 decoration2 = new class_10090.class_10091();
        decoration2.field_53640 = this.decorationsAtlasManager.method_58516(decoration);
        decoration2.field_53641 = decoration.comp_1843();
        decoration2.field_53642 = decoration.comp_1844();
        decoration2.field_53643 = decoration.comp_1845();
        decoration2.field_53645 = decoration.comp_1846().orElse(null);
        decoration2.field_53644 = decoration.method_94();
        return decoration2;
    }

    public RemappedMapTextureManager getTextureManager() {
        return this.textureManager;
    }

    public void clear() {
        this.textureManager.clear();
    }
}

