/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.remapped.color.RemappedColor;
import dev.worldgen.remapped.network.s2c.MapUpdatePacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_19;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9209;
import net.minecraft.class_9292;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class RemappedState
extends class_18 {
    private static final int SIZE = 128;
    private static final int SIZE_HALF = 64;
    private static final int MAX_DECORATIONS = 256;
    private static final byte MAX_SCALE = 4;
    private static final Codec<Byte> SCALE_CODEC = Codec.BYTE.validate(value -> value >= 0 && value <= 4 ? DataResult.success((Object)value) : DataResult.error(() -> "Value must be within range [0, 4]: " + value));
    private static final Codec<List<Integer>> PIXEL_CODEC = Codec.INT.listOf().validate(list -> list.size() == 16384 ? DataResult.success((Object)list) : DataResult.error(() -> "List should have 16384 entries, got " + list.size()));
    private static final Codec<class_19> FRAME_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(class_19::method_86), (App)Codec.INT.fieldOf("rotation").forGetter(class_19::method_83), (App)Codec.INT.fieldOf("entity_id").forGetter(class_19::method_85)).apply((Applicative)instance, class_19::new));
    private static final Codec<RemappedState> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1937.field_25178.fieldOf("dimension").forGetter(RemappedState::dimension), (App)Codec.INT.fieldOf("center_x").orElse((Object)0).forGetter(RemappedState::centerX), (App)Codec.INT.fieldOf("center_z").orElse((Object)0).forGetter(RemappedState::centerZ), (App)SCALE_CODEC.fieldOf("scale").orElse((Object)0).forGetter(RemappedState::scale), (App)Codec.BOOL.fieldOf("show_decorations").orElse((Object)true).forGetter(RemappedState::showDecorations), (App)Codec.BOOL.fieldOf("unlimited_tracking").orElse((Object)true).forGetter(RemappedState::unlimitedTracking), (App)Codec.BOOL.fieldOf("locked").orElse((Object)false).forGetter(RemappedState::locked), (App)PIXEL_CODEC.fieldOf("colors").orElse(RemappedState.getDefaultPixels()).forGetter(RemappedState::colors), (App)class_17.field_48919.fieldOf("banners").orElse(List.of()).forGetter(RemappedState::banners), (App)FRAME_CODEC.listOf().fieldOf("frames").forGetter(RemappedState::frames)).apply((Applicative)instance, RemappedState::new));
    private static final Codec<RemappedState> LEGACY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1937.field_25178.fieldOf("dimension").forGetter(RemappedState::dimension), (App)Codec.INT.fieldOf("xCenter").orElse((Object)0).forGetter(RemappedState::centerX), (App)Codec.INT.fieldOf("zCenter").orElse((Object)0).forGetter(RemappedState::centerZ), (App)SCALE_CODEC.fieldOf("scale").orElse((Object)0).forGetter(RemappedState::scale), (App)Codec.BOOL.fieldOf("trackingPosition").orElse((Object)true).forGetter(RemappedState::showDecorations), (App)Codec.BOOL.fieldOf("unlimitedTracking").orElse((Object)true).forGetter(RemappedState::unlimitedTracking), (App)Codec.BOOL.fieldOf("locked").orElse((Object)false).forGetter(RemappedState::locked)).apply((Applicative)instance, RemappedState::new));
    private static final Codec<RemappedState> CODEC = Codec.withAlternative(BASE_CODEC, LEGACY_CODEC);
    private final class_5321<class_1937> dimension;
    private final int centerX;
    private final int centerZ;
    private final byte scale;
    private final boolean showDecorations;
    private final boolean unlimitedTracking;
    private final boolean locked;
    public List<Integer> colors;
    private final Map<String, class_17> trackedBanners = Maps.newHashMap();
    private final Map<String, class_19> trackedFrames = Maps.newHashMap();
    final Map<String, class_20> decorations = Maps.newLinkedHashMap();
    private int decorationCount;
    private final List<PlayerUpdateTracker> updateTrackers = Lists.newArrayList();
    private final Map<class_1657, PlayerUpdateTracker> updateTrackersByPlayer = Maps.newHashMap();

    public static class_18.class_8645<RemappedState> getPersistentStateType() {
        return new class_18.class_8645(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, RemappedState::fromNbt, null);
    }

    private RemappedState(class_5321<class_1937> dimension, int centerX, int centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, boolean locked) {
        this(dimension, centerX, centerZ, scale, showDecorations, unlimitedTracking, locked, RemappedState.getDefaultPixels(), List.of(), List.of());
    }

    private RemappedState(class_5321<class_1937> dimension, int centerX, int centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, boolean locked, List<Integer> colors, List<class_17> banners, List<class_19> frames) {
        this.dimension = dimension;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.scale = scale;
        this.showDecorations = showDecorations;
        this.unlimitedTracking = unlimitedTracking;
        this.locked = locked;
        this.colors = new ArrayList<Integer>(colors);
        for (class_17 class_172 : banners) {
            this.trackedBanners.put(class_172.method_71(), class_172);
            this.addDecoration((class_6880<class_9428>)class_172.method_72(), null, class_172.method_71(), class_172.comp_2312().method_10263(), class_172.comp_2312().method_10260(), 180.0, class_172.comp_2314().orElse(null));
        }
        for (class_19 class_192 : frames) {
            this.trackedFrames.put(class_192.method_82(), class_192);
            this.addDecoration((class_6880<class_9428>)class_21.field_95, null, RemappedState.getFrameDecorationKey(class_192.method_85()), class_192.method_86().method_10263(), class_192.method_86().method_10260(), class_192.method_83(), null);
        }
        this.method_80();
    }

    public int getPixelColor(int index) {
        return this.colors.get(index);
    }

    public int centerX() {
        return this.centerX;
    }

    public int centerZ() {
        return this.centerZ;
    }

    public byte scale() {
        return this.scale;
    }

    public boolean showDecorations() {
        return this.showDecorations;
    }

    public boolean unlimitedTracking() {
        return this.unlimitedTracking;
    }

    public boolean locked() {
        return this.locked;
    }

    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    public List<Integer> colors() {
        return this.colors;
    }

    public List<class_17> banners() {
        return this.trackedBanners.values().stream().toList();
    }

    public List<class_19> frames() {
        return this.trackedFrames.values().stream().toList();
    }

    private static List<Integer> getDefaultPixels() {
        Object[] pixels = new Integer[16384];
        Arrays.fill(pixels, (Object)0);
        return Arrays.asList(pixels);
    }

    public static RemappedState of(int centerX, int centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, class_5321<class_1937> dimension, boolean adjustCenter) {
        int i = 128 * (1 << scale);
        int j = class_3532.method_15357((double)((double)(centerX + 64) / (double)i));
        int k = class_3532.method_15357((double)((double)(centerZ + 64) / (double)i));
        int l = j * i + i / 2 - 64;
        int m = k * i + i / 2 - 64;
        int newX = adjustCenter ? l : centerX;
        int newZ = adjustCenter ? m : centerZ;
        return new RemappedState(dimension, newX, newZ, scale, showDecorations, unlimitedTracking, false, RemappedState.getDefaultPixels(), List.of(), List.of());
    }

    public static RemappedState of(byte scale, boolean locked, class_5321<class_1937> dimension) {
        return new RemappedState(dimension, 0, 0, scale, false, false, locked, RemappedState.getDefaultPixels(), List.of(), List.of());
    }

    public static RemappedState fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        return (RemappedState)((Object)CODEC.parse((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).getOrThrow());
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 compound;
        class_2520 element = (class_2520)BASE_CODEC.encodeStart((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this).result().orElseThrow();
        return element instanceof class_2487 ? (compound = (class_2487)element) : nbt;
    }

    public RemappedState copy() {
        RemappedState remappedState = new RemappedState(this.dimension, this.centerX, this.centerZ, this.scale, this.showDecorations, this.unlimitedTracking, true, this.colors, this.trackedBanners.values().stream().toList(), this.trackedFrames.values().stream().toList());
        remappedState.method_80();
        return remappedState;
    }

    public RemappedState zoomOut(boolean scaleFromCenter) {
        return RemappedState.of(this.centerX, this.centerZ, (byte)class_3532.method_15340((int)(this.scale + 1), (int)0, (int)4), this.showDecorations, this.unlimitedTracking, this.dimension, !scaleFromCenter);
    }

    private static Predicate<class_1799> getEqualPredicate(class_1799 stack) {
        class_9209 mapIdComponent = (class_9209)stack.method_57824(class_9334.field_49646);
        return other -> {
            if (other == stack) {
                return true;
            }
            return other.method_31574(stack.method_7909()) && Objects.equals(mapIdComponent, other.method_57824(class_9334.field_49646));
        };
    }

    public void update(class_1657 player, class_1799 stack) {
        if (!this.updateTrackersByPlayer.containsKey(player)) {
            PlayerUpdateTracker playerUpdateTracker = new PlayerUpdateTracker(player);
            this.updateTrackersByPlayer.put(player, playerUpdateTracker);
            this.updateTrackers.add(playerUpdateTracker);
        }
        Predicate<class_1799> predicate = RemappedState.getEqualPredicate(stack);
        if (!player.method_31548().method_55753(predicate)) {
            this.removeDecoration(player.method_5477().getString());
        }
        for (int i = 0; i < this.updateTrackers.size(); ++i) {
            PlayerUpdateTracker playerUpdateTracker2 = this.updateTrackers.get(i);
            String string = playerUpdateTracker2.player.method_5477().getString();
            if (playerUpdateTracker2.player.method_31481() || !playerUpdateTracker2.player.method_31548().method_55753(predicate) && !stack.method_7961()) {
                this.updateTrackersByPlayer.remove(playerUpdateTracker2.player);
                this.updateTrackers.remove(playerUpdateTracker2);
                this.removeDecoration(string);
                continue;
            }
            if (stack.method_7961() || playerUpdateTracker2.player.method_37908().method_27983() != this.dimension || !this.showDecorations) continue;
            this.addDecoration((class_6880<class_9428>)class_21.field_91, (class_1936)playerUpdateTracker2.player.method_37908(), string, playerUpdateTracker2.player.method_23317(), playerUpdateTracker2.player.method_23321(), playerUpdateTracker2.player.method_36454(), null);
        }
        if (stack.method_7961() && this.showDecorations) {
            class_1533 itemFrameEntity = stack.method_7945();
            class_2338 blockPos = itemFrameEntity.method_59940();
            class_19 mapFrameMarker = this.trackedFrames.get(class_19.method_81((class_2338)blockPos));
            if (mapFrameMarker != null && itemFrameEntity.method_5628() != mapFrameMarker.method_85() && this.trackedFrames.containsKey(mapFrameMarker.method_82())) {
                this.removeDecoration(RemappedState.getFrameDecorationKey(mapFrameMarker.method_85()));
            }
            class_19 mapFrameMarker2 = new class_19(blockPos, itemFrameEntity.method_5735().method_10161() * 90, itemFrameEntity.method_5628());
            this.addDecoration((class_6880<class_9428>)class_21.field_95, (class_1936)player.method_37908(), RemappedState.getFrameDecorationKey(itemFrameEntity.method_5628()), blockPos.method_10263(), blockPos.method_10260(), itemFrameEntity.method_5735().method_10161() * 90, null);
            this.trackedFrames.put(mapFrameMarker2.method_82(), mapFrameMarker2);
        }
        class_9292 mapDecorationsComponent = (class_9292)stack.method_57825(class_9334.field_49647, (Object)class_9292.field_49347);
        if (!this.decorations.keySet().containsAll(mapDecorationsComponent.comp_2404().keySet())) {
            mapDecorationsComponent.comp_2404().forEach((id, decoration) -> {
                if (!this.decorations.containsKey(id)) {
                    this.addDecoration((class_6880<class_9428>)decoration.comp_2405(), (class_1936)player.method_37908(), (String)id, decoration.comp_2406(), decoration.comp_2407(), decoration.comp_2408(), null);
                }
            });
        }
    }

    private void removeDecoration(String id) {
        class_20 mapDecoration = this.decorations.remove(id);
        if (mapDecoration != null && ((class_9428)mapDecoration.comp_1842().comp_349()).comp_2518()) {
            --this.decorationCount;
        }
        this.markDecorationsDirty();
    }

    private void addDecoration(class_6880<class_9428> type, @Nullable class_1936 world, String key, double x, double z, double rotation, @Nullable class_2561 text) {
        class_20 mapDecoration2;
        class_20 mapDecoration;
        byte d;
        int i = 1 << this.scale;
        float f = (float)(x - (double)this.centerX) / (float)i;
        float g = (float)(z - (double)this.centerZ) / (float)i;
        byte b = (byte)((double)(f * 2.0f) + 0.5);
        byte c = (byte)((double)(g * 2.0f) + 0.5);
        if (f >= -63.0f && g >= -63.0f && f <= 63.0f && g <= 63.0f) {
            d = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.dimension == class_1937.field_25180 && world != null) {
                int k = (int)(world.method_8401().method_217() / 10L);
                d = (byte)(k * k * 34187121 + k * 121 >> 15 & 0xF);
            }
        } else {
            if (!type.method_55838(class_21.field_91)) {
                this.removeDecoration(key);
                return;
            }
            if (Math.abs(f) < 320.0f && Math.abs(g) < 320.0f) {
                type = class_21.field_86;
            } else {
                if (!this.unlimitedTracking) {
                    this.removeDecoration(key);
                    return;
                }
                type = class_21.field_87;
            }
            d = 0;
            if (f <= -63.0f) {
                b = -128;
            }
            if (g <= -63.0f) {
                c = -128;
            }
            if (f >= 63.0f) {
                b = 127;
            }
            if (g >= 63.0f) {
                c = 127;
            }
        }
        if (!(mapDecoration = new class_20(type, b, c, d, Optional.ofNullable(text))).equals((Object)(mapDecoration2 = this.decorations.put(key, mapDecoration)))) {
            if (mapDecoration2 != null && ((class_9428)mapDecoration2.comp_1842().comp_349()).comp_2518()) {
                --this.decorationCount;
            }
            if (((class_9428)type.comp_349()).comp_2518()) {
                ++this.decorationCount;
            }
            this.markDecorationsDirty();
        }
    }

    @Nullable
    public MapUpdatePacket getPlayerMarkerPacket(class_9209 mapId, class_1657 player) {
        PlayerUpdateTracker playerUpdateTracker = this.updateTrackersByPlayer.get(player);
        return playerUpdateTracker == null ? null : playerUpdateTracker.getPacket(mapId);
    }

    private void markDirty(int x, int z) {
        this.method_80();
        for (PlayerUpdateTracker playerUpdateTracker : this.updateTrackers) {
            playerUpdateTracker.markDirty(x, z);
        }
    }

    private void markDecorationsDirty() {
        this.method_80();
        this.updateTrackers.forEach(PlayerUpdateTracker::markDecorationsDirty);
    }

    public PlayerUpdateTracker getPlayerSyncData(class_1657 player) {
        PlayerUpdateTracker playerUpdateTracker = this.updateTrackersByPlayer.get(player);
        if (playerUpdateTracker == null) {
            playerUpdateTracker = new PlayerUpdateTracker(player);
            this.updateTrackersByPlayer.put(player, playerUpdateTracker);
            this.updateTrackers.add(playerUpdateTracker);
        }
        return playerUpdateTracker;
    }

    public boolean addBanner(class_1936 world, class_2338 pos) {
        double d = (double)pos.method_10263() + 0.5;
        double e = (double)pos.method_10260() + 0.5;
        int i = 1 << this.scale;
        double f = (d - (double)this.centerX) / (double)i;
        double g = (e - (double)this.centerZ) / (double)i;
        if (f >= -63.0 && g >= -63.0 && f <= 63.0 && g <= 63.0) {
            class_17 mapBannerMarker = class_17.method_73((class_1922)world, (class_2338)pos);
            if (mapBannerMarker == null) {
                return false;
            }
            if (this.trackedBanners.remove(mapBannerMarker.method_71(), mapBannerMarker)) {
                this.removeDecoration(mapBannerMarker.method_71());
                return true;
            }
            if (!this.decorationCountNotLessThan(256)) {
                this.trackedBanners.put(mapBannerMarker.method_71(), mapBannerMarker);
                this.addDecoration((class_6880<class_9428>)mapBannerMarker.method_72(), world, mapBannerMarker.method_71(), d, e, 180.0, mapBannerMarker.comp_2314().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void removeBanner(class_1922 world, int x, int z) {
        Iterator<class_17> iterator = this.trackedBanners.values().iterator();
        while (iterator.hasNext()) {
            class_17 mapBannerMarker2;
            class_17 mapBannerMarker = iterator.next();
            if (mapBannerMarker.comp_2312().method_10263() != x || mapBannerMarker.comp_2312().method_10260() != z || mapBannerMarker.equals((Object)(mapBannerMarker2 = class_17.method_73((class_1922)world, (class_2338)mapBannerMarker.comp_2312())))) continue;
            iterator.remove();
            this.removeDecoration(mapBannerMarker.method_71());
        }
    }

    public void removeFrame(class_2338 pos, int id) {
        this.removeDecoration(RemappedState.getFrameDecorationKey(id));
        this.trackedFrames.remove(class_19.method_81((class_2338)pos));
    }

    public boolean putPixel(int x, int z, class_6880<RemappedColor> entry, int brightness) {
        int color = RemappedState.applyBrightness(((RemappedColor)entry.comp_349()).color(), brightness);
        int index = x + z * 128;
        if (this.colors.get(index) != color) {
            this.setPixel(x, z, color);
            return true;
        }
        return false;
    }

    public void setPixel(int x, int z, int color) {
        this.colors.set(x + z * 128, color);
        this.markDirty(x, z);
    }

    private static int applyBrightness(int color, int brightness) {
        int i = switch (brightness) {
            case 0 -> 180;
            case 1 -> 220;
            case 2 -> 255;
            case 3 -> 135;
            default -> 0;
        };
        int j = (color >> 16 & 0xFF) * i / 255;
        int k = (color >> 8 & 0xFF) * i / 255;
        int l = (color & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public boolean hasExplorationMapDecoration() {
        class_20 mapDecoration;
        Iterator<class_20> var1 = this.decorations.values().iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!((class_9428)(mapDecoration = var1.next()).comp_1842().comp_349()).comp_2517());
        return true;
    }

    public void replaceDecorations(List<class_20> decorations) {
        this.decorations.clear();
        this.decorationCount = 0;
        for (int i = 0; i < decorations.size(); ++i) {
            class_20 mapDecoration = decorations.get(i);
            this.decorations.put("icon-" + i, mapDecoration);
            if (!((class_9428)mapDecoration.comp_1842().comp_349()).comp_2518()) continue;
            ++this.decorationCount;
        }
    }

    public Iterable<class_20> getDecorations() {
        return this.decorations.values();
    }

    public boolean decorationCountNotLessThan(int decorationCount) {
        return this.decorationCount >= decorationCount;
    }

    private static String getFrameDecorationKey(int id) {
        return "frame-" + id;
    }

    public class PlayerUpdateTracker {
        public final class_1657 player;
        private boolean dirty = true;
        private int startX;
        private int startZ;
        private int endX = 127;
        private int endZ = 127;
        private boolean decorationsDirty = true;
        private int emptyPacketsRequested;
        public int tick;

        PlayerUpdateTracker(class_1657 player) {
            this.player = player;
        }

        private UpdateData getMapUpdateData() {
            int i = this.startX;
            int j = this.startZ;
            int k = this.endX + 1 - this.startX;
            int l = this.endZ + 1 - this.startZ;
            List<Integer> colors = PlayerUpdateTracker.fillList(k, l);
            for (int m = 0; m < k; ++m) {
                for (int n = 0; n < l; ++n) {
                    int index = i + m + (j + n) * 128;
                    colors.set(m + n * k, RemappedState.this.colors.get(index));
                }
            }
            return new UpdateData(i, j, k, l, colors);
        }

        private static List<Integer> fillList(int x, int y) {
            Object[] pixels = new Integer[x * y];
            Arrays.fill(pixels, (Object)0);
            return Arrays.asList(pixels);
        }

        @Nullable
        MapUpdatePacket getPacket(class_9209 mapId) {
            Collection<class_20> collection;
            UpdateData updateData;
            if (this.dirty) {
                this.dirty = false;
                updateData = this.getMapUpdateData();
            } else {
                updateData = null;
            }
            if (this.decorationsDirty && this.emptyPacketsRequested++ % 5 == 0) {
                this.decorationsDirty = false;
                collection = RemappedState.this.decorations.values();
            } else {
                collection = null;
            }
            return collection == null && updateData == null ? null : new MapUpdatePacket(mapId, RemappedState.this.scale, RemappedState.this.locked, collection, updateData);
        }

        void markDirty(int startX, int startZ) {
            if (this.dirty) {
                this.startX = Math.min(this.startX, startX);
                this.startZ = Math.min(this.startZ, startZ);
                this.endX = Math.max(this.endX, startX);
                this.endZ = Math.max(this.endZ, startZ);
            } else {
                this.dirty = true;
                this.startX = startX;
                this.startZ = startZ;
                this.endX = startX;
                this.endZ = startZ;
            }
        }

        private void markDecorationsDirty() {
            this.decorationsDirty = true;
        }
    }

    public record UpdateData(int startX, int startZ, int width, int height, List<Integer> colors) {
        private static final class_9139<class_9129, UpdateData> CODEC = class_9139.method_56906((class_9139)class_9135.field_48550, UpdateData::startX, (class_9139)class_9135.field_48550, UpdateData::startZ, (class_9139)class_9135.field_48550, UpdateData::width, (class_9139)class_9135.field_48550, UpdateData::height, (class_9139)class_9135.field_48550.method_56433(class_9135.method_56363()), UpdateData::colors, UpdateData::new);
        public static final class_9139<class_9129, Optional<UpdateData>> OPTIONAL_CODEC = new class_9139<class_9129, Optional<UpdateData>>(){

            public Optional<UpdateData> decode(class_9129 buf) {
                boolean bl = buf.readBoolean();
                return bl ? Optional.of((UpdateData)CODEC.decode((Object)buf)) : Optional.empty();
            }

            public void encode(class_9129 buf, Optional<UpdateData> value) {
                buf.method_52964(value.isPresent());
                value.ifPresent(updateData -> CODEC.encode((Object)buf, updateData));
            }
        };

        public void setColorsTo(RemappedState state) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    state.setPixel(this.startX + i, this.startZ + j, this.colors.get(i + j * this.width));
                }
            }
        }
    }
}

