/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.map;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import dev.worldgen.remapped.Remapped;
import dev.worldgen.remapped.color.RemappedColor;
import dev.worldgen.remapped.map.RemappedState;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class RemappedUtils {
    public static final class_6862<RemappedColor> FALLBACK = class_6862.method_40092(RemappedColor.REGISTRY_KEY, (class_2960)class_2960.method_60655((String)"remapped", (String)"fallback"));
    public static final class_5321<RemappedColor> EMPTY = RemappedUtils.of("empty");
    private static final class_5321<RemappedColor> DIRT_BROWN = RemappedUtils.of("dirt_brown");
    private static final class_5321<RemappedColor> STONE_GRAY = RemappedUtils.of("stone_gray");
    private static final class_5321<RemappedColor> ORANGE = RemappedUtils.of("orange");
    private static final class_5321<RemappedColor> BROWN = RemappedUtils.of("brown");

    private static class_5321<RemappedColor> of(String name) {
        return class_5321.method_29179(RemappedColor.REGISTRY_KEY, (class_2960)class_2960.method_60655((String)"remapped", (String)name));
    }

    @Nullable
    public static RemappedState getState(@Nullable class_9209 id, class_1937 world) {
        if (Remapped.disabled()) {
            return null;
        }
        return id == null ? null : world.remapped$getState(id);
    }

    @Nullable
    public static RemappedState getState(class_1799 map, class_1937 world) {
        class_9209 id = (class_9209)map.method_57824(class_9334.field_49646);
        return RemappedUtils.getState(id, world);
    }

    public static void updateColors(class_3218 world, class_1297 entity, RemappedState state) {
        if (world.method_27983() == state.dimension() && entity instanceof class_1657) {
            class_2378 registry = world.method_30349().method_30530(RemappedColor.REGISTRY_KEY);
            int squaredScale = 1 << state.scale();
            int centerX = state.centerX();
            int centerZ = state.centerZ();
            int l = class_3532.method_15357((double)(entity.method_23317() - (double)centerX)) / squaredScale + 64;
            int m = class_3532.method_15357((double)(entity.method_23321() - (double)centerZ)) / squaredScale + 64;
            int n = 128 / squaredScale;
            if (world.method_8597().comp_643()) {
                n /= 2;
            }
            RemappedState.PlayerUpdateTracker playerUpdateTracker = state.getPlayerSyncData((class_1657)entity);
            ++playerUpdateTracker.tick;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            class_2338.class_2339 mutable2 = new class_2338.class_2339();
            boolean bl = false;
            for (int o = l - n + 1; o < l + n; ++o) {
                if ((o & 0xF) != (playerUpdateTracker.tick & 0xF) && !bl) continue;
                bl = false;
                double d = 0.0;
                for (int p = m - n - 1; p < m + n; ++p) {
                    double f;
                    if (o < 0 || p < -1 || o >= 128 || p >= 128) continue;
                    int q = class_3532.method_34954((int)(o - l)) + class_3532.method_34954((int)(p - m));
                    boolean bl2 = q > (n - 2) * (n - 2);
                    int r = (centerX / squaredScale + o - 64) * squaredScale;
                    int s = (centerZ / squaredScale + p - 64) * squaredScale;
                    LinkedHashMultiset colorsForPixel = LinkedHashMultiset.create();
                    class_2818 worldChunk = world.method_8497(class_4076.method_18675((int)r), class_4076.method_18675((int)s));
                    if (worldChunk.method_12223()) continue;
                    int t = 0;
                    double e = 0.0;
                    if (world.method_8597().comp_643()) {
                        u = r + s * 231871;
                        if (((u = u * u * 31287121 + u * 11) >> 20 & 1) == 0) {
                            colorsForPixel.add(RemappedUtils.get((class_2378<RemappedColor>)registry, DIRT_BROWN), 10);
                        } else {
                            colorsForPixel.add(RemappedUtils.get((class_2378<RemappedColor>)registry, STONE_GRAY), 100);
                        }
                        e = 100.0;
                    } else {
                        for (u = 0; u < squaredScale; ++u) {
                            for (int v = 0; v < squaredScale; ++v) {
                                class_2680 blockState;
                                mutable.method_10103(r + u, 0, s + v);
                                int w = worldChunk.method_12005(class_2902.class_2903.field_13202, mutable.method_10263(), mutable.method_10260()) + 1;
                                if (w <= world.method_31607() + 1) {
                                    blockState = class_2246.field_9987.method_9564();
                                } else {
                                    do {
                                        mutable.method_33098(--w);
                                        blockState = worldChunk.method_8320((class_2338)mutable);
                                    } while (RemappedUtils.getMatchingColor((class_2378<RemappedColor>)registry, (class_6880<class_1959>)world.method_23753((class_2338)mutable), blockState) == RemappedUtils.get((class_2378<RemappedColor>)registry, EMPTY) && w > world.method_31607());
                                    if (w > world.method_31607() && !blockState.method_26227().method_15769()) {
                                        class_2680 blockState2;
                                        int x = w - 1;
                                        mutable2.method_10101((class_2382)mutable);
                                        do {
                                            mutable2.method_33098(x--);
                                            blockState2 = worldChunk.method_8320((class_2338)mutable2);
                                            ++t;
                                        } while (x > world.method_31607() && !blockState2.method_26227().method_15769());
                                        blockState = RemappedUtils.getFluidStateIfVisible((class_1937)world, blockState, (class_2338)mutable);
                                    }
                                }
                                state.removeBanner((class_1922)world, mutable.method_10263(), mutable.method_10260());
                                e += (double)w / (double)(squaredScale * squaredScale);
                                colorsForPixel.add(RemappedUtils.getMatchingColor((class_2378<RemappedColor>)registry, (class_6880<class_1959>)world.method_23753((class_2338)mutable), blockState));
                            }
                        }
                    }
                    class_6880 color = (class_6880)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)colorsForPixel), RemappedUtils.get((class_2378<RemappedColor>)registry, EMPTY));
                    class_3620.class_6594 brightness = ((RemappedColor)color.comp_349()).useDithering() ? ((f = (double)(t /= squaredScale * squaredScale) * 0.1 + (double)(o + p & 1) * 0.2) < 0.5 ? class_3620.class_6594.field_34761 : (f > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((f = (e - d) * 4.0 / (double)(squaredScale + 4) + ((double)(o + p & 1) - 0.5) * 0.4) > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
                    d = e;
                    if (p < 0 || q >= n * n || bl2 && (o + p & 1) == 0) continue;
                    bl |= state.putPixel(o, p, (class_6880<RemappedColor>)color, brightness.field_34763);
                }
            }
        }
    }

    private static boolean isAquaticBiome(boolean[] biomes, int x, int z) {
        return biomes[z * 128 + x];
    }

    public static void fillExplorationMap(class_3218 world, class_1799 map) {
        RemappedState state = RemappedUtils.getState(map, (class_1937)world);
        if (state != null && world.method_27983() == state.dimension()) {
            int o;
            int n;
            class_2378 registry = world.method_30349().method_30530(RemappedColor.REGISTRY_KEY);
            int i = 1 << state.scale();
            int j = state.centerX();
            int k = state.centerZ();
            boolean[] bls = new boolean[16384];
            int l = j / i - 64;
            int m = k / i - 64;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (n = 0; n < 128; ++n) {
                for (o = 0; o < 128; ++o) {
                    class_6880 registryEntry = world.method_23753((class_2338)mutable.method_10103((l + o) * i, 0, (m + n) * i));
                    bls[n * 128 + o] = registryEntry.method_40220(class_6908.field_37379);
                }
            }
            for (n = 1; n < 127; ++n) {
                for (o = 1; o < 127; ++o) {
                    int p = 0;
                    for (int q = -1; q < 2; ++q) {
                        for (int r = -1; r < 2; ++r) {
                            if (q == 0 && r == 0 || !RemappedUtils.isAquaticBiome(bls, n + q, o + r)) continue;
                            ++p;
                        }
                    }
                    class_3620.class_6594 brightness = class_3620.class_6594.field_34762;
                    class_5321<RemappedColor> color = EMPTY;
                    if (RemappedUtils.isAquaticBiome(bls, n, o)) {
                        color = ORANGE;
                        if (p > 7 && o % 2 == 0) {
                            brightness = switch ((n + (int)(class_3532.method_15374((float)((float)o + 0.0f)) * 7.0f)) / 8 % 5) {
                                case 0, 4 -> class_3620.class_6594.field_34759;
                                case 1, 3 -> class_3620.class_6594.field_34760;
                                case 2 -> class_3620.class_6594.field_34761;
                                default -> brightness;
                            };
                        } else if (p > 7) {
                            color = EMPTY;
                        } else if (p > 5) {
                            brightness = class_3620.class_6594.field_34760;
                        } else if (p > 3) {
                            brightness = class_3620.class_6594.field_34759;
                        } else if (p > 1) {
                            brightness = class_3620.class_6594.field_34759;
                        }
                    } else if (p > 0) {
                        color = BROWN;
                        if (p > 3) {
                            brightness = class_3620.class_6594.field_34760;
                        }
                    }
                    if (color == EMPTY) continue;
                    state.putPixel(n, o, (class_6880<RemappedColor>)((class_6880)registry.method_46746(color).get()), brightness.field_34763);
                }
            }
        }
    }

    private static class_6880<RemappedColor> get(class_2378<RemappedColor> registry, class_5321<RemappedColor> key) {
        return (class_6880)registry.method_46746(key).get();
    }

    private static class_6880<RemappedColor> getMatchingColor(class_2378<RemappedColor> registry, class_6880<class_1959> biome, class_2680 state) {
        for (class_6880 entry : registry.method_40295()) {
            if (entry.method_40220(FALLBACK) || !RemappedUtils.colorMatched((class_6880<RemappedColor>)entry, biome, state)) continue;
            return entry;
        }
        for (class_6880 entry : registry.method_40286(FALLBACK)) {
            if (!RemappedUtils.colorMatched((class_6880<RemappedColor>)entry, biome, state)) continue;
            return entry;
        }
        return RemappedUtils.get(registry, EMPTY);
    }

    private static boolean colorMatched(class_6880<RemappedColor> entry, class_6880<class_1959> biome, class_2680 state) {
        RemappedColor color = (RemappedColor)entry.comp_349();
        boolean blockMatch = state.method_40143(color.blocks());
        boolean biomeMatch = color.biomes().method_40247() == 0 || color.biomes().method_40241(biome);
        return blockMatch && biomeMatch;
    }

    private static class_2680 getFluidStateIfVisible(class_1937 world, class_2680 state, class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        return !fluidState.method_15769() && !state.method_26206((class_1922)world, pos, class_2350.field_11036) ? fluidState.method_15759() : state;
    }

    public static boolean canZoom(class_1799 first, class_1799 second, class_1937 world) {
        RemappedState state = RemappedUtils.getState(first, world);
        if (state != null && (second.method_31574(class_1802.field_8895) || second.method_31574(Remapped.EMPTY_MAP_ITEM))) {
            boolean secondTracks;
            boolean firstTracks = state.showDecorations();
            return firstTracks == (secondTracks = second.method_31574(class_1802.field_8895));
        }
        return false;
    }
}

