/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.mixin;

import dev.worldgen.remapped.Remapped;
import dev.worldgen.remapped.map.RemappedState;
import dev.worldgen.remapped.map.RemappedUtils;
import dev.worldgen.remapped.mixin.TooltipContextAccessor;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_9209;
import net.minecraft.class_9295;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1806.class})
public class FilledMapItemMixin {
    @Inject(method={"getMapState(Lnet/minecraft/component/type/MapIdComponent;Lnet/minecraft/world/World;)Lnet/minecraft/item/map/MapState;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void remapped$neverGetMapState(class_9209 id, class_1937 world, CallbackInfoReturnable<class_22> cir) {
        if (Remapped.disabled()) {
            return;
        }
        cir.setReturnValue(null);
    }

    @Inject(method={"allocateMapId"}, at={@At(value="HEAD")}, cancellable=true)
    private static void remapped$reallocateMapId(class_1937 world, int x, int z, int scale, boolean showIcons, boolean unlimitedTracking, class_5321<class_1937> dimension, CallbackInfoReturnable<class_9209> cir) {
        if (Remapped.disabled()) {
            return;
        }
        RemappedState state = RemappedState.of(x, z, (byte)scale, showIcons, unlimitedTracking, dimension, true);
        class_9209 mapIdComponent = world.method_17889();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_8503().method_30002().method_17983().method_123(mapIdComponent.method_56814(), (class_18)state);
        }
        cir.setReturnValue((Object)mapIdComponent);
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    private void remapped$updateRemappedColors(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected, CallbackInfo ci) {
        RemappedState state;
        if (!world.field_9236 && (state = RemappedUtils.getState(stack, world)) != null) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                state.update(player, stack);
            }
            if (!state.locked() && (selected || entity instanceof class_1657 && ((class_1657)entity).method_6079() == stack)) {
                RemappedUtils.updateColors((class_3218)world, entity, state);
            }
        }
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void remapped$fixAdvancedTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type, CallbackInfo ci) {
        class_9209 id;
        if (Remapped.disabled()) {
            return;
        }
        class_1937 world = null;
        try {
            world = ((TooltipContextAccessor)context).world();
        }
        catch (Exception e) {
            ci.cancel();
        }
        if (world == null) {
            ci.cancel();
        }
        RemappedState state = (id = (class_9209)stack.method_57824(class_9334.field_49646)) != null ? world.remapped$getState(id) : null;
        class_9295 processing = (class_9295)stack.method_57824(class_9334.field_49648);
        if (state != null && (state.locked() || processing == class_9295.field_49353)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.locked", (Object[])new Object[]{id.comp_2315()}).method_27692(class_124.field_1080));
        }
        if (type.method_8035()) {
            if (state != null) {
                if (processing == null) {
                    tooltip.add(class_1806.method_53836((class_9209)id));
                }
                byte i = processing == class_9295.field_49354 ? (byte)1 : 0;
                int j = Math.min(state.scale() + i, 4);
                tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.scale", (Object[])new Object[]{1 << j}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.level", (Object[])new Object[]{j, 4}).method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"filled_map.unknown").method_27692(class_124.field_1080));
            }
        }
        ci.cancel();
    }

    @Inject(method={"fillExplorationMap"}, at={@At(value="HEAD")}, cancellable=true)
    private static void remapped$fixExplorationMap(class_3218 world, class_1799 map, CallbackInfo ci) {
        if (Remapped.disabled()) {
            return;
        }
        RemappedUtils.fillExplorationMap(world, map);
        ci.cancel();
    }

    @Inject(method={"scale"}, at={@At(value="HEAD")}, cancellable=true)
    private static void remapped$fixScaling(class_1799 stack, class_1937 world, CallbackInfo ci) {
        if (Remapped.disabled()) {
            return;
        }
        RemappedState state = RemappedUtils.getState(stack, world);
        if (state != null) {
            class_9209 id = world.method_17889();
            world.remapped$setState(id, state.zoomOut(stack.method_57824(Remapped.SCALE_FROM_CENTER) != null));
            stack.method_57379(class_9334.field_49646, (Object)id);
        }
        ci.cancel();
    }

    @Inject(method={"copyMap"}, at={@At(value="HEAD")}, cancellable=true)
    private static void remapped$fixCopying(class_1937 world, class_1799 stack, CallbackInfo ci) {
        if (Remapped.disabled()) {
            return;
        }
        RemappedState state = RemappedUtils.getState(stack, world);
        if (state != null) {
            class_9209 id = world.method_17889();
            world.remapped$setState(id, state.copy());
            stack.method_57379(class_9334.field_49646, (Object)id);
        }
        ci.cancel();
    }

    @Inject(method={"useOnBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/FilledMapItem;getMapState(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;)Lnet/minecraft/item/map/MapState;")}, cancellable=true)
    private void remapped$fixBannerMarkers(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        RemappedState state = RemappedUtils.getState(context.method_8041(), context.method_8045());
        if (state != null && !state.addBanner((class_1936)context.method_8045(), context.method_8037())) {
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }
}

