/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.render;

import dev.worldgen.remapped.map.RemappedState;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_9209;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class RemappedMapTextureManager
implements AutoCloseable {
    private final Int2ObjectMap<MapTexture> texturesByMapId = new Int2ObjectOpenHashMap();
    final class_1060 textureManager;

    public RemappedMapTextureManager(class_1060 textureManager) {
        this.textureManager = textureManager;
    }

    public void setNeedsUpdate(class_9209 mapIdComponent, RemappedState mapState) {
        this.getMapTexture(mapIdComponent, mapState).setNeedsUpdate();
    }

    public class_2960 getTextureId(class_9209 mapIdComponent, RemappedState mapState) {
        MapTexture mapTexture = this.getMapTexture(mapIdComponent, mapState);
        mapTexture.updateTexture();
        return mapTexture.textureId;
    }

    public void clear() {
        for (MapTexture mapTexture : this.texturesByMapId.values()) {
            mapTexture.close();
        }
        this.texturesByMapId.clear();
    }

    private MapTexture getMapTexture(class_9209 mapIdComponent, RemappedState MapState) {
        return (MapTexture)this.texturesByMapId.compute(mapIdComponent.comp_2315(), (id, mapTexture) -> {
            if (mapTexture == null) {
                return new MapTexture(this, this, (int)id, MapState);
            }
            mapTexture.setState(MapState);
            return mapTexture;
        });
    }

    @Override
    public void close() {
        this.clear();
    }

    @Environment(value=EnvType.CLIENT)
    class MapTexture
    implements AutoCloseable {
        private RemappedState state;
        private final class_1043 texture;
        private boolean needsUpdate = true;
        final class_2960 textureId;

        MapTexture(RemappedMapTextureManager this$0, RemappedMapTextureManager mapTextureManager, int id, RemappedState state) {
            this.state = state;
            this.texture = new class_1043(128, 128, true);
            this.textureId = mapTextureManager.textureManager.method_4617("map/" + id, this.texture);
        }

        void setState(RemappedState state) {
            boolean bl = this.state != state;
            this.state = state;
            this.needsUpdate |= bl;
        }

        public void setNeedsUpdate() {
            this.needsUpdate = true;
        }

        void updateTexture() {
            if (this.needsUpdate) {
                class_1011 nativeImage = this.texture.method_4525();
                if (nativeImage != null) {
                    for (int i = 0; i < 128; ++i) {
                        for (int j = 0; j < 128; ++j) {
                            int k = j + i * 128;
                            nativeImage.method_61941(j, i, class_9848.method_61337((int)this.state.getPixelColor(k)));
                        }
                    }
                }
                this.texture.method_4524();
                this.needsUpdate = false;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

