/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.zam.castingcaving.client.entity.skins.FrogSkins;
import net.zam.castingcaving.client.entity.skins.WolfSkins;
import net.zam.castingcaving.client.item.renderer.SculkBombRenderer;
import net.zam.castingcaving.registry.ZAMBlocks;
import net.zam.castingcaving.registry.ZAMCreativeModeTab;
import net.zam.castingcaving.registry.ZAMEffects;
import net.zam.castingcaving.registry.ZAMEntities;
import net.zam.castingcaving.registry.ZAMItems;
import org.slf4j.Logger;

@Mod(value="castingcaving")
public class CastingCaving {
    public static final String MOD_ID = "castingcaving";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<FrogVariant> FROG_VARIANTS = DeferredRegister.create((ResourceKey)BuiltInRegistries.FROG_VARIANT.key(), (String)"castingcaving");
    public static final Holder<FrogVariant> ANCIENT_FROG = FROG_VARIANTS.register("ancient_frog", () -> new FrogVariant(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"textures/entity/frog/ancient_frog.png")));

    public CastingCaving(IEventBus modEventBus) {
        ZAMItems.register(modEventBus);
        ZAMBlocks.register(modEventBus);
        ZAMEffects.register(modEventBus);
        ZAMCreativeModeTab.register(modEventBus);
        ZAMEntities.register(modEventBus);
        FROG_VARIANTS.register(modEventBus);
    }

    @EventBusSubscriber(modid="castingcaving", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ZAMEntities.SCULK_BOMB_ENTITY.get(), SculkBombRenderer::new);
            EntityRenderers.register((EntityType)EntityType.WOLF, WolfSkins::new);
            EntityRenderers.register((EntityType)EntityType.FROG, FrogSkins::new);
        }
    }
}

