/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.client.item;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SculkBombEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(SculkBombEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private boolean landed = false;
    private int timer = 0;
    private int groundY = Integer.MAX_VALUE;
    private boolean hasPlayedRisingSound = false;
    private boolean hasReachedTargetHeight = false;

    public SculkBombEntity(EntityType<? extends SculkBombEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SculkBombEntity(EntityType<? extends SculkBombEntity> entityType, Level level, LivingEntity thrower) {
        super(entityType, thrower, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    public void tick() {
        super.tick();
        if (!this.hasReachedTargetHeight) {
            this.level().addParticle((ParticleOptions)new SculkChargeParticleOptions(0.5f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        if (this.landed) {
            this.setDeltaMovement(Vec3.ZERO);
            ++this.timer;
            if (this.timer > 5 && this.timer < 35) {
                double targetHeight = this.groundY + 4;
                if (this.getY() < targetHeight) {
                    this.setPos(this.getX(), this.getY() + 0.15, this.getZ());
                    if (!this.hasPlayedRisingSound) {
                        this.level().playSound(null, this.blockPosition(), SoundEvents.WARDEN_SONIC_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.hasPlayedRisingSound = true;
                    }
                } else {
                    this.hasReachedTargetHeight = true;
                }
                this.pullEntitiesIn();
            }
            if (this.timer >= 35 && this.timer < 55) {
                this.pullEntitiesToCenter();
            }
            if (this.timer == 45) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.timer == 55) {
                this.explode();
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.landed) {
            this.landed = true;
            this.groundY = (int)this.getY();
            this.setPos(this.getX(), this.getY() + 1.0, this.getZ());
        }
    }

    private void pullEntitiesIn() {
        AABB area = new AABB(this.blockPosition()).inflate(5.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            if (entity == this.getOwner()) continue;
            double dx = this.getX() - entity.getX();
            double dy = this.getY() - entity.getY();
            double dz = this.getZ() - entity.getZ();
            Vec3 pull = new Vec3(dx, dy, dz).normalize().scale(0.15);
            entity.setDeltaMovement(entity.getDeltaMovement().add(pull));
            entity.hurtMarked = true;
        }
    }

    private void pullEntitiesToCenter() {
        AABB area = new AABB(this.blockPosition()).inflate(5.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            double dx = this.getX() - entity.getX();
            double dy = this.getY() - entity.getY();
            double dz = this.getZ() - entity.getZ();
            Vec3 finalPull = new Vec3(dx, dy, dz).normalize().scale(0.3);
            entity.setDeltaMovement(finalPull);
            entity.hurtMarked = true;
        }
    }

    private void explode() {
        AABB explosionArea = new AABB(this.blockPosition()).inflate(3.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, explosionArea);
        for (LivingEntity entity : entities) {
            entity.hurt(this.damageSources().explosion((Entity)this, this.getOwner()), 10.0f);
            Vec3 knockback = new Vec3(entity.getX() - this.getX(), entity.getY() - this.getY(), entity.getZ() - this.getZ()).normalize().scale(1.5);
            entity.setDeltaMovement(knockback);
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public void setItem(ItemStack stack) {
        this.entityData.set(DATA_ITEM_STACK, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(DATA_ITEM_STACK);
    }
}

