/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.common.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class OpalWandItem
extends Item {
    public OpalWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        WeatheringCopper weatheringBlock;
        Optional nextState;
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        Block block = blockState.getBlock();
        if (block instanceof WeatheringCopper && (nextState = (weatheringBlock = (WeatheringCopper)block).getNext(blockState)).isPresent() && level instanceof ServerLevel) {
            level.setBlock(blockPos, (BlockState)nextState.get(), 11);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, (double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, 10, 0.3, 0.3, 0.3, 0.05);
            if (context.getPlayer() != null) {
                this.playSound(context.getPlayer());
                context.getPlayer().swing(context.getHand());
            }
            ItemStack itemStack = context.getItemInHand();
            itemStack.hurtAndBreak(1, (LivingEntity)context.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    private void playSound(Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.AXE_SCRAPE, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

