/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.zam.castingcaving.data.ZAMBiomeTagsProvider;
import net.zam.castingcaving.data.ZAMBlockStateProvider;
import net.zam.castingcaving.data.ZAMBlockTableProvider;
import net.zam.castingcaving.data.ZAMBlockTagProvider;
import net.zam.castingcaving.data.ZAMItemModelProvider;
import net.zam.castingcaving.data.ZAMItemTagProvider;
import net.zam.castingcaving.data.ZAMRecipeProvider;
import net.zam.castingcaving.data.ZAMWorldGenProvider;

@EventBusSubscriber(modid="castingcaving", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ZAMRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ZAMBlockTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        ZAMBlockTagProvider blockTagsProvider = new ZAMBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ZAMItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ZAMItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ZAMBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ZAMBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ZAMWorldGenProvider(packOutput, lookupProvider));
    }
}

