/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.data;

import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.zam.castingcaving.registry.ZAMBlocks;
import net.zam.castingcaving.registry.ZAMItems;

public class ZAMBlockTableProvider
extends BlockLootSubProvider {
    protected ZAMBlockTableProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf((Block)ZAMBlocks.GLOW_INK_BLOCK.get());
        this.dropSelf((Block)ZAMBlocks.ECHO_FROGLIGHT.get());
        this.dropSelf((Block)ZAMBlocks.AQUAMARINE_BLOCK.get());
        this.add((Block)ZAMBlocks.AQUAMARINE_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.AQUAMARINE_ORE.get(), (Item)ZAMItems.AQUAMARINE.get(), 1.0f, 4.0f));
        this.add((Block)ZAMBlocks.DEEPSLATE_AQUAMARINE_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.DEEPSLATE_AQUAMARINE_ORE.get(), (Item)ZAMItems.AQUAMARINE.get(), 1.0f, 4.0f));
        this.dropSelf((Block)ZAMBlocks.OPAL_BLOCK.get());
        this.dropSelf((Block)ZAMBlocks.PERIDOT_BLOCK.get());
        this.add((Block)ZAMBlocks.OPAL_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.OPAL_ORE.get(), (Item)ZAMItems.OPAL.get(), 1.0f, 4.0f));
        this.add((Block)ZAMBlocks.DEEPSLATE_OPAL_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.DEEPSLATE_OPAL_ORE.get(), (Item)ZAMItems.OPAL.get(), 1.0f, 4.0f));
        this.add((Block)ZAMBlocks.PERIDOT_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.PERIDOT_ORE.get(), (Item)ZAMItems.PERIDOT.get(), 1.0f, 4.0f));
        this.add((Block)ZAMBlocks.DEEPSLATE_PERIDOT_ORE.get(), block -> this.createMultipleOreDrops((Block)ZAMBlocks.DEEPSLATE_PERIDOT_ORE.get(), (Item)ZAMItems.PERIDOT.get(), 1.0f, 4.0f));
        this.dropSelf((Block)ZAMBlocks.EMERALD_CRYSTAL_BLOCK.get());
        this.add((Block)ZAMBlocks.BUDDING_EMERALD.get(), ZAMBlockTableProvider.noDrop());
        this.add((Block)ZAMBlocks.EMERALD_CLUSTER.get(), block -> this.dropAlternativeWithSilkTouch((Block)block, (Block)ZAMBlocks.EMERALD_CLUSTER.get(), (LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ZAMItems.EMERALD_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)ZAMItems.EMERALD_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.add((Block)ZAMBlocks.LARGE_EMERALD_BUD.get(), this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.LARGE_EMERALD_BUD));
        this.add((Block)ZAMBlocks.MEDIUM_EMERALD_BUD.get(), this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.MEDIUM_EMERALD_BUD));
        this.add((Block)ZAMBlocks.SMALL_EMERALD_BUD.get(), this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.SMALL_EMERALD_BUD));
        this.dropSelf((Block)ZAMBlocks.AQUAMARINE_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.OPAL_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.PERIDOT_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.CHISELED_AQUAMARINE_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.CHISELED_OPAL_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.CHISELED_PERIDOT_BRICKS.get());
        this.dropSelf((Block)ZAMBlocks.AQUAMARINE_BRICK_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.OPAL_BRICK_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.PERIDOT_BRICK_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.AQUAMARINE_BRICK_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.OPAL_BRICK_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.PERIDOT_BRICK_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.AQUAMARINE_BRICK_WALL.get());
        this.dropSelf((Block)ZAMBlocks.OPAL_BRICK_WALL.get());
        this.dropSelf((Block)ZAMBlocks.PERIDOT_BRICK_WALL.get());
        this.dropSelf((Block)ZAMBlocks.WHITE_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.LIGHT_BLUE_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.GRAY_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.BLACK_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.BROWN_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.RED_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.ORANGE_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.YELLOW_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.LIME_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.GREEN_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.CYAN_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.LIGHT_GRAY_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.BLUE_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.PURPLE_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.MAGENTA_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.PINK_CONCRETE_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.WHITE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.LIGHT_BLUE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.GRAY_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.BLACK_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.BROWN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.RED_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.ORANGE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.YELLOW_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.LIME_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.GREEN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.CYAN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.LIGHT_GRAY_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.BLUE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.PURPLE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.MAGENTA_CONCRETE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.PINK_CONCRETE_STAIRS.get());
        this.dropWhenSilkTouch((Block)ZAMBlocks.PACKED_ICE_SLAB.get());
        this.dropWhenSilkTouch((Block)ZAMBlocks.PACKED_ICE_STAIRS.get());
        this.dropSelf((Block)ZAMBlocks.SAND_SLAB.get());
        this.dropSelf((Block)ZAMBlocks.SAND_STAIRS.get());
        this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.LARGE_EMERALD_BUD.get());
        this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.MEDIUM_EMERALD_BUD.get());
        this.createSilkTouchOnlyTable((ItemLike)ZAMBlocks.SMALL_EMERALD_BUD.get());
    }

    protected LootTable.Builder dropAlternativeWithSilkTouch(Block block, Block alternative, LootPoolEntryContainer.Builder<?> builder) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)alternative).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties()))).otherwise(LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise(builder));
        return LootTable.lootTable().withPool(lootPool);
    }

    protected LootTable.Builder createMultipleOreDrops(Block pBlock, Item item, float minDrops, float maxDrops) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ZAMBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

