/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.registry;

import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.zam.castingcaving.common.block.BuddingEmeraldBlock;
import net.zam.castingcaving.registry.ZAMItems;

public class ZAMBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"castingcaving");
    public static final DeferredBlock<Block> EMERALD_CRYSTAL_BLOCK = ZAMBlocks.registerBlock("emerald_crystal_block", () -> new AmethystBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BUDDING_EMERALD = ZAMBlocks.registerBlock("budding_emerald", () -> new BuddingEmeraldBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).randomTicks().strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> EMERALD_CLUSTER = ZAMBlocks.registerBlock("emerald_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).forceSolidOn().noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(p_152680_ -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> LARGE_EMERALD_BUD = ZAMBlocks.registerBlock("large_emerald_bud", () -> new AmethystClusterBlock(5.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)EMERALD_CLUSTER.get())).sound(SoundType.MEDIUM_AMETHYST_BUD).forceSolidOn().lightLevel(p_50804_ -> 4).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> MEDIUM_EMERALD_BUD = ZAMBlocks.registerBlock("medium_emerald_bud", () -> new AmethystClusterBlock(4.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)EMERALD_CLUSTER.get())).sound(SoundType.LARGE_AMETHYST_BUD).forceSolidOn().lightLevel(p_152677_ -> 2).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SMALL_EMERALD_BUD = ZAMBlocks.registerBlock("small_emerald_bud", () -> new AmethystClusterBlock(3.0f, 4.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)EMERALD_CLUSTER.get())).sound(SoundType.SMALL_AMETHYST_BUD).forceSolidOn().lightLevel(p_187433_ -> 1).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AQUAMARINE_ORE = ZAMBlocks.registerBlock("aquamarine_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> DEEPSLATE_AQUAMARINE_ORE = ZAMBlocks.registerBlock("deepslate_aquamarine_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> AQUAMARINE_BLOCK = ZAMBlocks.registerBlock("aquamarine_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).requiresCorrectToolForDrops().strength(8.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> OPAL_ORE = ZAMBlocks.registerBlock("opal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> DEEPSLATE_OPAL_ORE = ZAMBlocks.registerBlock("deepslate_opal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> OPAL_BLOCK = ZAMBlocks.registerBlock("opal_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().strength(8.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PERIDOT_ORE = ZAMBlocks.registerBlock("peridot_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> DEEPSLATE_PERIDOT_ORE = ZAMBlocks.registerBlock("deepslate_peridot_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> PERIDOT_BLOCK = ZAMBlocks.registerBlock("peridot_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).requiresCorrectToolForDrops().strength(8.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> ECHO_FROGLIGHT = ZAMBlocks.registerBlock("echo_froglight", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OCHRE_FROGLIGHT).mapColor(MapColor.COLOR_BLUE).strength(0.3f).lightLevel(b -> 15).sound(SoundType.FROGLIGHT)));
    public static final DeferredBlock<Block> GLOW_INK_BLOCK = ZAMBlocks.registerBlock("glow_ink_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OCHRE_FROGLIGHT).mapColor(MapColor.COLOR_LIGHT_BLUE).strength(0.3f).lightLevel(b -> 15).sound(SoundType.FROGLIGHT)));
    public static final DeferredBlock<Block> AQUAMARINE_BRICKS = ZAMBlocks.registerBlock("aquamarine_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> OPAL_BRICKS = ZAMBlocks.registerBlock("opal_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> PERIDOT_BRICKS = ZAMBlocks.registerBlock("peridot_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> CHISELED_AQUAMARINE_BRICKS = ZAMBlocks.registerBlock("chiseled_aquamarine_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> CHISELED_OPAL_BRICKS = ZAMBlocks.registerBlock("chiseled_opal_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> CHISELED_PERIDOT_BRICKS = ZAMBlocks.registerBlock("chiseled_peridot_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> AQUAMARINE_BRICK_STAIRS = ZAMBlocks.registerBlock("aquamarine_brick_stairs", () -> new StairBlock(((Block)AQUAMARINE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)AQUAMARINE_BRICKS.get()))));
    public static final DeferredBlock<Block> OPAL_BRICK_STAIRS = ZAMBlocks.registerBlock("opal_brick_stairs", () -> new StairBlock(((Block)OPAL_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OPAL_BRICKS.get()))));
    public static final DeferredBlock<Block> PERIDOT_BRICK_STAIRS = ZAMBlocks.registerBlock("peridot_brick_stairs", () -> new StairBlock(((Block)PERIDOT_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)PERIDOT_BRICKS.get()))));
    public static final DeferredBlock<Block> AQUAMARINE_BRICK_SLAB = ZAMBlocks.registerBlock("aquamarine_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)AQUAMARINE_BRICKS.get()))));
    public static final DeferredBlock<Block> OPAL_BRICK_SLAB = ZAMBlocks.registerBlock("opal_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OPAL_BRICKS.get()))));
    public static final DeferredBlock<Block> PERIDOT_BRICK_SLAB = ZAMBlocks.registerBlock("peridot_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)PERIDOT_BRICKS.get()))));
    public static final DeferredBlock<Block> AQUAMARINE_BRICK_WALL = ZAMBlocks.registerBlock("aquamarine_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)AQUAMARINE_BRICKS.get()))));
    public static final DeferredBlock<Block> OPAL_BRICK_WALL = ZAMBlocks.registerBlock("opal_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OPAL_BRICKS.get()))));
    public static final DeferredBlock<Block> PERIDOT_BRICK_WALL = ZAMBlocks.registerBlock("peridot_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)PERIDOT_BRICKS.get()))));
    public static final DeferredBlock<Block> WHITE_CONCRETE_SLAB = ZAMBlocks.registerBlock("white_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE)));
    public static final DeferredBlock<Block> LIGHT_GRAY_CONCRETE_SLAB = ZAMBlocks.registerBlock("light_gray_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE)));
    public static final DeferredBlock<Block> GRAY_CONCRETE_SLAB = ZAMBlocks.registerBlock("gray_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE)));
    public static final DeferredBlock<Block> BLACK_CONCRETE_SLAB = ZAMBlocks.registerBlock("black_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CONCRETE)));
    public static final DeferredBlock<Block> BROWN_CONCRETE_SLAB = ZAMBlocks.registerBlock("brown_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE)));
    public static final DeferredBlock<Block> RED_CONCRETE_SLAB = ZAMBlocks.registerBlock("red_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_CONCRETE)));
    public static final DeferredBlock<Block> ORANGE_CONCRETE_SLAB = ZAMBlocks.registerBlock("orange_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_CONCRETE)));
    public static final DeferredBlock<Block> YELLOW_CONCRETE_SLAB = ZAMBlocks.registerBlock("yellow_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_CONCRETE)));
    public static final DeferredBlock<Block> LIME_CONCRETE_SLAB = ZAMBlocks.registerBlock("lime_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_CONCRETE)));
    public static final DeferredBlock<Block> GREEN_CONCRETE_SLAB = ZAMBlocks.registerBlock("green_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE)));
    public static final DeferredBlock<Block> CYAN_CONCRETE_SLAB = ZAMBlocks.registerBlock("cyan_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CONCRETE)));
    public static final DeferredBlock<Block> LIGHT_BLUE_CONCRETE_SLAB = ZAMBlocks.registerBlock("light_blue_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_BLUE_CONCRETE)));
    public static final DeferredBlock<Block> BLUE_CONCRETE_SLAB = ZAMBlocks.registerBlock("blue_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CONCRETE)));
    public static final DeferredBlock<Block> PURPLE_CONCRETE_SLAB = ZAMBlocks.registerBlock("purple_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_CONCRETE)));
    public static final DeferredBlock<Block> MAGENTA_CONCRETE_SLAB = ZAMBlocks.registerBlock("magenta_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE)));
    public static final DeferredBlock<Block> PINK_CONCRETE_SLAB = ZAMBlocks.registerBlock("pink_concrete_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CONCRETE)));
    public static final DeferredBlock<Block> WHITE_CONCRETE_STAIRS = ZAMBlocks.registerBlock("white_concrete_stairs", () -> new StairBlock(Blocks.WHITE_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE)));
    public static final DeferredBlock<Block> LIGHT_GRAY_CONCRETE_STAIRS = ZAMBlocks.registerBlock("light_gray_concrete_stairs", () -> new StairBlock(Blocks.LIGHT_GRAY_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE)));
    public static final DeferredBlock<Block> GRAY_CONCRETE_STAIRS = ZAMBlocks.registerBlock("gray_concrete_stairs", () -> new StairBlock(Blocks.GRAY_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE)));
    public static final DeferredBlock<Block> BLACK_CONCRETE_STAIRS = ZAMBlocks.registerBlock("black_concrete_stairs", () -> new StairBlock(Blocks.BLACK_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CONCRETE)));
    public static final DeferredBlock<Block> BROWN_CONCRETE_STAIRS = ZAMBlocks.registerBlock("brown_concrete_stairs", () -> new StairBlock(Blocks.BROWN_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE)));
    public static final DeferredBlock<Block> RED_CONCRETE_STAIRS = ZAMBlocks.registerBlock("red_concrete_stairs", () -> new StairBlock(Blocks.RED_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_CONCRETE)));
    public static final DeferredBlock<Block> ORANGE_CONCRETE_STAIRS = ZAMBlocks.registerBlock("orange_concrete_stairs", () -> new StairBlock(Blocks.ORANGE_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_CONCRETE)));
    public static final DeferredBlock<Block> YELLOW_CONCRETE_STAIRS = ZAMBlocks.registerBlock("yellow_concrete_stairs", () -> new StairBlock(Blocks.YELLOW_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_CONCRETE)));
    public static final DeferredBlock<Block> LIME_CONCRETE_STAIRS = ZAMBlocks.registerBlock("lime_concrete_stairs", () -> new StairBlock(Blocks.LIME_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_CONCRETE)));
    public static final DeferredBlock<Block> GREEN_CONCRETE_STAIRS = ZAMBlocks.registerBlock("green_concrete_stairs", () -> new StairBlock(Blocks.GREEN_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE)));
    public static final DeferredBlock<Block> CYAN_CONCRETE_STAIRS = ZAMBlocks.registerBlock("cyan_concrete_stairs", () -> new StairBlock(Blocks.CYAN_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CONCRETE)));
    public static final DeferredBlock<Block> LIGHT_BLUE_CONCRETE_STAIRS = ZAMBlocks.registerBlock("light_blue_concrete_stairs", () -> new StairBlock(Blocks.LIGHT_GRAY_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE)));
    public static final DeferredBlock<Block> BLUE_CONCRETE_STAIRS = ZAMBlocks.registerBlock("blue_concrete_stairs", () -> new StairBlock(Blocks.BLUE_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CONCRETE)));
    public static final DeferredBlock<Block> PURPLE_CONCRETE_STAIRS = ZAMBlocks.registerBlock("purple_concrete_stairs", () -> new StairBlock(Blocks.PURPLE_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_CONCRETE)));
    public static final DeferredBlock<Block> MAGENTA_CONCRETE_STAIRS = ZAMBlocks.registerBlock("magenta_concrete_stairs", () -> new StairBlock(Blocks.MAGENTA_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE)));
    public static final DeferredBlock<Block> PINK_CONCRETE_STAIRS = ZAMBlocks.registerBlock("pink_concrete_stairs", () -> new StairBlock(Blocks.PINK_CONCRETE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CONCRETE)));
    public static final DeferredBlock<Block> PACKED_ICE_SLAB = ZAMBlocks.registerBlock("packed_ice_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE)));
    public static final DeferredBlock<Block> PACKED_ICE_STAIRS = ZAMBlocks.registerBlock("packed_ice_stairs", () -> new StairBlock(Blocks.PACKED_ICE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE)));
    public static final DeferredBlock<Block> SAND_SLAB = ZAMBlocks.registerBlock("sand_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
    public static final DeferredBlock<Block> SAND_STAIRS = ZAMBlocks.registerBlock("sand_stairs", () -> new StairBlock(Blocks.SAND.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ZAMBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredItem<BlockItem> registerBlockItem(String name, DeferredBlock<T> block) {
        return ZAMItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

