/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.registry;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.zam.castingcaving.registry.ZAMBlocks;

public class ZAMConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERIDOT_ORE_KEY = ZAMConfiguredFeatures.registerKey("peridot_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OPAL_ORE_KEY = ZAMConfiguredFeatures.registerKey("opal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AQUAMARINE_ORE_KEY = ZAMConfiguredFeatures.registerKey("aquamarine_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EMERALD_GEODE_KEY = ZAMConfiguredFeatures.registerKey("emerald_geode");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> peridotOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ZAMBlocks.PERIDOT_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ZAMBlocks.DEEPSLATE_PERIDOT_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> opalOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ZAMBlocks.OPAL_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ZAMBlocks.DEEPSLATE_OPAL_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> aquamarineOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ZAMBlocks.AQUAMARINE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ZAMBlocks.DEEPSLATE_AQUAMARINE_ORE.get()).defaultBlockState()));
        ZAMConfiguredFeatures.register(context, PERIDOT_ORE_KEY, Feature.ORE, new OreConfiguration(peridotOres, 5));
        ZAMConfiguredFeatures.register(context, OPAL_ORE_KEY, Feature.ORE, new OreConfiguration(opalOres, 5));
        ZAMConfiguredFeatures.register(context, AQUAMARINE_ORE_KEY, Feature.ORE, new OreConfiguration(aquamarineOres, 5));
        ZAMConfiguredFeatures.register(context, EMERALD_GEODE_KEY, Feature.GEODE, new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ZAMBlocks.EMERALD_CRYSTAL_BLOCK.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ZAMBlocks.BUDDING_EMERALD.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SMOOTH_BASALT), List.of((BlockState)((BlockState)((Block)ZAMBlocks.SMALL_EMERALD_BUD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((Block)ZAMBlocks.MEDIUM_EMERALD_BUD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((Block)ZAMBlocks.LARGE_EMERALD_BUD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((Block)ZAMBlocks.EMERALD_CLUSTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.05, 0.35, true, (IntProvider)UniformInt.of((int)4, (int)6), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)1, (int)2), -16, 16, 0.083, 1));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"castingcaving", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

