/*
 * Decompiled with CFR 0.152.
 */
package net.zam.castingcaving.registry;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.zam.castingcaving.registry.ZAMConfiguredFeatures;
import net.zam.castingcaving.registry.ZAMOrePlacement;

public class ZAMPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PERIDOT_ORE_PLACED_KEY = ZAMPlacedFeatures.registerKey("peridot_ore_placed");
    public static final ResourceKey<PlacedFeature> OPAL_ORE_PLACED_KEY = ZAMPlacedFeatures.registerKey("opal_ore_placed");
    public static final ResourceKey<PlacedFeature> AQUAMARINE_ORE_PLACED_KEY = ZAMPlacedFeatures.registerKey("aquamarine_ore_placed");
    public static final ResourceKey<PlacedFeature> EMERALD_GEODE_PLACED_KEY = ZAMPlacedFeatures.registerKey("emerald_geode_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ZAMPlacedFeatures.register(context, PERIDOT_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ZAMConfiguredFeatures.PERIDOT_ORE_KEY), ZAMOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)34))));
        ZAMPlacedFeatures.register(context, OPAL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ZAMConfiguredFeatures.OPAL_ORE_KEY), ZAMOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)5))));
        ZAMPlacedFeatures.register(context, AQUAMARINE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ZAMConfiguredFeatures.AQUAMARINE_ORE_KEY), ZAMOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-5), (VerticalAnchor)VerticalAnchor.absolute((int)73))));
        ZAMPlacedFeatures.register(context, EMERALD_GEODE_PLACED_KEY, configuredFeatures.getOrThrow(ZAMConfiguredFeatures.EMERALD_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-30), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"castingcaving", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

