/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport.entity.smokebomb;

import net.genzyuro.artillerysupport.MortarUtils;
import net.genzyuro.artillerysupport.event.ChunkLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractSmokeBombProjectileEntity
extends ThrowableItemProjectile {
    protected boolean isWeightless = false;
    protected int ticksDelay = 0;
    protected int ticksOperation = 0;
    protected BlockPos hitBlockPos;
    protected String initialDirection;
    protected double playerX;
    protected double playerZ;

    public AbstractSmokeBombProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractSmokeBombProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level, LivingEntity owner) {
        super(entityType, owner, level);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            this.initialDirection = MortarUtils.getDirectionFromYaw(player.m_146908_());
            this.playerX = player.m_20185_();
            this.playerZ = player.m_20189_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.hitBlockPos = result.m_82425_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_20242_(true);
            this.isWeightless = true;
        }
    }

    protected int getWeightlessDelay() {
        return 100;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsWeightless", this.isWeightless);
        tag.m_128405_("TicksDelay", this.ticksDelay);
        tag.m_128405_("TicksOperation", this.ticksOperation);
        tag.m_128359_("InitialDirection", this.initialDirection != null ? this.initialDirection : "");
        if (this.hitBlockPos != null) {
            tag.m_128405_("HitBlockPosX", this.hitBlockPos.m_123341_());
            tag.m_128405_("HitBlockPosY", this.hitBlockPos.m_123342_());
            tag.m_128405_("HitBlockPosZ", this.hitBlockPos.m_123343_());
        } else {
            tag.m_128405_("HitBlockPosX", -1);
            tag.m_128405_("HitBlockPosY", -1);
            tag.m_128405_("HitBlockPosZ", -1);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.isWeightless = tag.m_128471_("IsWeightless");
        this.ticksDelay = tag.m_128451_("TicksDelay");
        this.ticksOperation = tag.m_128451_("TicksOperation");
        String dir = tag.m_128461_("InitialDirection");
        this.initialDirection = dir.isEmpty() ? null : dir;
        int hx = tag.m_128451_("HitBlockPosX");
        int hy = tag.m_128451_("HitBlockPosY");
        int hz = tag.m_128451_("HitBlockPosZ");
        this.hitBlockPos = hx == -1 && hy == -1 && hz == -1 ? null : new BlockPos(hx, hy, hz);
    }

    public void m_8119_() {
        ChunkLoader chunkLoader;
        ServerLevel serverLevel;
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            chunkLoader = ChunkLoader.get(serverLevel);
            ChunkPos currentChunk = new ChunkPos(this.m_20183_());
            chunkLoader.forceLoadChunk(serverLevel, currentChunk);
        }
        if (this.isWeightless) {
            ++this.ticksDelay;
            if (this.ticksDelay >= this.getWeightlessDelay()) {
                ++this.ticksOperation;
                if (this.getDespawnTicks() >= this.ticksOperation) {
                    this.handleTick();
                }
            }
            if (this.ticksOperation >= this.getDespawnTicks() + 50) {
                chunkLoader = this.m_9236_();
                if (chunkLoader instanceof ServerLevel) {
                    serverLevel = (ServerLevel)chunkLoader;
                    chunkLoader = ChunkLoader.get(serverLevel);
                    chunkLoader.releaseAllChunks(serverLevel);
                }
                this.m_146870_();
            }
            if (!this.m_9236_().f_46443_) {
                if (this.ticksOperation <= 150 && this.ticksOperation % 2 == 0) {
                    this.m_9236_().m_7605_((Entity)this, (byte)88);
                }
            } else if (this.ticksOperation <= 150 && this.ticksOperation % 2 == 0) {
                this.spawnSmokeParticles();
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 88) {
            this.spawnSmokeParticles();
        } else {
            super.m_7822_(id);
        }
    }

    private void spawnSmokeParticles() {
        MortarUtils.spawnSmokeParticles(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    protected abstract void handleTick();

    protected abstract int getDespawnTicks();
}

