/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

public class ChunkLoader
extends SavedData {
    private final HashSet<Long> loadedChunks = new HashSet();
    private final Queue<ChunkPos> loadQueue = new LinkedList<ChunkPos>();

    public static ChunkLoader get(ServerLevel level) {
        return (ChunkLoader)level.m_8895_().m_164861_(ChunkLoader::load, ChunkLoader::new, "custom_chunk_manager");
    }

    public static ChunkLoader load(CompoundTag tag) {
        long[] chunks;
        ChunkLoader manager = new ChunkLoader();
        for (long chunk : chunks = tag.m_128467_("LoadedChunks")) {
            manager.loadedChunks.add(chunk);
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        long[] chunks = this.loadedChunks.stream().mapToLong(Long::longValue).toArray();
        tag.m_128388_("LoadedChunks", chunks);
        return tag;
    }

    public void forceLoadChunk(ServerLevel level, ChunkPos pos) {
        if (this.loadedChunks.add(pos.m_45588_())) {
            this.loadQueue.add(pos);
            level.m_7726_().m_6692_(pos, true);
            this.m_77762_();
        }
    }

    public void releaseChunk(ServerLevel level, ChunkPos pos) {
        if (this.loadedChunks.remove(pos.m_45588_())) {
            level.m_7726_().m_6692_(pos, false);
            this.m_77762_();
        }
    }

    public void releaseAllChunks(ServerLevel level) {
        for (Long chunkPosLong : this.loadedChunks) {
            ChunkPos chunkPos = new ChunkPos(chunkPosLong.longValue());
            level.m_7726_().m_6692_(chunkPos, false);
        }
        this.loadedChunks.clear();
        this.loadQueue.clear();
        this.m_77762_();
    }

    public void tick(ServerLevel level) {
        Iterator<Long> iterator = this.loadedChunks.iterator();
        while (iterator.hasNext()) {
            long chunk = iterator.next();
            if (!this.shouldUnload(chunk)) continue;
            level.m_7726_().m_6692_(new ChunkPos(chunk), false);
            iterator.remove();
            this.m_77762_();
        }
    }

    private boolean shouldUnload(long chunk) {
        return false;
    }

    public Set<Long> getLoadedChunks() {
        return Collections.unmodifiableSet(this.loadedChunks);
    }
}

