/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.blocks.CordgrassBlock;
import uwu.juni.wetland_whimsy.content.blocks.PennywortBlock;
import uwu.juni.wetland_whimsy.content.blocks.StrippableLogBlock;
import uwu.juni.wetland_whimsy.content.blocks.SussyMudBlock;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyWoodTypes;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTreeGrowers;

public class WetlandWhimsyBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"wetland_whimsy");
    public static final DeferredBlock<StrippableLogBlock> BALD_CYPRESS_LOG = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_log", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> STRIPPED_BALD_CYPRESS_LOG = WetlandWhimsyBlocks.registerBlockAndItem("stripped_bald_cypress_log", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> BALD_CYPRESS_WOOD = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_wood", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> STRIPPED_BALD_CYPRESS_WOOD = WetlandWhimsyBlocks.registerBlockAndItem("stripped_bald_cypress_wood", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<SaplingBlock> BALD_CYPRESS_SAPLING = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_sapling", () -> new SaplingBlock(WetlandWhimsyTreeGrowers.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<LeavesBlock> BALD_CYPRESS_LEAVES = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }
    });
    public static final DeferredBlock<Block> BALD_CYPRESS_PLANKS = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<StairBlock> BALD_CYPRESS_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_stairs", () -> new StairBlock(((Block)BALD_CYPRESS_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<SlabBlock> BALD_CYPRESS_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceBlock> BALD_CYPRESS_FENCE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceGateBlock> BALD_CYPRESS_FENCE_GATE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_fence_gate", () -> new FenceGateBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<DoorBlock> BALD_CYPRESS_DOOR = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_door", () -> new DoorBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    public static final DeferredBlock<TrapDoorBlock> BALD_CYPRESS_TRAPDOOR = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_trapdoor", () -> new TrapDoorBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final DeferredBlock<ButtonBlock> BALD_CYPRESS_BUTTON = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_button", () -> new ButtonBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final DeferredBlock<PressurePlateBlock> BALD_CYPRESS_PRESSURE_PLATE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_pressure_plate", () -> new PressurePlateBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    public static final DeferredBlock<StandingSignBlock> BALD_CYPRESS_SIGN = BLOCKS.register("bald_cypress_sign", () -> new StandingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallSignBlock> BALD_CYPRESS_WALL_SIGN = BLOCKS.register("bald_cypress_wall_sign", () -> new WallSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(BALD_CYPRESS_SIGN)));
    public static final DeferredBlock<CeilingHangingSignBlock> BALD_CYPRESS_HANGING_SIGN = BLOCKS.register("bald_cypress_hanging_sign", () -> new CeilingHangingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallHangingSignBlock> BALD_CYPRESS_WALL_HANGING_SIGN = BLOCKS.register("bald_cypress_wall_hanging_sign", () -> new WallHangingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(BALD_CYPRESS_HANGING_SIGN)));
    public static final DeferredBlock<Block> LIMESTONE = WetlandWhimsyBlocks.registerBlockAndItem("limestone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.CALCITE)));
    public static final DeferredBlock<Block> POLISHED_LIMESTONE = WetlandWhimsyBlocks.registerBlockAndItem("polished_limestone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<Block> LIMESTONE_BRICKS = WetlandWhimsyBlocks.registerBlockAndItem("limestone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<StairBlock> LIMESTONE_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("limestone_stairs", () -> new StairBlock(((Block)LIMESTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_LIMESTONE_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("polished_limestone_stairs", () -> new StairBlock(((Block)POLISHED_LIMESTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<StairBlock> LIMESTONE_BRICK_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("limestone_brick_stairs", () -> new StairBlock(((Block)LIMESTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<SlabBlock> LIMESTONE_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("limestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_LIMESTONE_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("polished_limestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<SlabBlock> LIMESTONE_BRICK_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("limestone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<WallBlock> LIMESTONE_WALL = WetlandWhimsyBlocks.registerBlockAndItem("limestone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_LIMESTONE_WALL = WetlandWhimsyBlocks.registerBlockAndItem("polished_limestone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<WallBlock> LIMESTONE_BRICK_WALL = WetlandWhimsyBlocks.registerBlockAndItem("limestone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<RotatedPillarBlock> LIMESTONE_PILLAR = WetlandWhimsyBlocks.registerBlockAndItem("limestone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LIMESTONE.get()))));
    public static final DeferredBlock<CordgrassBlock> CORDGRASS = WetlandWhimsyBlocks.registerBlockAndItem("cordgrass", () -> new CordgrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<PennywortBlock> PENNYWORT = WetlandWhimsyBlocks.registerBlockAndItem("pennywort", () -> new PennywortBlock((Holder<MobEffect>)MobEffects.DARKNESS, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<SussyMudBlock> SUSSY_MUD = WetlandWhimsyBlocks.registerBlockAndItem("suspicious_mud", () -> new SussyMudBlock(Blocks.MUD, SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND_COMPLETED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));

    public static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Supplier<T> block) {
        DeferredBlock register = BLOCKS.register(name, block);
        WetlandWhimsyItems.ITEMS.registerSimpleBlockItem(name, (Supplier)register);
        return register;
    }

    public static void createSignItems() {
        WetlandWhimsyItems.ITEMS.register("bald_cypress_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)BALD_CYPRESS_SIGN.get(), (Block)BALD_CYPRESS_WALL_SIGN.get()));
        WetlandWhimsyItems.ITEMS.register("bald_cypress_hanging_sign", () -> new HangingSignItem((Block)BALD_CYPRESS_HANGING_SIGN.get(), (Block)BALD_CYPRESS_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
    }
}

