/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.data.worldgen;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.blocks.PennywortBlock;
import uwu.juni.wetland_whimsy.worldgen.bald_cypress.BaldCypressFoliagePlacer;
import uwu.juni.wetland_whimsy.worldgen.bald_cypress.BaldCypressTrunkPlacer;

public class WetlandWhimsyConfiguredFeaturesDatagen {
    public static final ResourceKey<ConfiguredFeature<?, ?>> BALD_CYPRESS_TREE = WetlandWhimsyConfiguredFeaturesDatagen.createKey("bald_cypress_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CORDGRASS_PATCH = WetlandWhimsyConfiguredFeaturesDatagen.createKey("cordgrass_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PENNYWORT_PATCH = WetlandWhimsyConfiguredFeaturesDatagen.createKey("pennywort_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PENNYWORT_PATCH_SMALL = WetlandWhimsyConfiguredFeaturesDatagen.createKey("pennywort_single");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIMESTONE_DISK = WetlandWhimsyConfiguredFeaturesDatagen.createKey("limestone_disk");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_DISK = WetlandWhimsyConfiguredFeaturesDatagen.createKey("mud_disk");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_POOL = WetlandWhimsyConfiguredFeaturesDatagen.createKey("mud_pool");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_BOG = WetlandWhimsyConfiguredFeaturesDatagen.createKey("trees_bog");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_MARSH = WetlandWhimsyConfiguredFeaturesDatagen.createKey("trees_marsh");

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wetland_whimsy", (String)name));
    }

    public static void bootstap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        SimpleWeightedRandomList.Builder pennywortRandomState = new SimpleWeightedRandomList.Builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pennywortRandomState.add((Object)((BlockState)((BlockState)((PennywortBlock)((Object)WetlandWhimsyBlocks.PENNYWORT.get())).defaultBlockState().setValue(PennywortBlock.FACING, (Comparable)dir)).setValue((Property)PennywortBlock.PENNYWORT_COUNT, (Comparable)Integer.valueOf(i))));
            }
        }
        context.register(BALD_CYPRESS_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LOG.get())), (TrunkPlacer)new BaldCypressTrunkPlacer(6, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LEAVES.get())), (FoliagePlacer)new BaldCypressFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)6)), (FeatureSize)new TwoLayersFeatureSize(0, 2, 4)).decorators(List.of(new LeaveVineDecorator(0.2f), new TrunkVineDecorator())).ignoreVines().build()));
        context.register(CORDGRASS_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(64, 4, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.CORDGRASS.get())))))));
        context.register(PENNYWORT_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(64, 10, 4, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(pennywortRandomState))))));
        context.register(PENNYWORT_PATCH_SMALL, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(4, 3, 4, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(pennywortRandomState))))));
        context.register(LIMESTONE_DISK, (Object)new ConfiguredFeature(Feature.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.LIMESTONE.get())), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, Blocks.STONE, Blocks.DIORITE, Blocks.GRANITE, Blocks.ANDESITE, (Block)WetlandWhimsyBlocks.LIMESTONE.get())), (IntProvider)UniformInt.of((int)3, (int)6), 4)));
        context.register(MUD_DISK, (Object)new ConfiguredFeature(Feature.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.MUD), BlockPredicate.matchesTag((TagKey)BlockTags.LUSH_GROUND_REPLACEABLE), (IntProvider)UniformInt.of((int)5, (int)7), 3)));
        context.register(MUD_POOL, (Object)new ConfiguredFeature(Feature.WATERLOGGED_VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MUD), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(PENNYWORT_PATCH_SMALL), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 5, 0.1f, (IntProvider)UniformInt.of((int)5, (int)8), 0.7f)));
        Holder.Reference HUGE_RED_MUSHROOM = configuredFeatures.getOrThrow(TreeFeatures.HUGE_RED_MUSHROOM);
        Holder.Reference HUGE_BROWN_MUSHROOM = configuredFeatures.getOrThrow(TreeFeatures.HUGE_BROWN_MUSHROOM);
        Holder.Reference BIRCH = configuredFeatures.getOrThrow(TreeFeatures.BIRCH);
        Holder.Reference SPRUCE = configuredFeatures.getOrThrow(TreeFeatures.SPRUCE);
        context.register(TREES_BOG, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.45f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)HUGE_RED_MUSHROOM, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.0075f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)HUGE_BROWN_MUSHROOM, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.025f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}))));
        context.register(TREES_MARSH, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.4f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)BIRCH, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.3f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)SPRUCE, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}), 0.3f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))}))));
    }
}

