/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.data.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.data.worldgen.WetlandWhimsyConfiguredFeaturesDatagen;

public class WetlandWhimsyPlacedFeaturesDatagen {
    public static final ResourceKey<PlacedFeature> TREES_BOG = WetlandWhimsyPlacedFeaturesDatagen.createKey("trees_bog");
    public static final ResourceKey<PlacedFeature> TREES_MARSH = WetlandWhimsyPlacedFeaturesDatagen.createKey("trees_marsh");
    public static final ResourceKey<PlacedFeature> CORDGRASS_PATCH = WetlandWhimsyPlacedFeaturesDatagen.createKey("cordgrass_patch");
    public static final ResourceKey<PlacedFeature> PENNYWORT_PATCH = WetlandWhimsyPlacedFeaturesDatagen.createKey("pennywort_patch");
    public static final ResourceKey<PlacedFeature> LIMESTONE_DISK = WetlandWhimsyPlacedFeaturesDatagen.createKey("limestone_disk");
    public static final ResourceKey<PlacedFeature> MUD_DISK = WetlandWhimsyPlacedFeaturesDatagen.createKey("mud_disk");
    public static final ResourceKey<PlacedFeature> MUD_POOL = WetlandWhimsyPlacedFeaturesDatagen.createKey("mud_pool");
    public static final ResourceKey<PlacedFeature> SUPER_THICK_CORDGRASS_PATCH = WetlandWhimsyPlacedFeaturesDatagen.createKey("super_thick_cordgrass_patch");
    public static final ResourceKey<PlacedFeature> LILYPAD_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE = WetlandWhimsyPlacedFeaturesDatagen.createKey("lilypad_clone");

    public static void bootstap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(TREES_BOG, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.TREES_BOG), WetlandWhimsyPlacedFeaturesDatagen.bogTreePlacement()));
        context.register(TREES_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.TREES_MARSH), WetlandWhimsyPlacedFeaturesDatagen.marshTreePlacement()));
        context.register(CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.CORDGRASS_PATCH), WetlandWhimsyPlacedFeaturesDatagen.foliagePlacement()));
        context.register(PENNYWORT_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.PENNYWORT_PATCH), WetlandWhimsyPlacedFeaturesDatagen.foliagePlacement()));
        context.register(LIMESTONE_DISK, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.LIMESTONE_DISK), (List)ImmutableList.builder().add((Object)InSquarePlacement.spread()).add((Object)PlacementUtils.HEIGHTMAP_TOP_SOLID).add((Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER}))).add((Object)BiomeFilter.biome()).build()));
        context.register(MUD_DISK, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.MUD_DISK), (List)ImmutableList.builder().add((Object)PlacementUtils.countExtra((int)2, (float)0.5f, (int)1)).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)2)).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome()).build()));
        context.register(MUD_POOL, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.MUD_POOL), WetlandWhimsyPlacedFeaturesDatagen.foliagePlacement()));
        context.register(SUPER_THICK_CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeaturesDatagen.CORDGRASS_PATCH), WetlandWhimsyPlacedFeaturesDatagen.bogTreePlacement()));
        context.register(LILYPAD_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(VegetationFeatures.PATCH_WATERLILY), VegetationPlacements.worldSurfaceSquaredWithCount((int)4)));
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wetland_whimsy", (String)name));
    }

    public static List<PlacementModifier> bogTreePlacement() {
        return ImmutableList.builder().add((Object)PlacementUtils.countExtra((int)28, (float)0.1f, (int)1)).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)2)).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome()).add((Object)PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))).build();
    }

    public static List<PlacementModifier> marshTreePlacement() {
        return ImmutableList.builder().add((Object)CountPlacement.of((int)4)).add((Object)RarityFilter.onAverageOnceEvery((int)5)).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)0)).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome()).add((Object)PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))).build();
    }

    public static List<PlacementModifier> foliagePlacement() {
        return ImmutableList.builder().add((Object)PlacementUtils.HEIGHTMAP_WORLD_SURFACE).add((Object)CountPlacement.of((int)3)).add((Object)RarityFilter.onAverageOnceEvery((int)3)).add((Object)InSquarePlacement.spread()).add((Object)PlacementUtils.filteredByBlockSurvival((Block)Blocks.SHORT_GRASS)).add((Object)BiomeFilter.biome()).build();
    }
}

