/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.bald_cypress;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTrunkPlacers;

public class BaldCypressTrunkPlacer
extends TrunkPlacer {
    private static final int[] X = new int[]{0, -1, 0, 1};
    private static final int[] Y = new int[]{-1, 0, 1, 0};
    public static final MapCodec<BaldCypressTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BaldCypressTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BaldCypressTrunkPlacer::new));

    public BaldCypressTrunkPlacer(int height, int heightRandA, int heightRandB) {
        super(height, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)WetlandWhimsyTrunkPlacers.BALD_CYPRESS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        TrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        this.root(level, blockSetter, random, pos, config);
        for (int i = 0; i < height; ++i) {
            this.placeLog(level, blockSetter, random, pos.above(i), config);
            if (i <= 2 || i >= height - 2 || i % 2 == 0) continue;
            for (int j = 0; j < 4; ++j) {
                if (!(Math.random() < (double)((float)i / (float)height) - 0.25)) continue;
                this.branch(level, blockSetter, random, pos.above(i), X[j], Y[j], config);
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height), 0, false));
    }

    public void branch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, int x, int y, TreeConfiguration config) {
        for (int i = 0; i < 2; ++i) {
            int new_x = x * i;
            int new_y = y * i;
            this.placeLog(level, blockSetter, random, pos.offset(new_x, 0, new_y), config);
        }
    }

    public void root(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        int rootPosX = ThreadLocalRandom.current().nextInt(-1, 1);
        int rootPosZ = ThreadLocalRandom.current().nextInt(-1, 1);
        TrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.offset(rootPosX, -1, rootPosZ), (TreeConfiguration)config);
        for (int i = 0; i < 2; ++i) {
            this.placeLog(level, blockSetter, random, pos.offset(rootPosX, i, rootPosZ), config);
        }
    }
}

