/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.joml.Matrix4f;

public final class TESClientUtil {
    public static final ResourceLocation SPRITES_ATLAS = ResourceLocation.withDefaultNamespace((String)"textures/atlas/gui.png");
    public static final ResourceLocation ENTITY_ICON_FRAME = TESConstants.id("entity_icon_frame");
    public static final ResourceLocation BAR_EMPTY = TESConstants.id("bar/empty");
    public static final ResourceLocation BAR_OVERLAY_SEGMENTS = TESConstants.id("bar/overlay_segments");
    public static final ResourceLocation ENTITY_TYPE_AQUATIC = TESConstants.id("entity_type/aquatic");
    public static final ResourceLocation ENTITY_TYPE_ARTHROPOD = TESConstants.id("entity_type/arthropod");
    public static final ResourceLocation ENTITY_TYPE_ILLAGER = TESConstants.id("entity_type/illager");
    public static final ResourceLocation ENTITY_TYPE_UNDEAD = TESConstants.id("entity_type/undead");
    public static final ResourceLocation PROPERTY_FIRE_IMMUNE = TESConstants.id("property/fire_immune");
    public static final ResourceLocation PROPERTY_MELEE = TESConstants.id("property/melee");
    public static final ResourceLocation PROPERTY_RANGED = TESConstants.id("property/ranged");
    public static final ResourceLocation PROPERTY_STORAGE = TESConstants.id("property/storage");
    public static final ResourceLocation STAT_ARMOUR = TESConstants.id("stat/armour");
    public static final ResourceLocation STAT_TOUGHNESS = TESConstants.id("stat/toughness");
    public static final ResourceLocation STAT_MELEE_DAMAGE = TESConstants.id("stat/melee_damage");

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(GuiGraphics guiGraphics, String text, float x, float y, int colour) {
        TESClientUtil.renderCenteredText(guiGraphics, (Component)Component.literal((String)text), x, y, colour);
    }

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(GuiGraphics guiGraphics, Component text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, Minecraft.getInstance().font, text, x - (float)Minecraft.getInstance().font.width((FormattedText)text) / 2.0f, y + 4.0f, colour);
    }

    public static void centerTextForRender(Component text, float x, float y, BiConsumer<Float, Float> renderRunnable) {
        Float f = Float.valueOf(x - (float)Minecraft.getInstance().font.width((FormattedText)text) / 2.0f);
        Objects.requireNonNull(Minecraft.getInstance().font);
        renderRunnable.accept(f, Float.valueOf(y + (float)(9 - 1) / 2.0f));
    }

    public static void positionFacingCamera(PoseStack poseStack) {
        poseStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
    }

    public static void prepRenderForTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void constructBarRender(GuiGraphics guiGraphics, int x, int y, int width, TextureAtlasSprite sprite, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        TESClientUtil.drawSprite(guiGraphics, sprite, x, y, Math.min(5, percentPixels), 5, 0, 0, Math.min(5, percentPixels), 5, 182, 5);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSprite(guiGraphics, sprite, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5, 0, Math.min(midBarWidth, percentPixels - 5), 5, 182, 5);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSprite(guiGraphics, sprite, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177, 0, Math.min(5, percentPixels - 5), 5, 182, 5);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            TextureAtlasSprite overlaySprite = TESClientUtil.getAtlasSprite(BAR_OVERLAY_SEGMENTS);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)overlaySprite.atlasLocation());
            TESClientUtil.drawSprite(guiGraphics, overlaySprite, x, y, width, 5, 0, 0, 182, 5, 182, 5);
        }
    }

    public static void renderEntityIcon(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.getBbWidth(), 40.0f / entity.getBbHeight()), 0.95f);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        boolean scissor = TESConstants.CONFIG.hudPreventEntityOverflow();
        if (scissor) {
            guiGraphics.enableScissor(2, 2, 36, 47);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(SPRITES_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(ENTITY_ICON_FRAME), 2, 2, 34, 45, 0, 0, 34, 45, 34, 45);
            poseStack.translate(20.0f, 25.0f, 0.0f);
            poseStack.scale(-20.0f, -20.0f, 20.0f);
        }
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, entity.getBbHeight() * -0.5f, entity.getBbWidth());
        float yBodyRotPrev = entity.yBodyRot;
        float yRotPrev = entity.getYRot();
        float xRotPrev = entity.getXRot();
        float yHeadRotOldPrev = entity.yHeadRotO;
        float yHeadRotPrev = entity.yHeadRot;
        int hurtTicks = entity.hurtTime;
        float attackTimePrev = entity.attackAnim;
        float attackTimeOldPrev = entity.oAttackAnim;
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(!entity.level().tickRateManager().isEntityFrozen((Entity)entity));
        entity.setYRot(22.5f);
        entity.setXRot(0.0f);
        entity.yBodyRot = 22.5f;
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        entity.hurtTime = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.hurtTime : 0;
        entity.attackAnim = 0.0f;
        entity.oAttackAnim = 0.0f;
        Lighting.setupForEntityInInventory();
        RenderSystem.runAsFancy(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (MultiBufferSource)bufferSource));
        bufferSource.endBatch();
        Lighting.setupFor3DItems();
        entity.setYRot(yRotPrev);
        entity.setXRot(xRotPrev);
        entity.yBodyRot = yBodyRotPrev;
        entity.yHeadRot = yHeadRotPrev;
        entity.yHeadRotO = yHeadRotOldPrev;
        entity.hurtTime = hurtTicks;
        entity.attackAnim = attackTimePrev;
        entity.oAttackAnim = attackTimeOldPrev;
        poseStack.popPose();
        if (scissor) {
            guiGraphics.disableScissor();
        }
    }

    public static <T extends Entity> void renderEntityRaw(PoseStack poseStack, T entity, float partialTick, float rotYaw, int packedLight, MultiBufferSource bufferSource) {
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer(entity);
        try {
            Vec3 renderOffset = entityRenderer.getRenderOffset(entity, partialTick);
            poseStack.pushPose();
            poseStack.translate(renderOffset.x, renderOffset.y, renderOffset.z);
            entityRenderer.render(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
        catch (Exception ex) {
            CrashReport wrappedReport = CrashReport.forThrowable((Throwable)ex, (String)"Rendering entity in world");
            CrashReportCategory entityReportCategory = wrappedReport.addCategory("Entity being rendered");
            entity.fillCrashReportCategory(entityReportCategory);
            CrashReportCategory rendererReportCategory = wrappedReport.addCategory("Renderer details");
            rendererReportCategory.setDetail("Assigned renderer", (Object)entityRenderer);
            throw new ReportedException(wrappedReport);
        }
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, pngSize, pngSize);
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngWidth, int pngHeight) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, width, height, pngWidth, pngHeight);
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float widthRatio = 1.0f / (float)pngWidth;
        float heightRatio = 1.0f / (float)pngHeight;
        RenderSystem.enableBlend();
        buffer.addVertex(pose, (float)posX, (float)posY, 0.0f).setUv(u * widthRatio, v * heightRatio);
        buffer.addVertex(pose, (float)posX, (float)posY + (float)height, 0.0f).setUv(u * widthRatio, (v + (float)vHeight) * heightRatio);
        buffer.addVertex(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).setUv((u + (float)uWidth) * widthRatio, (v + (float)vHeight) * heightRatio);
        buffer.addVertex(pose, (float)posX + (float)width, (float)posY, 0.0f).setUv((u + (float)uWidth) * widthRatio, v * heightRatio);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawSprite(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int posX, int posY, int width, int height, int u, int v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float uMin = sprite.getU((float)u / (float)pngWidth);
        float uMax = sprite.getU((float)(u + uWidth) / (float)pngWidth);
        float vMin = sprite.getV((float)v / (float)pngHeight);
        float vMax = sprite.getV((float)(v + vHeight) / (float)pngHeight);
        RenderSystem.enableBlend();
        buffer.addVertex(pose, (float)posX, (float)posY, 0.0f).setUv(uMin, vMin);
        buffer.addVertex(pose, (float)posX, (float)posY + (float)height, 0.0f).setUv(uMin, vMax);
        buffer.addVertex(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).setUv(uMax, vMax);
        buffer.addVertex(pose, (float)posX + (float)width, (float)posY, 0.0f).setUv(uMax, vMin);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawText(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, font, (Component)Component.literal((String)text), x, y, colour);
    }

    public static void drawText(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderDefaultStyleText(font, guiGraphics.pose().last().pose(), text.getVisualOrderText(), x, y, colour, TextRenderType.NORMAL.getOutlineColour(colour), 0xF000F0, guiGraphics.bufferSource());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDefaultStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        fontRenderer.drawInBatch(text, x, y, colour, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, outlineColour, packedLight);
    }

    public static void drawTextWithShadow(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithShadow(guiGraphics, font, (Component)Component.literal((String)text), x, y, colour);
    }

    public static void drawTextWithShadow(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderDropShadowStyleText(font, guiGraphics.pose().last().pose(), text.getVisualOrderText(), x, y, colour, TextRenderType.DROP_SHADOW.getOutlineColour(colour), 0xF000F0, guiGraphics.bufferSource());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDropShadowStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        Font font = fontRenderer;
        Objects.requireNonNull(font);
        Font.StringRenderOutput outlineOutput = new Font.StringRenderOutput(font, (MultiBufferSource)bufferSource, 0.0f, 0.0f, borderColour, false, pose, Font.DisplayMode.NORMAL, packedLight);
        float[] newX = new float[]{x};
        text.accept((currentPosition, style, codePoint) -> {
            GlyphInfo glyphInfo = fontRenderer.getFontSet(style.getFont()).getGlyphInfo(codePoint, fontRenderer.filterFishyGlyphs);
            outlineOutput.x = newX[0] + glyphInfo.getShadowOffset();
            outlineOutput.y = y + glyphInfo.getShadowOffset();
            newX[0] = newX[0] + glyphInfo.getAdvance(style.isBold());
            return outlineOutput.accept(currentPosition, style.withColor(borderColour), codePoint);
        });
        Font font2 = fontRenderer;
        Objects.requireNonNull(font2);
        Font.StringRenderOutput output = new Font.StringRenderOutput(font2, (MultiBufferSource)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, Font.DisplayMode.POLYGON_OFFSET, packedLight);
        text.accept((FormattedCharSink)output);
        output.finish(0, x);
    }

    public static void drawTextWithGlow(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithGlow(guiGraphics, font, (Component)Component.literal((String)text), x, y, colour);
    }

    public static void drawTextWithGlow(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderGlowingStyleText(font, guiGraphics.pose().last().pose(), text.getVisualOrderText(), x, y, colour, TextRenderType.GLOWING.getOutlineColour(colour), 0xF000F0, guiGraphics.bufferSource());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderGlowingStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        fontRenderer.drawInBatch8xOutline(text, x, y, colour, outlineColour, pose, (MultiBufferSource)bufferSource, packedLight);
    }

    public static void drawTextWithOutline(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithOutline(guiGraphics, font, (Component)Component.literal((String)text), x, y, colour);
    }

    public static void drawTextWithOutline(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderOutlineStyleText(font, guiGraphics.pose().last().pose(), text.getVisualOrderText(), x, y, colour, TextRenderType.OUTLINED.getOutlineColour(colour), 0xF000F0, guiGraphics.bufferSource());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderOutlineStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        Font font = fontRenderer;
        Objects.requireNonNull(font);
        Font.StringRenderOutput outlineOutput = new Font.StringRenderOutput(font, (MultiBufferSource)bufferSource, 0.0f, 0.0f, borderColour, false, pose, Font.DisplayMode.NORMAL, packedLight);
        for (float deltaX = -1.0f; deltaX <= 1.0f; deltaX += 1.0f) {
            for (float deltaY = -1.0f; deltaY <= 1.0f; deltaY += 1.0f) {
                if (!(deltaX == 0.0f ^ deltaY == 0.0f)) continue;
                float[] newX = new float[]{x};
                float offsetX = deltaX;
                float offsetY = deltaY;
                text.accept((currentPosition, style, codePoint) -> {
                    GlyphInfo glyphInfo = fontRenderer.getFontSet(style.getFont()).getGlyphInfo(codePoint, fontRenderer.filterFishyGlyphs);
                    outlineOutput.x = newX[0] + offsetX * glyphInfo.getShadowOffset() * 0.6f;
                    outlineOutput.y = y + offsetY * glyphInfo.getShadowOffset() * 0.6f;
                    newX[0] = newX[0] + glyphInfo.getAdvance(style.isBold());
                    return outlineOutput.accept(currentPosition, style.withColor(borderColour), codePoint);
                });
            }
        }
        Font font2 = fontRenderer;
        Objects.requireNonNull(font2);
        Font.StringRenderOutput output = new Font.StringRenderOutput(font2, (MultiBufferSource)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, Font.DisplayMode.POLYGON_OFFSET, packedLight);
        text.accept((FormattedCharSink)output);
        output.finish(0, x);
    }

    public static void drawColouredSquare(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int colour) {
        guiGraphics.fill(posX, posY, posX + width, posY + height, colour);
    }

    public static String translateKey(String key, Object ... args) {
        return I18n.get((String)key, (Object[])args);
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static GuiGraphics createInlineGuiGraphics(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), bufferSource);
        guiGraphics.pose().mulPose(poseStack.last().pose());
        return guiGraphics;
    }

    public static TextureAtlasSprite getAtlasSprite(ResourceLocation texture) {
        return Minecraft.getInstance().getGuiSprites().getSprite(texture);
    }

    public static int multiplyARGBColour(int colour, float multiplier) {
        return FastColor.ARGB32.color((int)(colour >>> 24), (int)(Mth.floor((float)((float)(colour >> 16 & 0xFF) * multiplier)) & 0xFF), (int)(Mth.floor((float)((float)(colour >> 8 & 0xFF) * multiplier)) & 0xFF), (int)(Mth.floor((float)((float)(colour & 0xFF) * multiplier)) & 0xFF));
    }

    public static enum TextRenderType {
        NORMAL(TESClientUtil::renderDefaultStyleText, colour -> 0),
        DROP_SHADOW(TESClientUtil::renderDropShadowStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        GLOWING(TESClientUtil::renderGlowingStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        OUTLINED(TESClientUtil::renderOutlineStyleText, colour -> 0);

        private final StyledTextRenderer style;
        private final Int2IntFunction outlineColourGenerator;

        private TextRenderType(StyledTextRenderer style, Int2IntFunction outlineColourGenerator) {
            this.style = style;
            this.outlineColourGenerator = outlineColourGenerator;
        }

        public void render(Font fontRenderer, PoseStack poseStack, Component component, float x, float y, int colour, MultiBufferSource.BufferSource bufferSource) {
            this.render(fontRenderer, poseStack.last().pose(), component.getVisualOrderText(), x, y, colour, this.outlineColourGenerator.applyAsInt(colour), 0xF000F0, bufferSource);
        }

        public void render(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
            this.style.render(fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource);
        }

        public int getOutlineColour(int colour) {
            return this.outlineColourGenerator.applyAsInt(colour);
        }
    }

    @FunctionalInterface
    public static interface StyledTextRenderer {
        public void render(Font var1, Matrix4f var2, FormattedCharSequence var3, float var4, float var5, int var6, int var7, int var8, MultiBufferSource.BufferSource var9);
    }
}

