/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)Util.make(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Armour", BuiltinHudElements::renderEntityArmour);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
        map.put("HorseStats", BuiltinHudElements::renderHorseStats);
    });
    protected static final List<TESHudEntityIcon> ENTITY_ICONS = (List)Util.make(new CopyOnWriteArrayList(), list -> list.addAll(List.of(TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_FIRE_IMMUNE, TESUtil::isFireImmune), TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_MELEE, TESUtil::isMeleeMob), TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_RANGED, TESUtil::isRangedMob), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_AQUATIC, entity -> entity.getType().is(EntityTypeTags.AQUATIC)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_ILLAGER, entity -> entity.getType().is(EntityTypeTags.ILLAGER)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_ARTHROPOD, entity -> entity.getType().is(EntityTypeTags.ARTHROPOD)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_UNDEAD, entity -> entity.getType().is(EntityTypeTags.UNDEAD)))));
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static LivingEntity TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(LivingEntity entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = Mth.floor((double)(Blaze3D.getTime() * 20.0)) + 1 + TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static LivingEntity getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void addHudEntityIcon(TESHudEntityIcon icon) {
        ENTITY_ICONS.add(icon);
    }

    public static void renderForHud(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker) {
        if (TARGET_ENTITY == null) {
            return;
        }
        if (TARGET_ENTITY.isRemoved() || TARGET_ENTITY.level() != mc.level || (long)Mth.floor((double)(Blaze3D.getTime() * 20.0)) > TARGET_EXPIRY_TIME) {
            TARGET_ENTITY = null;
            return;
        }
        if (!TESAPI.getConfig().hudEnabled() || Minecraft.getInstance().options.hideGui || !TESAPI.getConfig().hudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().hudOpacity();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        TESAPI.getConfig().hudRenderPosition().adjustRenderForHudPosition(guiGraphics);
        RenderSystem.enableBlend();
        if (TESAPI.getConfig().hudEntityRender()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            TESClientUtil.renderEntityIcon(guiGraphics, mc, deltaTracker, TARGET_ENTITY, hudOpacity, true);
            poseStack.translate(40.0f, 0.0f, 0.0f);
        }
        poseStack.translate(0.0f, 2.0f, 0.0f);
        for (TESHudElement element : ELEMENTS.values()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            int offset = element.render(guiGraphics, mc, deltaTracker, TARGET_ENTITY, hudOpacity, false);
            if (offset <= 0) continue;
            poseStack.translate(0.0f, (float)(2 + offset), 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public static void renderInWorld(PoseStack poseStack, LivingEntity entity, DeltaTracker deltaTracker) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !entityState.isValid()) {
            return;
        }
        entityState.markActive();
        if (!TESAPI.getConfig().inWorldBarsEnabled() || entity.getSelfAndPassengers().anyMatch(passenger -> passenger == Minecraft.getInstance().player) && !TESAPI.getConfig().inWorldHudForSelf() || !TESAPI.getConfig().inWorldHUDActivation().test(entityState) || !TESAPI.getConfig().inWorldHudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(!entity.level().tickRateManager().isEntityFrozen((Entity)entity));
        float hudOpacity = TESAPI.getConfig().inWorldHudOpacity();
        Minecraft mc = Minecraft.getInstance();
        Vec3 position = entity.getPosition(partialTick).subtract(mc.gameRenderer.getMainCamera().getPosition()).add(mc.getEntityRenderDispatcher().getRenderer((Entity)entity).getRenderOffset((Entity)entity, partialTick));
        poseStack.pushPose();
        poseStack.translate(position.x, position.y, position.z);
        poseStack.translate(0.0f, entity.getBbHeight() + 0.5f, 0.0f);
        poseStack.translate(0.0f, TESConstants.CONFIG.inWorldHudManualVerticalOffset(), 0.0f);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(0.02f, 0.02f, 0.02f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        GuiGraphics guiGraphics = TESClientUtil.createInlineGuiGraphics(poseStack, mc.renderBuffers().bufferSource());
        guiGraphics.pose().pushPose();
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(guiGraphics, mc, deltaTracker, entity, hudOpacity, true);
            if (offset <= 0) continue;
            guiGraphics.pose().translate(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        guiGraphics.flush();
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public static void pickNewEntity(float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.crosshairPickEntity != null) {
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(mc.crosshairPickEntity);
            if (target != null && TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            AABB hitBounds;
            Vec3 cameraView;
            Vec3 rayEnd;
            Vec3 cameraPos;
            double targetingRange = TESAPI.getConfig().getHudTargetDistance();
            Entity cameraEntity = mc.getCameraEntity();
            EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)cameraEntity, (Vec3)(cameraPos = cameraEntity.getEyePosition(partialTick)), (Vec3)(rayEnd = cameraPos.add((cameraView = cameraEntity.getViewVector(partialTick)).multiply(targetingRange, targetingRange, targetingRange))), (AABB)(hitBounds = cameraEntity.getBoundingBox().expandTowards(cameraView.scale(targetingRange)).inflate(1.0, 1.0, 1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.getEntity());
            if (target == null || !TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.getLocation().distanceToSqr(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.add(cameraView.multiply(targetingRange, targetingRange, targetingRange));
            BlockHitResult blockHitResult = cameraEntity.level().clip(new ClipContext(cameraPos, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cameraEntity));
            if (blockHitResult == null || blockHitResult.getType() == HitResult.Type.MISS || blockHitResult.getLocation().distanceToSqr(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    public static List<TESHudEntityIcon> getEntityIcons() {
        return ENTITY_ICONS;
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        BAR_ICONS,
        COMBINED;

    }
}

