/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;

public enum TESHudPosition {
    TOP_LEFT(guiGraphics -> {}),
    CENTER_TOP(guiGraphics -> guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f - 21.0f - (float)TESAPI.getConfig().hudHealthBarLength() / 2.0f, 0.0f, 0.0f)),
    TOP_RIGHT(guiGraphics -> guiGraphics.pose().translate((float)(guiGraphics.guiWidth() - 42 - TESAPI.getConfig().hudHealthBarLength()), 0.0f, 0.0f)),
    CENTER_RIGHT(guiGraphics -> guiGraphics.pose().translate((float)(guiGraphics.guiWidth() - 42 - TESAPI.getConfig().hudHealthBarLength()), (float)guiGraphics.guiHeight() / 2.0f - 22.5f, 0.0f)),
    BOTTOM_RIGHT(guiGraphics -> guiGraphics.pose().translate((float)(guiGraphics.guiWidth() - 42 - TESAPI.getConfig().hudHealthBarLength()), (float)(guiGraphics.guiHeight() - 50), 0.0f)),
    BOTTOM_LEFT(guiGraphics -> guiGraphics.pose().translate(0.0f, (float)(guiGraphics.guiHeight() - 50), 0.0f)),
    CENTER_LEFT(guiGraphics -> guiGraphics.pose().translate(0.0f, (float)guiGraphics.guiHeight() / 2.0f - 22.5f, 0.0f));

    private final Consumer<GuiGraphics> renderAdjuster;

    private TESHudPosition(Consumer<GuiGraphics> renderAdjuster) {
        this.renderAdjuster = renderAdjuster;
    }

    public void adjustRenderForHudPosition(GuiGraphics guiGraphics) {
        TESConfig config = TESAPI.getConfig();
        this.renderAdjuster.accept(guiGraphics);
        guiGraphics.pose().translate((float)config.hudPositionLeftAdjust(), (float)config.hudPositionTopAdjust(), 0.0f);
    }
}

