/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking.packet;

import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.state.EntityState;
import org.joml.Vector3f;

public record NewComponentParticlePacket(int entityId, Component contents, Vector3f position) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<NewComponentParticlePacket> TYPE = new CustomPacketPayload.Type(TESConstants.id("new_component_particle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NewComponentParticlePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, NewComponentParticlePacket::entityId, (StreamCodec)ComponentSerialization.STREAM_CODEC, NewComponentParticlePacket::contents, (StreamCodec)ByteBufCodecs.VECTOR3F, NewComponentParticlePacket::position, NewComponentParticlePacket::new);

    public NewComponentParticlePacket(LivingEntity entity, Component contents) {
        this(entity.getId(), contents, new Vector3f((float)entity.getX(), (float)entity.getEyeY(), (float)entity.getZ()));
    }

    public NewComponentParticlePacket(Vector3f position, Component contents) {
        this(-1, contents, position);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            if (this.entityId == -1) {
                TESParticleManager.addParticle(new ComponentParticle(null, this.position, this.contents));
            } else {
                EntityState entityState = TESAPI.getTESDataForEntity(this.entityId);
                if (entityState != null) {
                    TESParticleManager.addParticle(new ComponentParticle(entityState, this.position, this.contents));
                }
            }
        });
    }
}

