/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.DamageParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.particle.type.HealParticle;
import org.joml.Vector3f;

public class EntityState {
    protected final WeakReference<LivingEntity> entity;
    protected Set<Holder<MobEffect>> effects;
    protected float currentHealth;
    protected float lastHealth;
    protected float lastTransitionHealth;
    protected long lastTransitionTime;
    protected WeakReference<DamageSource> lastDamageSource;
    protected int lastRenderTick;

    public EntityState(LivingEntity entity) {
        this.entity = new WeakReference<LivingEntity>(entity);
        this.lastHealth = this.currentHealth = entity.getHealth();
        this.lastRenderTick = entity.tickCount;
        if (TESConstants.CONFIG.isSyncingEffects()) {
            TESConstants.NETWORKING.requestEffectsSync(entity.getId());
        }
    }

    public LivingEntity getEntity() {
        return (LivingEntity)this.entity.get();
    }

    public float getHealth() {
        return this.currentHealth;
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastTransitionHealth() {
        return this.lastTransitionHealth;
    }

    public float getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Set<Holder<MobEffect>> getEffects() {
        return this.effects == null ? Set.of() : this.effects;
    }

    public void modifyEffects(Set<Holder<MobEffect>> ids, Set<Holder<MobEffect>> idsToRemove) {
        if (this.effects == null) {
            this.effects = new ObjectOpenHashSet(ids);
        } else {
            this.effects.addAll(ids);
        }
        this.effects.removeAll(idsToRemove);
    }

    public void markActive() {
        this.lastRenderTick = this.getEntity().tickCount;
    }

    public boolean isValid() {
        LivingEntity entity = this.getEntity();
        return entity != null && !entity.isRemoved() && entity.level() == Minecraft.getInstance().level && (this.lastRenderTick < 0 || this.lastRenderTick >= entity.tickCount - 200);
    }

    public void tick() {
        LivingEntity entity = this.getEntity();
        this.currentHealth = Math.min(entity.getHealth(), entity.getMaxHealth());
        if (this.currentHealth != this.lastHealth && entity.tickCount > 2) {
            this.handleHealthChange();
            this.lastDamageSource = new WeakReference<DamageSource>(entity.getLastDamageSource());
        }
        this.lastHealth = this.currentHealth;
        if (entity.level().getGameTime() - this.lastTransitionTime > 20L) {
            if (this.lastTransitionHealth > this.currentHealth) {
                this.lastTransitionHealth -= this.getEntity().getMaxHealth() / 30.0f;
            } else {
                this.lastTransitionTime = 0L;
                this.lastTransitionHealth = this.currentHealth;
            }
        }
    }

    protected void handleHealthChange() {
        if (TESAPI.getConfig().particlesEnabled()) {
            GenericTESParticle particle;
            boolean damageSourceAccurate;
            LivingEntity entity = this.getEntity();
            float healthDelta = this.currentHealth - this.lastHealth;
            boolean bl = damageSourceAccurate = entity.getLastDamageSource() != null && this.lastDamageSource != null && this.lastDamageSource.get() != entity.getLastDamageSource();
            if (healthDelta != 0.0f) {
                healthDelta = TESParticleManager.handleParticleClaims(this, healthDelta, TESParticleManager::addParticle, damageSourceAccurate);
            }
            if (healthDelta == 0.0f) {
                return;
            }
            Vector3f particlePos = new Vector3f((float)this.getEntity().getX(), (float)this.getEntity().getEyeY(), (float)this.getEntity().getZ());
            if (healthDelta < 0.0f) {
                LivingEntity attacker;
                int teamColour;
                Entity entity2;
                this.lastTransitionTime = this.getEntity().level().getGameTime();
                int colour = TESAPI.getConfig().getDamageParticleColour();
                if (this.lastTransitionHealth == 0.0f) {
                    this.lastTransitionHealth = this.lastHealth;
                }
                if (damageSourceAccurate && TESAPI.getConfig().teamBasedDamageParticleColours() && (entity2 = this.getEntity().getLastDamageSource().getEntity()) instanceof LivingEntity && (teamColour = (attacker = (LivingEntity)entity2).getTeamColor()) != 0xFFFFFF) {
                    colour = teamColour;
                }
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth <= 0.0f && this.lastHealth >= this.getEntity().getMaxHealth() ? new ComponentParticle(this, particlePos, TESParticle.Animation.POP_OFF, (Component)Component.translatable((String)"config.tes.particle.verbal.instakill").setStyle(Style.EMPTY.withColor(colour))) : new DamageParticle(this, particlePos, -healthDelta).withColour(colour);
            } else {
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth >= this.getEntity().getMaxHealth() && this.lastHealth <= this.getEntity().getMaxHealth() * 0.05f ? new ComponentParticle(this, particlePos, TESParticle.Animation.RISE, (Component)Component.translatable((String)"config.tes.particle.verbal.fullHeal").setStyle(Style.EMPTY.withColor(TESAPI.getConfig().getHealParticleColour()))) : new HealParticle(this, particlePos, healthDelta);
            }
            TESParticleManager.addParticle(particle);
        }
    }
}

