/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class IAnimatedMonster
extends Monster {
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(IAnimatedMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean dropAfterDeathAnim = false;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private Player killDataAttackingPlayer;
    public int attackTicks;
    public int attackCooldown;
    public int customDeathTime;

    public IAnimatedMonster(EntityType entity, Level world) {
        super(entity, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)input);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public static void setConfigattribute(LivingEntity entity, double hpconfig, double dmgconfig) {
        AttributeInstance attackDamageAttr;
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            double difference = maxHealthAttr.m_22115_() * hpconfig - maxHealthAttr.m_22115_();
            maxHealthAttr.m_22118_(new AttributeModifier(UUID.fromString("9513569b-57b6-41f5-814e-bdc49b81799f"), "Health config multiplier", difference, AttributeModifier.Operation.ADDITION));
            entity.m_21153_(entity.m_21233_());
        }
        if ((attackDamageAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double difference = attackDamageAttr.m_22115_() * dmgconfig - attackDamageAttr.m_22115_();
            attackDamageAttr.m_22118_(new AttributeModifier(UUID.fromString("5b17d7cb-294e-4379-88ab-136c372bec9b"), "Attack config multiplier", difference, AttributeModifier.Operation.ADDITION));
        }
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.m_20189_() - first.m_20189_(), second.m_20185_() - first.m_20185_()) * 57.29577951308232 + 90.0;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
        livingEntity.m_5810_();
        livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.m_6087_() || entity.f_19794_) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.m_20334_(-0.1 * Math.cos(angle), entity.m_20184_().f_82480_, -0.1 * Math.sin(angle));
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_5803_() || this.m_20365_(entityIn) || entityIn.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.m_20160_() && this.canBePushedByEntity(entityIn)) {
                this.m_5997_(-d0, 0.0, -d1);
            }
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }
}

