/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.custom.Cloud_GolemEntity;
import net.miauczel.legendary_monsters.entity.custom.Falling_CloudEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.phys.Vec3;

public class Cloud_GolemAttackGoal
extends MeleeAttackGoal {
    private final Cloud_GolemEntity entity;
    private int attackDelay = 20;
    private int ticksUntilNextAttack = 20;
    private boolean shouldCountTillNextAttack = false;

    public Cloud_GolemAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (Cloud_GolemEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 20;
        this.ticksUntilNextAttack = 20;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                SoundEvent customAttackSound = SoundEvents.f_11867_;
                if (!this.entity.isAngry()) {
                    this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.f_25540_.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                }
                this.entity.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 5;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.entity.isAngry()) {
            return pDistToEnemySqr <= 30.0;
        }
        return pDistToEnemySqr <= 60.0;
    }

    protected void m_25563_() {
        this.f_25540_.m_21051_(Attributes.f_22279_).m_22100_(0.1);
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        if (this.entity.isAngry()) {
            if (pEnemy instanceof Player || pEnemy instanceof ServerPlayer) {
                this.entity.attackTargets((Entity)pEnemy);
            } else {
                this.f_25540_.m_7327_((Entity)pEnemy);
            }
        }
        if (this.entity.isAngry()) {
            SoundEvent customAttackSound = (SoundEvent)ModSounds.ENDERSENT_ATTACK.get();
            this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (this.f_25540_.m_5448_() != null && !this.f_25540_.m_5448_().m_21224_()) {
            if (!this.entity.isAngry()) {
                this.f_25540_.m_21051_(Attributes.f_22279_).m_22100_(0.1);
                this.summonCloud();
            } else {
                Vec3 entityPosition = this.f_25540_.m_5448_().m_20182_();
                CameraShakeEntity.cameraShake(this.f_25540_.m_5448_().m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
                this.summonLightningBolt();
            }
        }
        if (pEnemy instanceof Player) {
            Player player = (Player)pEnemy;
            if (this.entity.isAngry() && player.m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
                Item shieldItem;
                Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
                if (!player.m_36335_().m_41519_(shieldItem)) {
                    player.m_36335_().m_41524_(shieldItem, 70);
                    if (player.m_21254_()) {
                        player.m_5810_();
                    }
                }
            }
        }
    }

    private void summonLightningBolt() {
        BlockPos targetPos = this.f_25540_.m_5448_().m_20183_();
        EntityType entityType = EntityType.f_20465_;
        LightningBolt newEntity = (LightningBolt)entityType.m_20615_(this.f_25540_.m_9236_());
        if (newEntity != null) {
            newEntity.m_6034_((double)targetPos.m_123341_(), (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_());
            this.f_25540_.m_9236_().m_7967_((Entity)newEntity);
        }
    }

    private void summonCloud() {
        if (this.f_25540_.m_5448_() != null && !this.f_25540_.m_5448_().m_21224_()) {
            BlockPos targetPos = this.f_25540_.m_5448_().m_20183_();
            EntityType entityType = (EntityType)ModEntities.FALLING_CLOUD.get();
            Falling_CloudEntity newEntity = (Falling_CloudEntity)entityType.m_20615_(this.f_25540_.m_9236_());
            if (newEntity != null) {
                newEntity.m_6034_(targetPos.m_123341_(), targetPos.m_123342_() + 3, targetPos.m_123343_());
                newEntity.m_5602_((Entity)this.f_25540_);
                this.f_25540_.m_9236_().m_7967_((Entity)newEntity);
            }
        }
        if (!this.f_25540_.m_5448_().m_21254_()) {
            // empty if block
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        this.f_25540_.m_21051_(Attributes.f_22279_).m_22100_(0.1);
        super.m_8041_();
    }
}

