/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.custom.PosessedPaladinEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PosessedPaladinAttackGoal
extends MeleeAttackGoal {
    private final PosessedPaladinEntity entity;
    private int attackDelay = 16;
    private int ticksUntilNextAttack = 16;
    private boolean shouldCountTillNextAttack = false;
    private boolean hasPlayedAttackSound = false;

    public PosessedPaladinAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (PosessedPaladinEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 13;
        this.ticksUntilNextAttack = 13;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation() && !this.hasPlayedAttackSound) {
                SoundEvent customAttackSound1 = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                SoundEvent customAttackSound2 = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK2.get();
                if (Math.random() < 0.5) {
                    this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound1, SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 1.0f, 0.8f);
                }
                this.entity.setAttacking(true);
                this.hasPlayedAttackSound = true;
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.hasPlayedAttackSound = false;
                this.performAttack(pEnemy);
                this.entity.onSmashAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.hasPlayedAttackSound = false;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= 32.5;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    public void Attack2Hurt(LivingEntity target) {
        Holder.Reference mobAttackDamageType = this.f_25540_.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_);
        DamageSource damageSource = new DamageSource((Holder)mobAttackDamageType);
        target.m_6469_(damageSource, 5.0f);
    }

    protected void performAttack(LivingEntity pEnemy) {
        Player player;
        this.m_25563_();
        if (pEnemy instanceof Player || pEnemy instanceof ServerPlayer) {
            this.entity.attackTargets((Entity)pEnemy);
        } else {
            this.f_25540_.m_7327_((Entity)pEnemy);
        }
        this.entity.performAreaAttack();
        SoundEvent customAttackSound2 = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
        SoundEvent customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK.get();
        Vec3 entityPosition = this.f_25540_.m_5448_().m_20182_();
        CameraShakeEntity.cameraShake(this.f_25540_.m_5448_().m_9236_(), entityPosition, 10.0f, 0.1f, 0, 20);
        if (!this.f_25540_.m_5448_().m_21254_()) {
            // empty if block
        }
        if (this.entity.canStun() && this.f_25540_.m_5448_().m_21254_() && !this.f_25540_.m_5448_().m_21023_((MobEffect)ModEffects.STUN.get())) {
            this.entity.resetStunCooldown();
        }
        if (Math.random() < 0.5) {
            this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound2, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (!this.f_25540_.m_5448_().m_21254_() && ((Boolean)ModConfig.MOB_CONFIG.AllowPosessedPaladinStun.get()).booleanValue() && !this.f_25540_.m_5448_().m_21023_((MobEffect)ModEffects.STUN.get()) && this.entity.canStun()) {
            this.entity.resetStunCooldown();
            SoundEvent customAttackSound3 = SoundEvents.f_11668_;
            this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound3, SoundSource.NEUTRAL, 1.0f, 0.5f);
        }
        PosessedPaladinEntity.Crackiness crackiness = this.entity.getCrackiness();
        if (!this.f_25540_.m_5448_().m_21254_()) {
            MobEffectInstance brokenArmorEffect;
            if (Math.random() < 0.5 && crackiness == PosessedPaladinEntity.Crackiness.MEDIUM || crackiness == PosessedPaladinEntity.Crackiness.HIGH) {
                this.f_25540_.m_5448_().m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), 100, 0));
            }
            if ((brokenArmorEffect = this.f_25540_.m_5448_().m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get())) != null) {
                int currentLevel = brokenArmorEffect.m_19564_();
                if (currentLevel < 6) {
                    this.f_25540_.m_5448_().m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 100, currentLevel + 1));
                } else {
                    this.f_25540_.m_5448_().m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 100, 4));
                }
            } else {
                this.f_25540_.m_5448_().m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 100, 0));
            }
        }
        this.destroyBlocksAround(pEnemy.m_20183_());
        this.destroyBlocksAround2(pEnemy.m_20183_());
        this.destroyBlocksAround3(pEnemy.m_20183_());
        if (pEnemy instanceof Player && (player = (Player)pEnemy).m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
            Item shieldItem;
            Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
            if (!player.m_36335_().m_41519_(shieldItem)) {
                player.m_36335_().m_41524_(shieldItem, 60);
                if (player.m_21254_()) {
                    player.m_5810_();
                }
            }
        }
    }

    private void destroyBlocksAround3(BlockPos centerPos) {
        Level level = this.f_25540_.m_9236_();
        if (level instanceof ServerLevel) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos pos = centerPos.m_7918_(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (state.m_60795_() || block.m_155943_() == -1.0f) continue;
                        level.m_46953_(pos, true, (Entity)this.f_25540_);
                    }
                }
            }
        }
    }

    private void destroyBlocksAround(BlockPos centerPos) {
        Level level = this.f_25540_.m_9236_();
        if (level instanceof ServerLevel) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 0; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos pos = centerPos.m_7918_(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (state.m_60795_() || block.m_155943_() == -1.0f) continue;
                        level.m_46953_(pos, true, (Entity)this.f_25540_);
                    }
                }
            }
        }
    }

    private void destroyBlocksAround2(BlockPos centerPos) {
        Level level = this.f_25540_.m_9236_();
        if (level instanceof ServerLevel) {
            for (int x = -2; x <= 2; ++x) {
                for (int y = 2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos pos = centerPos.m_7918_(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (state.m_60795_() || block.m_155943_() == -1.0f) continue;
                        level.m_46953_(pos, true, (Entity)this.f_25540_);
                    }
                }
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
        this.hasPlayedAttackSound = false;
    }
}

