/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.ai.Cloud_GolemAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.Ancient_GuardianEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Cloud_GolemEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Cloud_GolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(Cloud_GolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int STUN_COOLDOWN_DURATION = 100;
    private int stunCooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final double HITBOX_RADIUS = 3.0;
    private static final double HITBOX_HEIGHT = 2.0;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState slamattackAnimationState = new AnimationState();
    public int slamattackAnimationStateTimeout = 0;
    private float prevYaw;
    private boolean DiedOnce = false;
    int newTextureVariant = -1;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 40;

    public void resetStunCooldown() {
        this.stunCooldown = 100;
    }

    public boolean canStun() {
        return this.stunCooldown <= 0;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public Cloud_GolemEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    public boolean hasRespawned() {
        return this.DiedOnce;
    }

    public void m_20095_() {
        this.m_7311_(0);
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.DeathAnimationState.m_216984_()) {
            --this.DeathAnimationTimeout;
            if (this.DeathAnimationTimeout <= 0) {
                this.DeathAnimationState.m_216973_();
            }
        }
        if (this.isAngry() && this.stunCooldown > 0) {
            System.out.println("StunCooldown: " + this.stunCooldown);
            --this.stunCooldown;
        }
        if (this.m_21223_() <= 0.0f && !this.DiedOnce) {
            this.setAttacking(false);
            this.m_5634_(this.m_21233_());
            if (this.m_6060_()) {
                this.m_20095_();
                this.m_5825_();
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public boolean isAngry() {
        return this.getTextureVariant() >= 1;
    }

    private void setupAnimationStates() {
        if (this.DeathAnimationTimeout >= 40) {
            if (this.dragonDeathTime > 0 && !this.DeathAnimationState.m_216984_()) {
                this.DeathAnimationState.m_216977_(this.f_19797_);
                --this.DeathAnimationTimeout;
                this.stopAllOtherAnimations();
            }
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
            if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 39;
                this.slamattackAnimationStateTimeout = 39;
                if (this.getTextureVariant() >= 1) {
                    this.slamattackAnimationState.m_216977_(this.f_19797_);
                } else {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                }
            } else {
                --this.attackAnimationTimeout;
                --this.slamattackAnimationStateTimeout;
            }
            if (!this.isAttacking() && this.attackAnimationTimeout <= 0 && this.slamattackAnimationStateTimeout <= 0) {
                this.attackAnimationState.m_216973_();
                this.slamattackAnimationState.m_216973_();
            }
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Cloud_GolemAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Ancient_GuardianEntity.class, true));
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_5448_().m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof CameraShakeEntity || !this.isAngry()) continue;
            this.m_7327_((Entity)livingEntity);
        }
    }

    public void attackTargets(Entity entity1) {
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 14.0 * (Double)ModConfig.MOB_CONFIG.CloudGolemDamageMutliplier.get();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity1;
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 5.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 13.0));
            }
        }
    }

    public void m_6667_(DamageSource source) {
        if (this.m_21223_() <= 0.0f && !this.DiedOnce) {
            this.m_21153_(this.m_21233_());
            this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)1);
            this.setAttacking(false);
            this.DiedOnce = true;
            return;
        }
        this.setAttacking(false);
        super.m_6667_(source);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
        this.m_19983_(emerald);
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("DiedOnce", this.DiedOnce);
        compound.m_128405_("TextureVariant", this.getTextureVariant());
        compound.m_128405_("StunCooldown", this.stunCooldown);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)ModConfig.MOB_CONFIG.Cloudprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunCooldown = compound.m_128451_("StunCooldown");
        this.DiedOnce = compound.m_128471_("DiedOnce");
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)compound.m_128451_("TextureVariant"));
        if (this.m_21223_() == this.m_21233_()) {
            double newHealth = 100.0 * (Double)ModConfig.MOB_CONFIG.CloudGolemHealthMultiplier.get();
            this.m_21051_(Attributes.f_22276_).m_22100_(newHealth);
            if (this.DiedOnce) {
                this.m_21153_((float)newHealth);
            }
        }
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 25) {
            Vec3 vec3 = this.m_20182_();
        }
        if (this.dragonDeathTime == 40 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.AIR_RUNE.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.LGspawnatlocation(diamond);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    private void stopAllOtherAnimations() {
        this.attackAnimationState.m_216973_();
        this.slamattackAnimationState.m_216973_();
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static Cloud_GolemEntity entity;
        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            if (entity.hasRespawned()) {
                for (Crackiness crackiness : BY_DAMAGE) {
                    if (!(pFraction < crackiness.fraction)) continue;
                    return crackiness;
                }
                return NONE;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

