/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.ChoruslingEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EndersentEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(EndersentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 35;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final double HITBOX_RADIUS = 3.0;
    private static final double HITBOX_HEIGHT = 2.0;
    private float prevYaw;
    private static final int TELEPORT_COOLDOWN_DURATION = 140;
    private int teleportCooldown = 0;
    private int smashCooldown = 0;
    private final int SMASH_COOLDOWN = 60;
    public int bigsmashCooldown = 0;
    public final int SMASH_ANCHOR_COOLDOWN = 60;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState attackarm1AnimationState = new AnimationState();
    public AnimationState attackarm2AnimationState = new AnimationState();
    public AnimationState attackarmsAnimationState = new AnimationState();
    public AnimationState attackTeleportAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int endersentDeathTime;

    public EndersentEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 40;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = 60;
        }
    }

    public void resetSmashAnchorCooldown() {
        if (this.bigsmashCooldown <= 0) {
            this.bigsmashCooldown = 60;
        }
    }

    @Override
    public void m_8119_() {
        this.updateWithAttack();
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.bigsmashCooldown > 0) {
            --this.bigsmashCooldown;
        }
        super.m_8119_();
        this.updateAttributes();
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof ChoruslingEntity || entity instanceof CameraShakeEntity) continue;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CHORUSINFECTION.get(), 60, 0));
            this.m_7327_((Entity)livingEntity);
        }
    }

    public boolean m_142066_() {
        return !this.isSleep() && super.m_142066_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 45, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EndersentEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && EndersentEntity.this.bigsmashCooldown <= 0 && EndersentEntity.this.m_5448_() != null && EndersentEntity.this.getAttackState() != 3;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EndersentEntity.this.resetSmashAnchorCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 45, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EndersentEntity.this.m_217043_().m_188501_() * 50.0f < 16.0f && EndersentEntity.this.smashCooldown <= 0 && EndersentEntity.this.m_5448_() != null && EndersentEntity.this.getAttackState() != 4;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EndersentEntity.this.resetSmashCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 45, 64, 5.0f));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 45, 30, 12.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EndersentEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && EndersentEntity.this.teleportCooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EndersentEntity.this.teleportCooldown = 160;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f));
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 16.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.EndersentHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.EndersentDamageMultiplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 200.0;
        double baseAttackDamage = 16.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENDERSENT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ENDERSENT_HURT1.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENDERSENT_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setAttackState(7);
        ItemStack diamond = new ItemStack((ItemLike)ModItems.CHORUS_CRYSTAL.get(), 1);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        this.m_19983_(emerald);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.teleportRandomly();
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public int deathtimer() {
        return 60;
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "attackarmright") {
            return this.attackarm1AnimationState;
        }
        if (input == "attackarmleft") {
            return this.attackarm2AnimationState;
        }
        if (input == "attackarms") {
            return this.attackarmsAnimationState;
        }
        if (input == "attackteleport") {
            return this.attackTeleportAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackarm1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackarm2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.attackTeleportAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.attackarmsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.attackarmsAnimationState.m_216973_();
        this.attackTeleportAnimationState.m_216973_();
        this.attackarm1AnimationState.m_216973_();
        this.attackarm2AnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    private void teleportToTarget(LivingEntity target) {
        double targetPosX = target.m_20185_();
        double targetPosY = target.m_20186_();
        double targetPosZ = target.m_20189_();
        this.m_6021_(targetPosX, targetPosY, targetPosZ);
        System.out.println("X:" + targetPosX + "2Y:" + targetPosY + "Z:" + targetPosZ + "2");
    }

    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    private void teleportRandomly() {
        Vec3 entityPos = this.m_20182_();
        Level level = this.m_9236_();
        for (int i = 0; i < 10; ++i) {
            double x = entityPos.m_7096_() + (this.m_217043_().m_188500_() - 0.5) * 14.0;
            double z = entityPos.m_7094_() + (this.m_217043_().m_188500_() - 0.5) * 14.0;
            double y = entityPos.m_7098_();
            int ix = Mth.m_14107_((double)x);
            int iz = Mth.m_14107_((double)z);
            int iy = Mth.m_14107_((double)y);
            if (!level.m_46859_(new BlockPos(ix, iy, iz)) || level.m_8055_(new BlockPos(ix, iy - 1, iz)).m_60795_()) continue;
            this.m_6021_(x, y, z);
            return;
        }
    }

    private void updateWithAttack() {
        Vec3 entityPosition;
        if (this.getAttackState() == 7) {
            if (this.attackTicks == 17) {
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
            if (this.attackTicks == 58) {
                this.LGspawnatlocation(((Item)ModItems.CHORUS_CRYSTAL.get()).m_7968_());
                this.LGspawnatlocation(Items.f_42003_.m_7968_());
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 17) {
                this.m_20331_(true);
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.teleportToTarget(target);
                }
            }
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                this.m_20331_(false);
                this.AreaAttack(7.0f, 4.0f, 140.0f, 12.0f, 40, false, 0.5f, true, 0.25f, true);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
            if (this.attackTicks == 29) {
                this.teleportRandomly();
            }
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                this.m_20331_(false);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
                this.AreaAttack(7.0f, 4.0f, 120.0f, 15.0f, 40, false, 0.5f, true, 0.25f, true);
            }
            if (this.attackTicks == 29) {
                this.teleportRandomly();
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                this.m_20331_(false);
                this.AreaAttack(7.0f, 4.0f, 120.0f, 12.0f, 40, false, 0.5f, true, 0.25f, true);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
            if (this.attackTicks == 29) {
                this.teleportRandomly();
            }
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                this.m_20331_(false);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
                this.AreaAttack(7.0f, 4.0f, 120.0f, 12.0f, 40, false, 0.5f, true, 0.25f, true);
            }
            if (this.attackTicks == 29) {
                this.teleportRandomly();
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof EndersentEntity || entityHit instanceof ChoruslingEntity || entityHit == this) continue;
            if (!stun && !entityHit.m_21254_() && Math.random() > 0.5) {
                entityHit.m_147207_(new MobEffectInstance((MobEffect)ModEffects.CHORUSINFECTION.get(), 40, 2), (Entity)this);
            }
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.EndersentDamageMultiplier.get()));
            if (launch) {
                entityHit.m_20256_(new Vec3(0.0, (double)Lstrenght, 0.0));
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            EndersentEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @javax.annotation.Nullable SpawnGroupData p_29681_, @javax.annotation.Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    protected void m_6153_() {
        ++this.endersentDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.endersentDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.endersentDeathTime == 20) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.endersentDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.CHORUS_CRYSTAL.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }
}

